/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.gui.application.NewConceptDialog;
import edu.udo.cs.miningmart.gui.application.ProjectionTransitionTool;
import edu.udo.cs.miningmart.gui.application.RelationTransitionTool;
import edu.udo.cs.miningmart.gui.application.SubConceptTransitionTool;
import edu.udo.cs.miningmart.gui.model.MiningMartConcept;
import edu.udo.cs.miningmart.gui.model.MiningMartConcepts;
import edu.udo.cs.miningmart.gui.model.MiningMartProjection;
import edu.udo.cs.miningmart.gui.model.MiningMartRelation;
import edu.udo.cs.miningmart.gui.model.MiningMartSubConcept;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.Tool;
import org.jhotdraw.standard.AbstractTool;
import org.musoft.limo.application.MyToolButton;
import org.musoft.limo.application.Resource;
import org.musoft.limo.application.ToolBar;
import org.musoft.limo.model.ModelFigureElement;

public class ConceptToolPanel
extends ToolBar {
    private MiningMartApplication app;
    private JPanel stuff_panel;
    private JPanel toppanel;
    private JPanel toolpanel;
    private JScrollPane scrollpane;
    private JLayeredPane layerpane;
    private Vector groups;
    private Vector groupstoolbars;

    public ConceptToolPanel(MiningMartApplication app) {
        super(app);
        this.app = app;
        this.groups = new Vector();
        this.groupstoolbars = new Vector();
        this.initComponents();
    }

    private void initComponents() {
        this.initStuffPanel();
        this.toolpanel = new JPanel();
        GridLayout grid = new GridLayout(this.groups.size(), 1);
        grid.setHgap(4);
        grid.setVgap(4);
        this.toolpanel.setLayout(grid);
        for (int index = 0; index < this.groupstoolbars.size(); ++index) {
            String groupname = (String)this.groups.get(index);
            ToolBar toolbar = (ToolBar)this.groupstoolbars.get(index);
            toolbar.addGroup(groupname);
            toolbar.showGroup(groupname, 0);
            toolbar.setPreferredSize(new Dimension(40, 40));
            toolbar.setFloatable(false);
            this.toolpanel.add(toolbar);
        }
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BorderLayout());
        panel2.add((Component)this.toolpanel, "North");
        this.scrollpane = new JScrollPane(panel2);
        this.toppanel = new JPanel(){

            public String toString() {
                return Resource.getString("COMP_CONCEPTTOOLS");
            }
        };
        this.toppanel.setLayout(new BorderLayout());
        this.toppanel.add((Component)this.scrollpane, "Center");
    }

    private void initStuffPanel() {
        Object tool = new MyAbstractTool(Resource.getString("TOOL_CONCEPT"), this.parent){

            public void mouseDown(MouseEvent e, int x, int y) {
                NewConceptDialog dialog;
                super.mouseDown(e, x, y);
                ModelFigureElement p = ConceptToolPanel.this.getPotentialParent(x, y, this.drawing());
                MiningMartConcept s = null;
                if (p instanceof MiningMartConcepts) {
                    dialog = new NewConceptDialog(ConceptToolPanel.this.app);
                    if (dialog.getExitAction() == dialog.CANCEL) {
                        this.editor().toolDone();
                        return;
                    }
                } else {
                    this.editor().toolDone();
                    return;
                }
                s = ((MiningMartConcepts)p).createMiningMartConcept(p, dialog.getNewConceptName(), new Point(x, y), dialog.getConceptType());
                this.editor().toolDone();
                if (s != null) {
                    ConceptToolPanel.this.parent.selectFigure(s);
                    M4Interface.print.doPrint(Print.COMPILER_CASE_CONTROL, Resource.getString("INSERTED_NEW_CONCEPT") + " " + s.getName());
                }
            }
        };
        MyToolButton button = this.createMyToolButton(Resource.getString("TOOLIMG_CONCEPT"), Resource.getString("TOOL_CONCEPT"), (Tool)tool);
        ((JComponent)((Object)button)).setToolTipText(Resource.getString("TOOL_CONCEPT"));
        this.add("concept", (JButton)((Object)button));
        tool = new SubConceptTransitionTool((MiningMartApplication)this.parent, MiningMartSubConcept.class, MiningMartConcept.class, "outgoing", MiningMartConcept.class, "incoming");
        this.add("concept", (JButton)((Object)this.createMyToolButton(Resource.getString("TOOLIMG_SUBCONCEPT"), Resource.getString("TOOL_SUBCONCEPT"), (Tool)tool)));
        tool = new RelationTransitionTool((MiningMartApplication)this.parent, MiningMartRelation.class, MiningMartConcept.class, "outgoing", MiningMartConcept.class, "incoming");
        this.add("concept", (JButton)((Object)this.createMyToolButton(Resource.getString("TOOLIMG_RELATION"), Resource.getString("TOOL_RELATION"), (Tool)tool)));
        tool = new ProjectionTransitionTool((MiningMartApplication)this.parent, MiningMartProjection.class, MiningMartConcept.class, "outgoing", MiningMartConcept.class, "incoming");
        this.add("concept", (JButton)((Object)this.createMyToolButton(Resource.getString("TOOLIMG_PROJECTION"), Resource.getString("TOOL_PROJECTION"), (Tool)tool)));
    }

    public Component add(String groupname, JButton button) {
        if (this.groups.contains(groupname)) {
            int index = this.groups.indexOf(groupname);
            ToolBar bar = (ToolBar)this.groupstoolbars.remove(index);
            bar.addButton(groupname, button);
            this.groupstoolbars.insertElementAt(bar, index);
        } else {
            this.groups.add(groupname);
            ToolBar bar = new ToolBar(this.app);
            bar.removeAll();
            bar.addButton(groupname, button);
            this.groupstoolbars.add(bar);
        }
        return button;
    }

    public JPanel getConceptToolPanel() {
        return this.toppanel;
    }

    private class MyAbstractTool
    extends AbstractTool {
        private String name;

        public MyAbstractTool(String name, DrawingEditor drawingeditor) {
            super(drawingeditor);
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

