/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.musoft.limo.application.Resource;

public class ConceptFromTableDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public final int CANCEL = 0;
    public final int OK = 1;
    private int exitAction;
    private JButton ok;
    private JButton cancel;
    private JList tables;
    private String singleSelectedConcept;
    private String[] selectedObjects;
    private String tableExtension;
    private String viewExtension;
    private boolean singleSelectionRequired;
    private MiningMartApplication app;
    private String includeMmTablesText;

    public ConceptFromTableDialog(MiningMartApplication parent, boolean selectOnlyOne) {
        super(parent, Resource.getString("DIALOG_CONCEPTFROMTABLE_TITLE"), true);
        this.app = parent;
        this.exitAction = 0;
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.singleSelectionRequired = selectOnlyOne;
        this.pack();
        this.setSize(250, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public void initComponents() {
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok = new JButton(Resource.getString("OK"));
        this.ok.setEnabled(false);
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        String text = this.singleSelectionRequired ? Resource.getString("DIALOG_CONCEPTFROMTABLE_TABLE_SINGLE") : Resource.getString("DIALOG_CONCEPTFROMTABLE_TABLE_MULT");
        JLabel label = new JLabel(text);
        top_panel.add((Component)label, "North");
        String[] tablenames = this.getListOfDbObjects(false);
        this.tables = new JList<String>(tablenames);
        if (!this.singleSelectionRequired) {
            this.tables.setSelectionMode(2);
        }
        this.tables.addListSelectionListener(this);
        JPanel center = new JPanel();
        center.setLayout(new BorderLayout(5, 5));
        JScrollPane scrollpane = new JScrollPane(this.tables);
        this.includeMmTablesText = Resource.getString("CONNECTION_SHOW_MM_TABLES");
        JCheckBox useTrashObjectsBox = new JCheckBox(this.includeMmTablesText);
        useTrashObjectsBox.setSelected(false);
        useTrashObjectsBox.setToolTipText(Resource.getString("CONNECTION_SHOW_MM_TABLES_TIP"));
        useTrashObjectsBox.addActionListener(this);
        center.add((Component)scrollpane, "Center");
        center.add((Component)useTrashObjectsBox, "South");
        top_panel.add((Component)center, "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        top_panel.add((Component)bottom, "South");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    private String[] getListOfDbObjects(boolean includeMmTables) {
        Vector colls = new Vector();
        try {
            colls.addAll(MiningMartApplication.m4Interface.getNamesOfBusinessTablesAndViews(includeMmTables));
            Collections.sort(colls);
        }
        catch (M4Exception error) {
            JOptionPane.showMessageDialog(this.app, "Error when reading tables and views from business schema:\n" + error.getMessage(), "DB error", 0);
            return new String[0];
        }
        Iterator iter = colls.iterator();
        String[] tablenames = new String[colls.size()];
        int index = 0;
        this.tableExtension = " (" + Resource.getString("TABLE") + ")";
        this.viewExtension = " (" + Resource.getString("VIEW") + ")";
        while (iter.hasNext()) {
            tablenames[index] = (String)iter.next();
            try {
                if (MiningMartApplication.m4Interface.isBusinessTable(tablenames[index])) {
                    int n = index;
                    tablenames[n] = tablenames[n] + this.tableExtension;
                } else if (MiningMartApplication.m4Interface.isBusinessView(tablenames[index])) {
                    int n = index;
                    tablenames[n] = tablenames[n] + this.viewExtension;
                }
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            ++index;
        }
        return tablenames;
    }

    public void actionPerformed(ActionEvent event) {
        JCheckBox source;
        String cmd = event.getActionCommand();
        if (event.getSource() instanceof JCheckBox && (source = (JCheckBox)event.getSource()).getText().equals(this.includeMmTablesText)) {
            boolean includeTables = source.isSelected();
            String[] listOfTableNames = this.getListOfDbObjects(includeTables);
            this.tables.setListData(listOfTableNames);
        }
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        }
        if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            Object[] selection = this.tables.getSelectedValues();
            if (selection == null) {
                this.selectedObjects = null;
            } else {
                this.selectedObjects = new String[selection.length];
                for (int i = 0; i < selection.length; ++i) {
                    this.selectedObjects[i] = (String)selection[i];
                    int index = -1;
                    index = this.selectedObjects[i].indexOf(this.tableExtension);
                    if (index > -1) {
                        this.selectedObjects[i] = this.selectedObjects[i].substring(0, index);
                    }
                    index = -1;
                    index = this.selectedObjects[i].indexOf(this.viewExtension);
                    if (index <= -1) continue;
                    this.selectedObjects[i] = this.selectedObjects[i].substring(0, index);
                }
                if (this.selectedObjects != null && this.selectedObjects.length > 0) {
                    this.singleSelectedConcept = this.selectedObjects[0];
                }
            }
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.tables.isSelectionEmpty()) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public String getTableName() {
        if (this.exitAction == 1) {
            return this.singleSelectedConcept;
        }
        return null;
    }

    public String[] getSelectionOfTables() {
        if (this.exitAction == 1) {
            return this.selectedObjects;
        }
        return null;
    }

    public String[] getSelectedObjects() {
        if (this.exitAction == 1) {
            return this.selectedObjects;
        }
        return null;
    }
}

