/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.gui.application;

import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.gui.application.MiningMartApplication;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.M4Interface;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.musoft.limo.application.Resource;

public class ConceptFromCaseDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    public final int CANCEL = 0;
    public final int OK = 1;
    private int exitAction = 0;
    private JButton ok;
    private JButton cancel;
    private JList cases;
    private JList concepts;
    private String thecase;
    private String concept;
    private Case the_case = null;
    private String[] casenames;
    private String[] conceptnames;

    public ConceptFromCaseDialog(MiningMartApplication parent) {
        super(parent, Resource.getString("DIALOG_CONCEPTFROMCASE_TITLE"), true);
        this.initComponents();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(450, 300);
        Dimension size = this.getSize();
        this.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - size.width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - size.height) / 2);
        this.setVisible(true);
    }

    public void initComponents() {
        JPanel top_panel = new JPanel();
        top_panel.setLayout(new BorderLayout(5, 5));
        this.cancel = new JButton(Resource.getString("CANCEL"));
        this.ok = new JButton(Resource.getString("OK"));
        this.ok.setEnabled(false);
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        Collection coll = null;
        try {
            coll = MiningMartApplication.m4Interface.getAllCaseNames();
        }
        catch (M4Exception error) {
            M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
        }
        if (coll == null) {
            return;
        }
        Iterator iter = coll.iterator();
        this.casenames = new String[coll.size() - 1];
        int index = 0;
        while (iter.hasNext()) {
            String next = (String)iter.next();
            if (next.equals(M4Interface.getCurrentCase().getName())) {
                next = (String)iter.next();
            }
            this.casenames[index] = next;
            ++index;
        }
        this.cases = new JList<String>(this.casenames);
        this.cases.addListSelectionListener(this);
        JScrollPane scrollpane = new JScrollPane(this.cases);
        JPanel casepanel = new JPanel();
        casepanel.setLayout(new BorderLayout());
        casepanel.add((Component)scrollpane, "Center");
        JLabel label = new JLabel(Resource.getString("DIALOG_CONCEPTFROMCASE_CASE"));
        casepanel.add((Component)label, "North");
        this.concepts = new JList<String>(new String[0]);
        this.concepts.addListSelectionListener(this);
        scrollpane = new JScrollPane(this.concepts);
        JPanel conceptpanel = new JPanel();
        conceptpanel.setLayout(new BorderLayout());
        conceptpanel.add((Component)scrollpane, "Center");
        label = new JLabel(Resource.getString("DIALOG_CONCEPTFROMCASE_CONCEPT"));
        conceptpanel.add((Component)label, "North");
        JPanel listpanel = new JPanel();
        listpanel.setLayout(new GridLayout(1, 2, 5, 5));
        listpanel.add(casepanel);
        listpanel.add(conceptpanel);
        top_panel.add((Component)listpanel, "Center");
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 0));
        bottom.add(Box.createHorizontalGlue());
        bottom.add(this.ok);
        bottom.add(Box.createRigidArea(new Dimension(10, 0)));
        bottom.add(this.cancel);
        top_panel.add((Component)bottom, "South");
        top_panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add(top_panel);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(Resource.getString("CANCEL"))) {
            this.exitAction = 0;
            this.dispose();
        }
        if (cmd.equals(Resource.getString("OK"))) {
            this.exitAction = 1;
            this.thecase = (String)this.cases.getSelectedValue();
            this.concept = (String)this.concepts.getSelectedValue();
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.cases) && !this.cases.isSelectionEmpty()) {
            this.thecase = (String)this.cases.getSelectedValue();
            try {
                if (this.the_case == null) {
                    M4Interface.print.doPrint(Print.ERROR, "valueChanged called");
                    this.the_case = MiningMartApplication.m4Interface.findCaseForReadOnlyAccess(this.thecase, false);
                } else if (!this.the_case.getName().equals(this.thecase)) {
                    M4Interface.print.doPrint(Print.ERROR, "valueChanged called");
                    MiningMartApplication.m4Interface.releaseCaseWithoutStoring(this.the_case.getName());
                    this.the_case = MiningMartApplication.m4Interface.findCaseForReadOnlyAccess(this.thecase, false);
                }
                Object[] obj = this.the_case.getAllConceptNames().toArray();
                this.conceptnames = new String[obj.length];
                for (int i = 0; i < obj.length; ++i) {
                    this.conceptnames[i] = (String)obj[i];
                }
                this.concepts.setListData(this.conceptnames);
            }
            catch (M4Interface.CaseLockedException error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
            catch (M4Exception error) {
                M4Interface.print.doPrint(Print.ERROR, error.getMessage(), error);
            }
        }
        if (!this.cases.isSelectionEmpty() && !this.concepts.isSelectionEmpty()) {
            this.ok.setEnabled(true);
        } else {
            this.ok.setEnabled(false);
        }
    }

    public int getExitAction() {
        return this.exitAction;
    }

    public Case getTheCase() {
        if (this.exitAction == 1) {
            return this.the_case;
        }
        return null;
    }

    public String getConceptName() {
        if (this.exitAction == 1) {
            return this.concept;
        }
        return null;
    }
}

