/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.db;

import edu.udo.cs.miningmart.db.DbCore;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.M4InterfaceContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.postgresql.Driver;

public class DbCorePostgres
extends DbCore {
    public static final String POSTGRES_TYPE_NUMBER = "NUMERIC";
    public static final String POSTGRES_TYPE_STRING = "VARCHAR";
    public static final String POSTGRES_TYPE_CHAR = "CHAR";
    public static final String POSTGRES_TYPE_DATE = "DATE";
    public static final String POSTGRES_TYPE_TIME = "TIME";
    public static final String POSTGRES_TYPE_TIMESTAMP = "TIMESTAMP";
    public static final String POSTGRES_TYPE_TEXT = "TEXT";
    private final String nameOfM4Sequence = "all_sq";

    public DbCorePostgres(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean isM4Schema) throws SQLException {
        super(url, "/" + dbName, user, passwd, cal, isM4Schema);
        this.mySchemaName = user;
    }

    protected void registerJDBC_Driver() throws SQLException {
        DriverManager.registerDriver((java.sql.Driver)new Driver());
    }

    String jdbcDriverClassName() {
        return "org.postgresql.Driver";
    }

    String installDir() {
        return "postgres";
    }

    String getDateComparisonAsSqlString(String oneDate, String secondDate, boolean greater, boolean orEqual, String timeFormat) {
        String conversionOfColumn = "to_timestamp(to_char(" + oneDate + ", '" + timeFormat + "'), '" + timeFormat + "')";
        String conversionOfDateExpression = "to_timestamp('" + secondDate + "', '" + timeFormat + "')";
        String ret = conversionOfColumn + " " + this.getComparisonOp(greater, orEqual) + " " + conversionOfDateExpression;
        return ret;
    }

    public short getDbms() {
        return 2;
    }

    protected void switchAutocommitOff(Connection con) throws SQLException {
        this.openTransactionBlock();
    }

    public void commitTransactions() throws SQLException {
        super.commitTransactions();
        this.openTransactionBlock();
    }

    String getTableOwner() {
        return this.getUser();
    }

    protected long getNextM4SequenceValue(Statement stmt) throws M4Exception {
        String query = "select nextval('" + this.nameOfM4Sequence + "')";
        Long nextval = null;
        String sqle = "";
        try {
            nextval = this.executeSingleValueSqlReadL(query, stmt);
        }
        catch (SQLException e) {
            sqle = "\nAn SQLException occured during invocation:\n" + e.getMessage();
        }
        if (nextval == null) {
            String msg = "Error in method DbCorePostgres.getNextM4SequenceValue(Statement):\nSequence '" + this.nameOfM4Sequence + "' did not return a value!" + sqle;
            throw new M4Exception(msg);
        }
        return nextval;
    }

    long getNextM4SequenceValue() throws DbConnectionClosed, M4Exception {
        try {
            Statement stmt = this.getDbReadStatement();
            return this.getNextM4SequenceValue(stmt);
        }
        catch (SQLException e) {
            String msg = "Error in method DbCore.getNextM4SequenceValue():\nCould not create Statement:\n" + e.getMessage();
            throw new M4Exception(msg);
        }
    }

    public String getSelectStringAllTables() {
        String ret = "SELECT UPPER(relname) FROM pg_class, pg_user WHERE relkind='r'AND SUBSTRING(relname FROM 1 FOR 3) != 'pg_'";
        if (this.getTableOwner() != null) {
            ret = ret + " AND relowner = pg_user.usesysid AND pg_user.usename = '" + this.getTableOwner() + "'";
        }
        return ret;
    }

    public String getSelectStringDistribValuesTimeColumn(String colSql, String tableName, String distribBase) {
        if (colSql == null || tableName == null || distribBase == null) {
            return null;
        }
        String query = "SELECT TO_CHAR(" + colSql + ", '" + distribBase + "')," + " COUNT(*)," + " TO_CHAR(MIN(" + colSql + "), '" + distribBase + "')," + " TO_CHAR(MAX(" + colSql + "), '" + distribBase + "')" + " FROM " + tableName + " WHERE (" + colSql + ") IS NOT NULL" + " GROUP BY TO_CHAR(" + colSql + ", '" + distribBase + "')" + " ORDER BY TO_CHAR(" + colSql + ", '" + distribBase + "')";
        return query;
    }

    public String getSelectStringAllViews() {
        String ret = "SELECT UPPER(relname) FROM pg_class, pg_user WHERE relkind='v'AND SUBSTRING(relname FROM 1 FOR 3) != 'pg_'";
        if (this.getTableOwner() != null) {
            ret = ret + " AND relowner = pg_user.usesysid AND pg_user.usename = '" + this.getTableOwner() + "'";
        }
        return ret;
    }

    public String getSelectStringAllColumnsForDbObject(String dbObjectName) {
        return "SELECT attname, typname FROM pg_attribute, pg_type, pg_class WHERE attrelid = pg_class.oid AND atttypid = pg_type.oid AND attname != 'tableoid' AND attname != 'cmax' AND attname != 'xmax' AND attname != 'cmin' AND attname != 'xmin' AND attname != 'oid' AND attname != 'ctid' AND relname = '" + dbObjectName.toLowerCase() + "'";
    }

    private String getSelectStringOnlyColumnsForDbObject(String dbObjectName) {
        return "SELECT attname FROM pg_attribute, pg_class WHERE attrelid = pg_class.oid AND attname != 'tableoid' AND attname != 'cmax' AND attname != 'xmax' AND attname != 'cmin' AND attname != 'xmin' AND attname != 'oid' AND attname != 'ctid' AND relname = '" + dbObjectName.toLowerCase() + "'";
    }

    public long getNumberOfMonthsBetween(String dbObjectName, String firstValue, String secondValue) throws M4Exception {
        try {
            String yearQuery = "SELECT date_part('year', " + firstValue + ") FROM " + dbObjectName;
            Long firstYear = this.executeSingleValueSqlReadL(yearQuery);
            yearQuery = "SELECT date_part('year', " + secondValue + ") FROM " + dbObjectName;
            Long secondYear = this.executeSingleValueSqlReadL(yearQuery);
            if (firstYear == null || secondYear == null) {
                return 0L;
            }
            long yearDiff = firstYear - secondYear;
            if (yearDiff < 0L) {
                yearDiff *= -1L;
            }
            String monthQuery = "SELECT date_part('month', " + firstValue + ") FROM " + dbObjectName;
            Long firstMonth = this.executeSingleValueSqlReadL(monthQuery);
            monthQuery = "SELECT date_part('month', " + secondValue + ") FROM " + dbObjectName;
            Long secondMonth = this.executeSingleValueSqlReadL(monthQuery);
            if (firstMonth == null || secondMonth == null) {
                return 0L;
            }
            long monthDiff = firstMonth - secondMonth;
            if (monthDiff < 0L) {
                monthDiff *= -1L;
            }
            return yearDiff * 12L + monthDiff;
        }
        catch (SQLException s) {
            throw new M4Exception("Sql error trying to compute number of months between '" + firstValue + "' and '" + secondValue + "': " + s.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("No connection to DB when trying to compute number of months between '" + firstValue + "' and '" + secondValue + "': " + d.getMessage());
        }
    }

    public boolean tableExists(String tableName) throws M4Exception {
        String query = "SELECT oid FROM pg_class, pg_user WHERE relkind='r' AND relname='" + tableName.toLowerCase() + "'";
        if (this.getTableOwner() != null) {
            query = query + " AND relowner = pg_user.usesysid AND pg_user.usename = '" + this.getTableOwner() + "'";
        }
        Long l = null;
        try {
            this.commitTransactions();
            l = this.executeSingleValueSqlReadL(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error testing if table '" + tableName + "' exists: " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB connection error when testing if table '" + tableName + "' exists: " + d.getMessage());
        }
        return l != null;
    }

    public String getSelectStringColumnDataTypes(String dbObjectName, String owner, String columnName) {
        String ret = "SELECT typname FROM pg_attribute, pg_type, pg_class, pg_user WHERE attrelid = pg_class.oid AND atttypid = pg_type.oid AND relowner = pg_user.usesysid AND attname != 'tableoid' AND attname != 'cmax' AND attname != 'xmax' AND attname != 'cmin' AND attname != 'xmin' AND attname != 'oid' AND attname != 'ctid' AND relname = '" + dbObjectName.toLowerCase() + "' AND attname = '" + columnName.toLowerCase() + "'";
        if (owner != null) {
            ret = ret + " AND usename = '" + owner.toLowerCase() + "'";
        }
        return ret;
    }

    public Collection getPrimaryKeyColumnNames(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = "SELECT indkey FROM pg_index, pg_class WHERE pg_class.oid =indrelid AND relname = '" + dbObjectName.toLowerCase() + "' AND indisprimary='t'";
        ResultSet rs = this.executeSqlRead(query);
        String colNos = null;
        if (rs.next()) {
            colNos = rs.getString(1);
        }
        rs.close();
        if (colNos == null) {
            return new Vector();
        }
        query = this.getSelectStringOnlyColumnsForDbObject(dbObjectName);
        rs = this.executeSqlRead(query);
        int noOfCols = 0;
        Vector<String> theColumns = new Vector<String>();
        while (rs.next()) {
            String colName = rs.getString(1);
            theColumns.add(colName);
            ++noOfCols;
        }
        rs.close();
        Vector thePrimaryKeyColumns = new Vector();
        StringTokenizer st = new StringTokenizer(colNos);
        int nextPrimaryKeyColNumber = -1;
        while (st.hasMoreTokens()) {
            nextPrimaryKeyColNumber = Integer.parseInt(st.nextToken());
            thePrimaryKeyColumns.add(theColumns.get(nextPrimaryKeyColNumber - 1));
        }
        if (thePrimaryKeyColumns.isEmpty()) {
            return null;
        }
        return thePrimaryKeyColumns;
    }

    public Map getTablesReferencedBy(String dbObjectName) throws SQLException, DbConnectionClosed {
        Map columnsToTableLists = this.getKeyLinks(dbObjectName, true);
        HashMap<String, String> columnsToTables = new HashMap<String, String>();
        Set entries = columnsToTableLists.entrySet();
        for (Map.Entry entry : entries) {
            String colName = (String)entry.getKey();
            Collection oneList = (Collection)entry.getValue();
            if (oneList == null) continue;
            Iterator tableIt = oneList.iterator();
            String tableName = tableIt.hasNext() ? (String)tableIt.next() : null;
            columnsToTables.put(colName, tableName);
        }
        return columnsToTables;
    }

    private Map getKeyLinks(String dbObjectName, boolean useAsReferencing) throws SQLException, DbConnectionClosed {
        int positionWithSearchedTable;
        dbObjectName = dbObjectName.toLowerCase();
        String query = this.getSelectStringAllColumnsForDbObject(dbObjectName);
        ResultSet rs = this.executeSqlRead(query);
        HashMap myMap = new HashMap();
        while (rs.next()) {
            myMap.put(rs.getString(1), null);
        }
        rs.close();
        query = "SELECT tgargs, tgconstrrelid FROM pg_trigger, pg_class WHERE pg_class.oid = pg_trigger.tgrelid and pg_class.relname = '" + dbObjectName + "'";
        rs = this.executeSqlRead(query);
        int positionWithGivenTable = useAsReferencing ? 1 : 2;
        int n = positionWithSearchedTable = useAsReferencing ? 2 : 1;
        while (rs.next()) {
            String argumentsOfTrigger = rs.getString(1);
            String[] args = this.getArguments(argumentsOfTrigger);
            if (args.length < positionWithGivenTable + 1 || !args[positionWithGivenTable].equalsIgnoreCase(dbObjectName)) continue;
            String searchedTable = args[positionWithSearchedTable];
            if (args.length <= 4) continue;
            int noOfKeyCols = (args.length - 4) / 2;
            for (int i = 0; i < noOfKeyCols; ++i) {
                int positionOfColumn = useAsReferencing ? i + 4 : i + 4 + noOfKeyCols;
                String columnName = args[positionOfColumn];
                Vector<String> listOfTables = (Vector<String>)myMap.get(columnName);
                if (listOfTables == null) {
                    listOfTables = new Vector<String>();
                    myMap.put(columnName, listOfTables);
                }
                if (listOfTables.contains(searchedTable)) continue;
                listOfTables.add(searchedTable);
            }
        }
        rs.close();
        return myMap;
    }

    public Map getTablesReferringTo(String dbObjectName) throws SQLException, DbConnectionClosed {
        return this.getKeyLinks(dbObjectName, false);
    }

    private String[] getArguments(String postgresTriggerArgs) {
        int i = 0;
        Vector<String> allArgs = new Vector<String>();
        String currentArg = "";
        while (i < postgresTriggerArgs.length()) {
            if (postgresTriggerArgs.charAt(i) == '\\') {
                i += 4;
                allArgs.add(currentArg);
                currentArg = "";
                continue;
            }
            currentArg = currentArg + postgresTriggerArgs.charAt(i);
            ++i;
        }
        String[] ret = new String[allArgs.size()];
        i = 0;
        for (Object e : allArgs) {
            ret[i] = (String)e;
            ++i;
        }
        return ret;
    }

    public String getTableOrViewType(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = "SELECT relkind FROM pg_class WHERE relname = '" + dbObjectName.toLowerCase() + "'";
        String type = this.executeSingleValueSqlRead(query);
        if (type.equalsIgnoreCase("v")) {
            return "V";
        }
        if (type.equalsIgnoreCase("r")) {
            return "T";
        }
        return null;
    }

    public String getAttributeForColumnNames() {
        return "attname";
    }

    public String getAttributeForColumnTypes() {
        return "typname";
    }

    public String getUniqueRowIdentifier() {
        return "oid";
    }

    public String getPowerExpression(String base, String exponent) {
        return "(" + base + "^" + exponent + ")";
    }

    public String getFloorExpression() {
        return "TRUNC";
    }

    public String getRoundToDecimalPlacesExpression() {
        return "TRUNC";
    }

    public String getAliasExpressionForInnerSelects(String aliasName) {
        return " AS " + aliasName;
    }

    public String getDatatypeName(String m4RelDatatypeName, int size) {
        String ret = null;
        if (m4RelDatatypeName.equals("NUMBER")) {
            ret = POSTGRES_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals(POSTGRES_TYPE_DATE)) {
            ret = POSTGRES_TYPE_DATE;
        } else if (m4RelDatatypeName.equals("KEY")) {
            ret = POSTGRES_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals("STRING")) {
            ret = POSTGRES_TYPE_STRING;
        }
        if (ret != null && size > 0) {
            ret = ret + "(" + size + ")";
        }
        return ret;
    }

    public String getM4DatatypeName(String dbmsDatatypeName) {
        if ((dbmsDatatypeName = dbmsDatatypeName.toUpperCase()).equals(POSTGRES_TYPE_NUMBER)) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("FLOAT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("INT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_DATE) || dbmsDatatypeName.equals(POSTGRES_TYPE_TIME) || dbmsDatatypeName.equals(POSTGRES_TYPE_TIMESTAMP)) {
            return POSTGRES_TYPE_DATE;
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_STRING)) {
            return "STRING";
        }
        if (dbmsDatatypeName.equals(POSTGRES_TYPE_TEXT)) {
            return "STRING";
        }
        return null;
    }

    public boolean dropRelation(String tableName) throws M4Exception {
        boolean tableExists = this.tableExists(tableName);
        if (tableExists) {
            String sql_drop = "DROP TABLE " + tableName;
            try {
                this.executeSqlWrite(sql_drop);
            }
            catch (SQLException sqle) {
                throw new M4Exception("Error trying to remove the table '" + tableName + "':\n" + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4Exception("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
            }
        }
        return tableExists;
    }

    private void openTransactionBlock() {
    }

    public String getTestQuery() {
        return this.getSelectStringAllTables();
    }

    public String createPrimaryKeyConstraint(String tableName, Collection pkAttributeNames, String dbConstraintName) throws SQLException, DbConnectionClosed {
        if (dbConstraintName == null || dbConstraintName.trim().length() == 0) {
            dbConstraintName = tableName + "_PK";
        }
        String commaSeparatedKeyNames = DbCorePostgres.stringCollectionToCommaSeparated(pkAttributeNames);
        String sql = "ALTER TABLE " + tableName + " ADD CONSTRAINT " + dbConstraintName + " PRIMARY KEY (" + commaSeparatedKeyNames + ")";
        this.executeSqlWrite(sql);
        return dbConstraintName;
    }

    public void createForeignKeyConstraint(String fkTableName, Collection fkAttributeNames, String pkTableName, Collection pkAttributeNames, String dbConstraintName) throws SQLException, DbConnectionClosed {
        String fkNamesComma = DbCorePostgres.stringCollectionToCommaSeparated(fkAttributeNames);
        String pkNamesComma = DbCorePostgres.stringCollectionToCommaSeparated(pkAttributeNames);
        String sql = "ALTER TABLE " + fkTableName + " ADD CONSTRAINT " + dbConstraintName + " FOREIGN KEY (" + fkNamesComma + ") REFERENCES " + pkTableName + "(" + pkNamesComma + ")";
        this.executeSqlWrite(sql);
    }
}

