/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.db;

import edu.udo.cs.miningmart.db.DbCore;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.M4InterfaceContext;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.driver.OracleDriver;

public class DbCoreOracle
extends DbCore {
    public static final String ORACLE_TYPE_NUMBER = "NUMBER";
    public static final String ORACLE_TYPE_STRING = "VARCHAR2";
    public static final String ORACLE_TYPE_DATE = "DATE";
    public static final String ORACLE_TYPE_CHAR = "CHAR";
    public static final String ORACLE_TYPE_LONG = "LONG";

    public DbCoreOracle(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean isM4Schema) throws SQLException {
        super(url, dbName, user, passwd, cal, isM4Schema);
        this.mySchemaName = user;
    }

    public short getDbms() {
        return 1;
    }

    protected void registerJDBC_Driver() throws SQLException {
        DriverManager.registerDriver((Driver)new OracleDriver());
    }

    String jdbcDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    String installDir() {
        return "oracle";
    }

    String getDateComparisonAsSqlString(String oneDate, String secondDate, boolean greater, boolean orEqual, String timeFormat) {
        String conversionOfColumn = "to_date(to_char(" + oneDate + ", '" + timeFormat + "'), '" + timeFormat + "')";
        String conversionOfDateExpression = "to_date('" + secondDate + "', '" + timeFormat + "')";
        String ret = conversionOfColumn + " " + this.getComparisonOp(greater, orEqual) + " " + conversionOfDateExpression;
        return ret;
    }

    protected void switchAutocommitOff(Connection con) throws SQLException {
        con.setAutoCommit(false);
    }

    protected long getNextM4SequenceValue(Statement stmt) throws M4Exception {
        String query = "select all_sq.nextval from dual";
        Long nextval = null;
        String sqle = "";
        try {
            nextval = this.executeSingleValueSqlReadL(query, stmt);
        }
        catch (SQLException e) {
            sqle = "\nAn SQLException occured during invokation:\n" + e.getMessage();
        }
        if (nextval == null) {
            String msg = "Error in method DbCore.getNextM4SequenceValue(Statement):\nSequence 'all_sq.nextval' did not return a value!" + sqle;
            throw new M4Exception(msg);
        }
        return nextval;
    }

    long getNextM4SequenceValue() throws DbConnectionClosed, M4Exception {
        try {
            Statement stmt = this.getDbReadStatement();
            return this.getNextM4SequenceValue(stmt);
        }
        catch (SQLException e) {
            String msg = "Error in method DbCore.getNextM4SequenceValue():\nCould not create Statement:\n" + e.getMessage();
            throw new M4Exception(msg);
        }
    }

    String getTableOwner() {
        return this.getUser();
    }

    public String getSelectStringAllTables() {
        return "SELECT UPPER(TABLE_NAME) FROM USER_TABLES";
    }

    public boolean tableExists(String tableName) throws M4Exception {
        String query = "SELECT table_name FROM user_tables WHERE table_name='" + tableName.toUpperCase() + "'";
        String s = null;
        try {
            this.commitTransactions();
            s = this.executeSingleValueSqlRead(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error testing if table '" + tableName + "' exists: " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB connection error when testing if table '" + tableName + "' exists: " + d.getMessage());
        }
        return s != null;
    }

    public String getSelectStringAllViews() {
        return "SELECT UPPER(VIEW_NAME) FROM USER_VIEWS";
    }

    public String getSelectStringAllColumnsForDbObject(String dbObjectName) {
        return "SELECT column_name, data_type FROM USER_TAB_COLUMNS WHERE table_name = '" + dbObjectName.toUpperCase() + "'";
    }

    public String getSelectStringDistribValuesTimeColumn(String colSql, String tableName, String distribBase) {
        if (colSql == null || tableName == null || distribBase == null) {
            return null;
        }
        String query = "SELECT TO_CHAR(" + colSql + ", '" + distribBase + "')," + " COUNT(*)," + " TO_CHAR(MIN(" + colSql + "), '" + distribBase + "')," + " TO_CHAR(MAX(" + colSql + "), '" + distribBase + "')" + " FROM " + tableName + " WHERE (" + colSql + ") IS NOT NULL" + " GROUP BY TO_CHAR(" + colSql + ", '" + distribBase + "')" + " ORDER BY TO_CHAR(" + colSql + ", '" + distribBase + "')";
        return query;
    }

    public String getSelectStringColumnDataTypes(String dbObjectName, String owner, String columnName) {
        String ret = "SELECT data_type FROM ALL_TAB_COLUMNS WHERE table_name = '" + dbObjectName.toUpperCase() + "' AND column_name = '" + columnName.toUpperCase() + "'";
        if (owner != null) {
            ret = ret + " AND owner = '" + owner.toUpperCase() + "'";
        }
        return ret;
    }

    public long getNumberOfMonthsBetween(String dbObjectName, String firstValue, String secondValue) throws M4Exception {
        try {
            String que = "SELECT MONTHS_BETWEEN(" + firstValue + ", " + secondValue + ") FROM " + dbObjectName;
            Long monthL = this.executeSingleValueSqlReadL(que);
            long monthBetween = monthL == null ? 0L : monthL;
            return monthBetween;
        }
        catch (SQLException s) {
            throw new M4Exception("Sql error trying to compute number of months between '" + firstValue + "' and '" + secondValue + "': " + s.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("No connection to DB when trying to compute number of months between '" + firstValue + "' and '" + secondValue + "': " + d.getMessage());
        }
    }

    public Collection getPrimaryKeyColumnNames(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = "SELECT column_name FROM user_cons_columns, user_constraints WHERE user_constraints.constraint_name = user_cons_columns.constraint_name AND user_constraints.constraint_type = 'P' AND user_cons_columns.table_name = '" + dbObjectName.toUpperCase() + "'";
        ResultSet rs = this.executeSqlRead(query);
        Vector<String> ret = new Vector<String>();
        while (rs.next()) {
            ret.add(rs.getString(1));
        }
        rs.close();
        if (ret.isEmpty()) {
            return null;
        }
        return ret;
    }

    public Map getTablesReferencedBy(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = "SELECT constraint_name, r_constraint_name FROM user_constraints WHERE table_name = '" + dbObjectName + "' AND constraint_type = 'R'";
        ResultSet rs = this.executeSqlRead(query);
        HashMap<String, String> myMap = new HashMap<String, String>();
        while (rs.next()) {
            String constr = rs.getString(1);
            String ref = rs.getString(2);
            String innerQuery = "SELECT table_name FROM user_constraints WHERE constraint_name = '" + ref + "'";
            String foreignTableName = this.executeSingleValueSqlRead(innerQuery);
            if (foreignTableName == null) continue;
            innerQuery = "SELECT column_name FROM user_cons_columns WHERE user_cons_columns.constraint_name = '" + constr + "'";
            ResultSet rs2 = this.executeSqlRead(innerQuery);
            while (rs2.next()) {
                String columnName = rs2.getString(1);
                myMap.put(columnName, foreignTableName);
            }
            rs2.close();
        }
        rs.close();
        return myMap;
    }

    public Map getTablesReferringTo(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = "SELECT constraint_name FROM user_constraints WHERE table_name = '" + dbObjectName + "' AND constraint_type = 'P'";
        String pkConstraintName = this.executeSingleValueSqlRead(query);
        query = "SELECT constraint_name, table_name FROM user_constraints WHERE r_constraint_name = '" + pkConstraintName + "'";
        ResultSet rs = this.executeSqlRead(query);
        HashMap myMap = new HashMap();
        while (rs.next()) {
            String constrName = rs.getString(1);
            String foreignTableName = rs.getString(2);
            if (foreignTableName == null) continue;
            String innerQuery = "SELECT column_name FROM user_cons_columns WHERE user_cons_columns.constraint_name = '" + constrName + "'";
            ResultSet rs2 = this.executeSqlRead(innerQuery);
            while (rs2.next()) {
                String columnName = rs2.getString(1);
                Vector<String> listOfTables = (Vector<String>)myMap.get(columnName);
                if (listOfTables == null) {
                    listOfTables = new Vector<String>();
                    myMap.put(columnName, listOfTables);
                }
                if (listOfTables.contains(foreignTableName)) continue;
                listOfTables.add(foreignTableName);
            }
            rs2.close();
        }
        rs.close();
        return myMap;
    }

    public String getTableOrViewType(String dbObjectName) throws SQLException, DbConnectionClosed {
        dbObjectName = dbObjectName.toUpperCase();
        String query = "SELECT table_name FROM user_tables WHERE table_name = '" + dbObjectName + "'";
        String result = this.executeSingleValueSqlRead(query);
        if (result == null) {
            query = "SELECT view_name FROM user_views WHERE view_name = '" + dbObjectName + "'";
            result = this.executeSingleValueSqlRead(query);
            if (result == null) {
                return null;
            }
            return "V";
        }
        return "T";
    }

    public String getAttributeForColumnNames() {
        return "COLUMN_NAME";
    }

    public String getAttributeForColumnTypes() {
        return "DATA_TYPE";
    }

    public String getUniqueRowIdentifier() {
        return "ROWNUM";
    }

    public String getPowerExpression(String base, String exponent) {
        return "POWER(" + base + ", " + exponent + ")";
    }

    public String getFloorExpression() {
        return "TRUNC";
    }

    public String getRoundToDecimalPlacesExpression() {
        return "ROUND";
    }

    public String getAliasExpressionForInnerSelects(String aliasName) {
        return "";
    }

    public String getDatatypeName(String m4RelDatatypeName, int size) {
        String ret = null;
        if (m4RelDatatypeName.equals(ORACLE_TYPE_NUMBER)) {
            ret = ORACLE_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals(ORACLE_TYPE_DATE)) {
            ret = ORACLE_TYPE_DATE;
        } else if (m4RelDatatypeName.equals("KEY")) {
            ret = ORACLE_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals("STRING")) {
            ret = ORACLE_TYPE_STRING;
        }
        if (ret != null && size > 0) {
            ret = ret + "(" + size + ")";
        }
        return ret;
    }

    public String getM4DatatypeName(String dbmsDatatypeName) {
        if ((dbmsDatatypeName = dbmsDatatypeName.toUpperCase()).equals(ORACLE_TYPE_NUMBER)) {
            return ORACLE_TYPE_NUMBER;
        }
        if (dbmsDatatypeName.equals(ORACLE_TYPE_DATE)) {
            return ORACLE_TYPE_DATE;
        }
        if (dbmsDatatypeName.equals(ORACLE_TYPE_STRING)) {
            return "STRING";
        }
        if (dbmsDatatypeName.equals(ORACLE_TYPE_CHAR)) {
            return "STRING";
        }
        if (dbmsDatatypeName.equals(ORACLE_TYPE_LONG)) {
            return ORACLE_TYPE_NUMBER;
        }
        return null;
    }

    public boolean dropRelation(String tableName) throws M4Exception {
        boolean tableExists = this.tableExists(tableName);
        if (tableExists) {
            String sql_drop = "DROP TABLE " + tableName;
            try {
                this.executeSqlWrite(sql_drop);
            }
            catch (SQLException sqle) {
                throw new M4Exception("Error trying to remove the table '" + tableName + "':\n" + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4Exception("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
            }
        }
        return tableExists;
    }

    public String getTestQuery() {
        return "SELECT 0 FROM DUAL";
    }

    public String createPrimaryKeyConstraint(String tableName, Collection pkAttributeNames, String dbConstraintName) throws SQLException, DbConnectionClosed {
        if (dbConstraintName == null || dbConstraintName.trim().length() == 0) {
            dbConstraintName = tableName + "_PK";
        }
        String commaSeparatedKeyNames = DbCoreOracle.stringCollectionToCommaSeparated(pkAttributeNames);
        String sql = "ALTER TABLE " + tableName + " ADD CONSTRAINT " + dbConstraintName + " PRIMARY KEY (" + commaSeparatedKeyNames + ")";
        this.executeSqlWrite(sql);
        return dbConstraintName;
    }

    public void createForeignKeyConstraint(String fkTableName, Collection fkAttributeNames, String pkTableName, Collection pkAttributeNames, String dbConstraintName) throws SQLException, DbConnectionClosed {
        String fkNamesComma = DbCoreOracle.stringCollectionToCommaSeparated(fkAttributeNames);
        String pkNamesComma = DbCoreOracle.stringCollectionToCommaSeparated(pkAttributeNames);
        String sql = "ALTER TABLE " + fkTableName + " ADD CONSTRAINT " + dbConstraintName + " FOREIGN KEY (" + fkNamesComma + ") REFERENCES " + pkTableName + " (" + pkNamesComma + ")";
        this.executeSqlWrite(sql);
    }
}

