/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.db;

import com.mysql.jdbc.Driver;
import edu.udo.cs.miningmart.db.DbCore;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.M4InterfaceContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DbCoreMysql
extends DbCore {
    public static final String MYSQL_TYPE_NUMBER = "DOUBLE";
    public static final String MYSQL_TYPE_INTEGER = "INTEGER";
    public static final String MYSQL_TYPE_STRING = "VARCHAR";
    public static final String MYSQL_TYPE_CHAR = "CHAR";
    public static final String MYSQL_TYPE_DATE = "DATE";
    public static final String MYSQL_TYPE_TIME = "TIME";
    public static final String MYSQL_TYPE_TIMESTAMP = "DATETIME";
    public static final String MYSQL_TYPE_TEXT = "TEXT";

    public DbCoreMysql(String url, String dbName, String user, String passwd, M4InterfaceContext cal, boolean isM4Schema) throws SQLException {
        super(url, "/" + dbName, user, passwd, cal, isM4Schema);
        this.mySchemaName = dbName;
    }

    protected void registerJDBC_Driver() throws SQLException {
        DriverManager.registerDriver((java.sql.Driver)new Driver());
    }

    String jdbcDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    String getDateComparisonAsSqlString(String oneDate, String secondDate, boolean greater, boolean orEqual, String timeFormat) {
        String ret = "DATEDIFF(" + oneDate + ", '" + secondDate + "') " + this.getComparisonOp(greater, orEqual) + " 0";
        return ret;
    }

    public short getDbms() {
        return 3;
    }

    String installDir() {
        return "mysql";
    }

    protected void switchAutocommitOff(Connection con) throws SQLException {
        con.setAutoCommit(false);
    }

    protected long getNextM4SequenceValue(Statement stmt) throws M4Exception {
        String tableWithM4Ids = "m4sequence_t";
        String query = "select m4_id from " + tableWithM4Ids;
        Long currentval = null;
        long nextval = -1L;
        try {
            currentval = this.executeSingleValueSqlReadL(query, stmt);
            if (currentval != null) {
                query = "delete from " + tableWithM4Ids;
                this.executeSqlWrite(query, stmt);
                nextval = currentval + 1L;
                query = "insert into " + tableWithM4Ids + " values (" + nextval + ")";
                this.executeSqlWrite(query, stmt);
                DbCoreMysql.commitBatch(stmt);
                return nextval;
            }
        }
        catch (SQLException e) {
            throw new M4Exception("An SQL error occurred when reading next M4 sequence value: " + e.getMessage());
        }
        throw new M4Exception("Could not determine next M4 sequence value!");
    }

    long getNextM4SequenceValue() throws DbConnectionClosed, M4Exception {
        try {
            Statement stmt = this.getDbWriteStatement();
            return this.getNextM4SequenceValue(stmt);
        }
        catch (SQLException e) {
            String msg = "Error in method DbCore.getNextM4SequenceValue():\nCould not create Statement:\n" + e.getMessage();
            throw new M4Exception(msg);
        }
    }

    String getTableOwner() {
        return this.mySchemaName;
    }

    public String getSelectStringAllTables() {
        String ret = "select table_name from information_schema.tables where table_schema = '" + this.getTableOwner() + "' and table_type = 'BASE TABLE'";
        return ret;
    }

    public String getSelectStringAllViews() {
        String ret = "select table_name from information_schema.tables where table_schema = '" + this.getTableOwner() + "' and table_type = 'View'";
        return ret;
    }

    public String getSelectStringDistribValuesTimeColumn(String colSql, String tableName, String distribBase) {
        if (colSql == null || tableName == null || distribBase == null) {
            return null;
        }
        String formatToExtract = null;
        if (distribBase.equalsIgnoreCase("YYYY")) {
            formatToExtract = "YEAR";
        }
        if (distribBase.equalsIgnoreCase("YYYYQ")) {
            formatToExtract = "QUARTER";
        }
        if (distribBase.equalsIgnoreCase("YYYYMM")) {
            formatToExtract = "YEAR_MONTH";
        }
        if (distribBase.equalsIgnoreCase("YYYYMMDD")) {
            formatToExtract = MYSQL_TYPE_DATE;
        }
        if (formatToExtract == null) {
            return null;
        }
        String columnQuery = "EXTRACT (" + formatToExtract + " FROM " + colSql + ")";
        if (formatToExtract.equalsIgnoreCase(MYSQL_TYPE_DATE)) {
            columnQuery = "DATE(" + colSql + ")";
        }
        String query = "SELECT " + columnQuery + ", " + "COUNT(*)," + "MIN(" + columnQuery + "), " + "MAX(" + columnQuery + ") " + "FROM " + tableName + " WHERE (" + columnQuery + ") IS NOT NULL " + "GROUP BY " + columnQuery + " ORDER BY " + columnQuery;
        return query;
    }

    public String getSelectStringAllColumnsForDbObject(String dbObjectName) {
        return "SELECT column_name, column_type FROM information_schema.columns WHERE table_name = '" + dbObjectName.toLowerCase() + "'";
    }

    public long getNumberOfMonthsBetween(String dbObjectName, String firstValue, String secondValue) throws M4Exception {
        try {
            String yearQuery = "SELECT EXTRACT(YEAR_MONTH FROM " + firstValue + ") FROM " + dbObjectName;
            Long firstYear = this.executeSingleValueSqlReadL(yearQuery);
            yearQuery = "SELECT EXTRACT(YEAR_MONTH FROM " + secondValue + ") FROM " + dbObjectName;
            Long secondYear = this.executeSingleValueSqlReadL(yearQuery);
            if (firstYear == null || secondYear == null) {
                return 0L;
            }
            long monthDiff = firstYear - secondYear;
            if (monthDiff < 0L) {
                monthDiff *= -1L;
            }
            return monthDiff;
        }
        catch (SQLException s) {
            throw new M4Exception("Sql error trying to compute number of months between '" + firstValue + "' and '" + secondValue + "': " + s.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("No connection to DB when trying to compute number of months between '" + firstValue + "' and '" + secondValue + "': " + d.getMessage());
        }
    }

    public boolean tableExists(String tableName) throws M4Exception {
        String query = "SELECT table_name FROM information_schema.tables WHERE table_name = '" + tableName.toLowerCase() + "'";
        if (this.getTableOwner() != null) {
            query = query + " AND table_schema = '" + this.getTableOwner() + "'";
        }
        String l = null;
        try {
            this.commitTransactions();
            l = this.executeSingleValueSqlRead(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error testing if table '" + tableName + "' exists: " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DB connection error when testing if table '" + tableName + "' exists: " + d.getMessage());
        }
        return l != null;
    }

    public String getSelectStringColumnDataTypes(String dbObjectName, String owner, String columnName) {
        String ret = "SELECT column_type FROM information_schema.columns WHERE table_name = '" + dbObjectName.toLowerCase() + "' AND column_name = '" + columnName.toLowerCase() + "'";
        if (owner != null) {
            if (!owner.toLowerCase().equals(this.getTableOwner())) {
                owner = this.getTableOwner();
            }
            ret = ret + " AND table_schema = '" + owner.toLowerCase() + "'";
        }
        return ret;
    }

    public Collection getPrimaryKeyColumnNames(String dbObjectName) throws SQLException, DbConnectionClosed {
        Vector<String> thePrimaryKeyColumnNames = new Vector<String>();
        String query = "SELECT column_name FROM information_schema.key_column_usage WHERE table_name = '" + dbObjectName.toLowerCase() + "' and constraint_name = 'PRIMARY'";
        ResultSet rs = this.executeSqlRead(query);
        while (rs.next()) {
            thePrimaryKeyColumnNames.add(rs.getString(1));
        }
        rs.close();
        if (thePrimaryKeyColumnNames.isEmpty()) {
            return null;
        }
        return thePrimaryKeyColumnNames;
    }

    public Map getTablesReferencedBy(String dbObjectName) throws SQLException, DbConnectionClosed {
        HashMap<String, String> myMap = new HashMap<String, String>();
        String query = "SELECT column_name, referenced_table_name FROM information_schema.key_column_usage WHERE table_name = '" + dbObjectName.toLowerCase() + "' and table_schema = '" + this.getTableOwner() + "'";
        ResultSet rs = this.executeSqlRead(query);
        while (rs.next()) {
            myMap.put(rs.getString(1), rs.getString(2));
        }
        rs.close();
        return myMap;
    }

    public Map getTablesReferringTo(String dbObjectName) throws SQLException, DbConnectionClosed {
        HashMap myMap = new HashMap();
        String query = "SELECT column_name, table_name FROM information_schema.key_column_usage WHERE referenced_table_name = '" + dbObjectName.toLowerCase() + "' and referenced_table_schema = '" + this.getTableOwner() + "'";
        ResultSet rs = this.executeSqlRead(query);
        while (rs.next()) {
            String colName = rs.getString(1);
            String tableName = rs.getString(2);
            Vector<String> listOfTables = (Vector<String>)myMap.get(colName);
            if (listOfTables == null) {
                listOfTables = new Vector<String>();
                myMap.put(colName, listOfTables);
            }
            if (listOfTables.contains(tableName)) continue;
            listOfTables.add(tableName);
        }
        rs.close();
        return myMap;
    }

    public String getTableOrViewType(String dbObjectName) throws SQLException, DbConnectionClosed {
        String query = "SELECT table_type FROM information_schema.tables WHERE table_name = '" + dbObjectName.toLowerCase() + "'";
        String type = this.executeSingleValueSqlRead(query);
        if (type == null) {
            return null;
        }
        if (type.equalsIgnoreCase("VIEW")) {
            return "V";
        }
        if (type.equalsIgnoreCase("BASE TABLE")) {
            return "T";
        }
        return null;
    }

    public String getAttributeForColumnNames() {
        return "column_name";
    }

    public String getAttributeForColumnTypes() {
        return "column_type";
    }

    public String getUniqueRowIdentifier() {
        return null;
    }

    public String getPowerExpression(String base, String exponent) {
        return "POWER(" + base + ", " + exponent + ")";
    }

    public String getFloorExpression() {
        return "floor";
    }

    public String getRoundToDecimalPlacesExpression() {
        return "truncate";
    }

    public String getAliasExpressionForInnerSelects(String aliasName) {
        return " AS " + aliasName;
    }

    public String getDatatypeName(String m4RelDatatypeName, int size) {
        String ret = null;
        if (m4RelDatatypeName.equals("NUMBER")) {
            ret = MYSQL_TYPE_NUMBER;
        } else if (m4RelDatatypeName.equals(MYSQL_TYPE_DATE)) {
            ret = MYSQL_TYPE_DATE;
        } else if (m4RelDatatypeName.equals("KEY")) {
            ret = MYSQL_TYPE_INTEGER;
        } else if (m4RelDatatypeName.equals("STRING")) {
            ret = MYSQL_TYPE_STRING;
        }
        if (ret != null && size > 0) {
            ret = ret + "(" + size + ")";
        } else if (ret != null && ret.equals(MYSQL_TYPE_STRING)) {
            ret = ret + "(100)";
        }
        return ret;
    }

    public String getM4DatatypeName(String dbmsDatatypeName) {
        if ((dbmsDatatypeName = dbmsDatatypeName.toUpperCase()).equals(MYSQL_TYPE_NUMBER)) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("FLOAT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("INT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("BIGINT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("SMALLINT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("TINYINT")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.startsWith("DECIMAL")) {
            return "NUMBER";
        }
        if (dbmsDatatypeName.equals(MYSQL_TYPE_DATE) || dbmsDatatypeName.equals(MYSQL_TYPE_TIME) || dbmsDatatypeName.equals(MYSQL_TYPE_TIMESTAMP)) {
            return MYSQL_TYPE_DATE;
        }
        if (dbmsDatatypeName.startsWith(MYSQL_TYPE_STRING)) {
            return "STRING";
        }
        if (dbmsDatatypeName.equals(MYSQL_TYPE_TEXT)) {
            return "STRING";
        }
        return null;
    }

    public boolean dropRelation(String tableName) throws M4Exception {
        boolean tableExists = this.tableExists(tableName);
        if (tableExists) {
            String sql_drop = "DROP TABLE " + tableName;
            try {
                this.executeSqlWrite(sql_drop);
            }
            catch (SQLException sqle) {
                throw new M4Exception("Error trying to remove the table '" + tableName + "':\n" + sqle.getMessage());
            }
            catch (DbConnectionClosed dbe) {
                throw new M4Exception("DB Connection closed when deleting table '" + tableName + "':\n" + dbe.getMessage());
            }
        }
        return tableExists;
    }

    public String getTestQuery() {
        return this.getSelectStringAllTables();
    }

    public String createPrimaryKeyConstraint(String tableName, Collection pkAttributeNames, String dbConstraintName) throws SQLException, DbConnectionClosed {
        if (dbConstraintName == null || dbConstraintName.trim().length() == 0) {
            dbConstraintName = tableName + "_PK";
        }
        String commaSeparatedKeyNames = DbCoreMysql.stringCollectionToCommaSeparated(pkAttributeNames);
        String sql = "ALTER TABLE " + tableName + " ADD CONSTRAINT " + dbConstraintName + " PRIMARY KEY (" + commaSeparatedKeyNames + ")";
        this.executeSqlWrite(sql);
        return dbConstraintName;
    }

    public void createForeignKeyConstraint(String fkTableName, Collection fkAttributeNames, String pkTableName, Collection pkAttributeNames, String dbConstraintName) throws SQLException, DbConnectionClosed {
        String fkNamesComma = DbCoreMysql.stringCollectionToCommaSeparated(fkAttributeNames);
        String pkNamesComma = DbCoreMysql.stringCollectionToCommaSeparated(pkAttributeNames);
        String sql = "ALTER TABLE " + fkTableName + " ADD CONSTRAINT " + dbConstraintName + " FOREIGN KEY (" + fkNamesComma + ") REFERENCES " + pkTableName + "(" + pkNamesComma + ")";
        this.executeSqlWrite(sql);
    }
}

