/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.db;

import edu.udo.cs.miningmart.db.ConfigReader;
import edu.udo.cs.miningmart.db.DbCore;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Case;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.ForeignKey;
import edu.udo.cs.miningmart.m4.Key;
import edu.udo.cs.miningmart.m4.M4InterfaceContext;
import edu.udo.cs.miningmart.m4.core.M4Data;
import edu.udo.cs.miningmart.m4.core.M4Object;
import edu.udo.cs.miningmart.m4.core.PrimaryKey;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;

public class DB
implements Serializable {
    protected final transient DbCore m4Dbc;
    protected final transient DbCore busiDbc;
    public static final short NO_DBMS = 0;
    public static final short ORACLE = 1;
    public static final short POSTGRES = 2;
    public static final short MYSQL = 3;
    public static final String c_yes = "YES";
    public static final String c_no = "NO";
    public static final String c_output = "OUT";
    public static final String c_input = "IN";
    public static final String c_db = "DB";
    public static final String c_mining = "MINING";
    public static String C_VAL = "V";
    public static String C_CONC = "CON";
    public static String C_REL = "REL";
    public static String C_BA = "BA";
    public static String C_MCF = "MCF";
    public static String C_FEA = "FEA";
    protected boolean computeAllStat;
    protected transient M4InterfaceContext cal;
    private transient String businessSchema;
    private final Hashtable loadedObjects;
    private String[][] mapping = new String[][]{{"edu.udo.cs.miningmart.m4.Assertion", "edu.udo.cs.miningmart.m4.core.Assertion"}, {"edu.udo.cs.miningmart.m4.BaseAttribute", "edu.udo.cs.miningmart.m4.core.BaseAttribute"}, {"edu.udo.cs.miningmart.m4.Case", "edu.udo.cs.miningmart.m4.core.Case"}, {"edu.udo.cs.miningmart.m4.Chain", "edu.udo.cs.miningmart.m4.core.Chain"}, {"edu.udo.cs.miningmart.m4.Column", "edu.udo.cs.miningmart.m4.core.Column"}, {"edu.udo.cs.miningmart.m4.Columnset", "edu.udo.cs.miningmart.m4.core.Columnset"}, {"edu.udo.cs.miningmart.m4.ColumnStatistics1", "edu.udo.cs.miningmart.m4.core.ColumnStatistics1"}, {"edu.udo.cs.miningmart.m4.ColumnStatistics2", "edu.udo.cs.miningmart.m4.core.ColumnStatistics2"}, {"edu.udo.cs.miningmart.m4.ColumnsetStatistics", "edu.udo.cs.miningmart.m4.core.ColumnsetStatistics"}, {"edu.udo.cs.miningmart.m4.Concept", "edu.udo.cs.miningmart.m4.core.Concept"}, {"edu.udo.cs.miningmart.m4.Condition", "edu.udo.cs.miningmart.m4.core.Condition"}, {"edu.udo.cs.miningmart.m4.Constraint", "edu.udo.cs.miningmart.m4.core.Constraint"}, {"edu.udo.cs.miningmart.m4.Docu", "edu.udo.cs.miningmart.m4.core.Docu"}, {"edu.udo.cs.miningmart.m4.Feature", "edu.udo.cs.miningmart.m4.core.Feature"}, {"edu.udo.cs.miningmart.m4.GraphicalM4Object", "edu.udo.cs.miningmart.m4.GraphicalM4Object"}, {"edu.udo.cs.miningmart.m4.ForeignKey", "edu.udo.cs.miningmart.m4.core.ForeignKey"}, {"edu.udo.cs.miningmart.m4.PrimaryKey", "edu.udo.cs.miningmart.m4.core.PrimaryKey"}, {"edu.udo.cs.miningmart.m4.ForeignKeyLink", "edu.udo.cs.miningmart.m4.core.KeyMember"}, {"edu.udo.cs.miningmart.m4.M4Data", "edu.udo.cs.miningmart.m4.core.M4Data"}, {"edu.udo.cs.miningmart.m4.MultiColumnFeature", "edu.udo.cs.miningmart.m4.core.MultiColumnFeature"}, {"edu.udo.cs.miningmart.m4.OpParam", "edu.udo.cs.miningmart.m4.core.OpParam"}, {"edu.udo.cs.miningmart.m4.Operator", "edu.udo.cs.miningmart.m4.core.Operator"}, {"edu.udo.cs.miningmart.m4.Parameter", "edu.udo.cs.miningmart.m4.core.Parameter"}, {"edu.udo.cs.miningmart.m4.Projection", "edu.udo.cs.miningmart.m4.core.Projection"}, {"edu.udo.cs.miningmart.m4.Relation", "edu.udo.cs.miningmart.m4.core.Relation"}, {"edu.udo.cs.miningmart.m4.Step", "edu.udo.cs.miningmart.m4.core.Step"}, {"edu.udo.cs.miningmart.m4.Value", "edu.udo.cs.miningmart.m4.core.Value"}, {"edu.udo.cs.miningmart.m4.core.ConceptInheritance", "edu.udo.cs.miningmart.m4.core.ConceptInheritance"}, {"edu.udo.cs.miningmart.m4.core.Coordinates", "edu.udo.cs.miningmart.m4.core.Coordinates"}, {"edu.udo.cs.miningmart.m4.core.Assertion", "edu.udo.cs.miningmart.m4.core.Assertion"}, {"edu.udo.cs.miningmart.m4.core.BaseAttribute", "edu.udo.cs.miningmart.m4.core.BaseAttribute"}, {"edu.udo.cs.miningmart.m4.core.Case", "edu.udo.cs.miningmart.m4.core.Case"}, {"edu.udo.cs.miningmart.m4.core.Chain", "edu.udo.cs.miningmart.m4.core.Chain"}, {"edu.udo.cs.miningmart.m4.core.Column", "edu.udo.cs.miningmart.m4.core.Column"}, {"edu.udo.cs.miningmart.m4.core.Columnset", "edu.udo.cs.miningmart.m4.core.Columnset"}, {"edu.udo.cs.miningmart.m4.core.ColumnStatistics1", "edu.udo.cs.miningmart.m4.core.ColumnStatistics1"}, {"edu.udo.cs.miningmart.m4.core.ColumnStatistics2", "edu.udo.cs.miningmart.m4.core.ColumnStatistics2"}, {"edu.udo.cs.miningmart.m4.core.ColumnsetStatistics", "edu.udo.cs.miningmart.m4.core.ColumnsetStatistics"}, {"edu.udo.cs.miningmart.m4.core.Concept", "edu.udo.cs.miningmart.m4.core.Concept"}, {"edu.udo.cs.miningmart.m4.core.Condition", "edu.udo.cs.miningmart.m4.core.Condition"}, {"edu.udo.cs.miningmart.m4.core.Constraint", "edu.udo.cs.miningmart.m4.core.Constraint"}, {"edu.udo.cs.miningmart.m4.core.Docu", "edu.udo.cs.miningmart.m4.core.Docu"}, {"edu.udo.cs.miningmart.m4.core.Feature", "edu.udo.cs.miningmart.m4.core.Feature"}, {"edu.udo.cs.miningmart.m4.core.GraphicalM4Object", "edu.udo.cs.miningmart.m4.core.GraphicalM4Object"}, {"edu.udo.cs.miningmart.m4.core.ForeignKey", "edu.udo.cs.miningmart.m4.core.ForeignKey"}, {"edu.udo.cs.miningmart.m4.core.PrimaryKey", "edu.udo.cs.miningmart.m4.core.PrimaryKey"}, {"edu.udo.cs.miningmart.m4.core.KeyMember", "edu.udo.cs.miningmart.m4.core.KeyMember"}, {"edu.udo.cs.miningmart.m4.core.M4Data", "edu.udo.cs.miningmart.m4.core.M4Data"}, {"edu.udo.cs.miningmart.m4.core.MultiColumnFeature", "edu.udo.cs.miningmart.m4.core.MultiColumnFeature"}, {"edu.udo.cs.miningmart.m4.core.OpParam", "edu.udo.cs.miningmart.m4.core.OpParam"}, {"edu.udo.cs.miningmart.m4.core.Operator", "edu.udo.cs.miningmart.m4.core.Operator"}, {"edu.udo.cs.miningmart.m4.core.Parameter", "edu.udo.cs.miningmart.m4.core.Parameter"}, {"edu.udo.cs.miningmart.m4.core.Projection", "edu.udo.cs.miningmart.m4.core.Projection"}, {"edu.udo.cs.miningmart.m4.core.Relation", "edu.udo.cs.miningmart.m4.core.Relation"}, {"edu.udo.cs.miningmart.m4.core.Step", "edu.udo.cs.miningmart.m4.core.Step"}, {"edu.udo.cs.miningmart.m4.core.Value", "edu.udo.cs.miningmart.m4.core.Value"}};
    private static final Class[] CONSTR_ARGS = new Class[]{DB.class};
    public static final boolean READ_ONLY = false;
    public static final String[] ORDER_FOR_WRITING = new String[]{"case_t", "concept_t", "columnset_t", "csstatist_t", "conceptisa_t", "projection_t", "mcfeature_t", "baseattrib_t", "column_t", "colstatist1_t", "colstatist2_t", "keyhead_t", "keymember_t", "relation_t", "value_t", "chain_t", "step_t", "parameter_t", "docu_t", "hci_coord_t"};
    public static final HashMap dirtyObjectSets = new HashMap();

    public DB(String m4Url, String m4DbName, String m4User, String m4Passwd, String dataUrl, String dataDbName, String dataUser, String dataPasswd, boolean computeStatistics, M4InterfaceContext cal) throws SQLException {
        this.computeAllStat = computeStatistics;
        this.cal = cal;
        this.m4Dbc = DbCore.getDbCore(m4Url, m4DbName, m4User, m4Passwd, cal, true);
        this.busiDbc = DbCore.getDbCore(dataUrl, dataDbName, dataUser, dataPasswd, cal, false);
        this.loadedObjects = new Hashtable();
        this.testDbConnection();
        this.businessSchema = this.busiDbc.getNameOfSchema();
    }

    public DB(ConfigReader cr, boolean computeStatistics, M4InterfaceContext cal) throws SQLException {
        this(cr.getM4Url(), cr.getM4DbName(), cr.getM4User(), cr.getM4Pw(), cr.getBusUrl(), cr.getBusDbName(), cr.getBusUser(), cr.getBusPw(), computeStatistics, cal);
    }

    public DB(DB db, M4InterfaceContext m4i) {
        this.loadedObjects = db.loadedObjects;
        this.m4Dbc = db.m4Dbc;
        this.busiDbc = db.busiDbc;
        this.cal = m4i;
    }

    public Print getCasePrintObject() {
        M4InterfaceContext cal = this.getCompilerAccessLogic();
        return cal == null ? null : cal.getPrintObject();
    }

    public void getFreshM4Connection() throws SQLException, DbConnectionClosed {
        this.getM4DbCore().getFreshConnection();
    }

    private void testDbConnection() throws SQLException {
        try {
            DbCore m4Dbc = this.getM4DbCore();
            DbCore busDbc = this.getBusinessDbCore();
            if (m4Dbc == null || busDbc == null) {
                throw new SQLException("DB.testDbConnection: DbCore not found!");
            }
            ResultSet rs = this.executeM4SqlRead(m4Dbc.getTestQuery());
            rs.close();
            rs = this.executeBusinessSqlRead(busDbc.getTestQuery());
            rs.close();
        }
        catch (DbConnectionClosed dbConnectionClosed) {
            // empty catch block
        }
    }

    public short getM4Dbms() throws DbConnectionClosed {
        DbCore dbc = this.getM4DbCore();
        if (dbc != null) {
            return dbc.getDbms();
        }
        return 0;
    }

    public short getBusinessDbms() throws DbConnectionClosed {
        DbCore dbc = this.getBusinessDbCore();
        if (dbc != null) {
            return dbc.getDbms();
        }
        return 0;
    }

    public String getBusinessSchemaName() {
        return this.businessSchema;
    }

    public void commitM4Transactions() throws M4Exception {
        try {
            this.getM4DbCore().commitTransactions();
        }
        catch (SQLException sqle) {
            throw new M4Exception("SQL error committing M4 transactions: " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Connection error committing M4 transactions: " + d.getMessage());
        }
    }

    public void commitBusinessTransactions() throws SQLException, DbConnectionClosed {
        this.getBusinessDbCore().commitTransactions();
    }

    public void rollbackOnM4() throws SQLException, DbConnectionClosed {
        this.getM4DbCore().rollback();
    }

    public edu.udo.cs.miningmart.m4.M4Object getM4Object(long Id, Class m4ClassObject) throws M4Exception {
        edu.udo.cs.miningmart.m4.M4Object tmp;
        if (Id == 0L) {
            return null;
        }
        if (m4ClassObject.equals(edu.udo.cs.miningmart.m4.core.ForeignKey.class) || m4ClassObject.equals(PrimaryKey.class) || m4ClassObject.equals(edu.udo.cs.miningmart.m4.PrimaryKey.class) || m4ClassObject.equals(ForeignKey.class)) {
            boolean i;
            boolean j = i = false;
        }
        if ((tmp = this.getM4ObjectFromCache(Id)) == null) {
            this.doPrint(Print.CACHE, "Loading object from database");
            Class desiredM4ClassObject = m4ClassObject;
            if (Key.class.isAssignableFrom(m4ClassObject)) {
                m4ClassObject = this.decidePrimaryOrForeignKey(Id);
            }
            if (edu.udo.cs.miningmart.m4.PrimaryKey.class.isAssignableFrom(m4ClassObject) && ForeignKey.class.isAssignableFrom(desiredM4ClassObject) || edu.udo.cs.miningmart.m4.PrimaryKey.class.isAssignableFrom(desiredM4ClassObject) && ForeignKey.class.isAssignableFrom(m4ClassObject)) {
                return null;
            }
            M4Object emptyObject = this.createNewInstance(m4ClassObject);
            edu.udo.cs.miningmart.m4.M4Object theObject = emptyObject.load(Id);
            this.loadedObjects.remove(new Long(Id));
            this.loadedObjects.put(new Long(Id), theObject);
            return theObject;
        }
        this.doPrint(Print.CACHE, "Returning already loaded Object");
        return tmp;
    }

    private Class ensureCoreClass(Class m4Class) throws M4Exception {
        String classname = m4Class.getName();
        String newClassname = this.mapClasses(classname);
        Class<?> newClass = null;
        try {
            newClass = Class.forName(newClassname);
        }
        catch (ClassNotFoundException nfe) {
            throw new M4Exception("DB: could not create class '" + newClassname + "': " + nfe.getMessage());
        }
        return newClass;
    }

    private String mapClasses(String oldName) throws M4Exception {
        for (int i = 0; i < this.mapping.length; ++i) {
            if (!oldName.equals(this.mapping[i][0])) continue;
            return this.mapping[i][1];
        }
        throw new M4Exception("Could not map edu.udo.cs.miningmart.m4 class '" + oldName + "' to core class!");
    }

    private Class decidePrimaryOrForeignKey(long Id) throws M4Exception {
        String sql = "SELECT km_fkcolid FROM keymember_t WHERE km_khid = " + Id;
        try {
            Long foreignKeyColId = this.executeM4SingleValueSqlReadL(sql);
            if (foreignKeyColId == null && (foreignKeyColId = this.executeM4SingleValueSqlReadL(sql = "SELECT kh_fkcsid FROM keyhead_t WHERE kh_id = " + Id)) == null) {
                throw new M4Exception("Unable to decide whether to instantiate Primary or ForeignKey for Key with Id " + Id);
            }
            if (foreignKeyColId == 0L) {
                return edu.udo.cs.miningmart.m4.PrimaryKey.class;
            }
            return ForeignKey.class;
        }
        catch (SQLException sqle) {
            throw new M4Exception("DB.decidePrimaryOrForeignKey: SQL error: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("DB.decidePrimaryOrForeignKey: Connection to M4DB was closed: " + dbc.getMessage());
        }
    }

    public void clearM4Cache() {
        if (this.loadedObjects == null) {
            return;
        }
        this.loadedObjects.clear();
    }

    public edu.udo.cs.miningmart.m4.M4Object getM4ObjectFromCache(long Id) {
        return (edu.udo.cs.miningmart.m4.M4Object)this.loadedObjects.get(new Long(Id));
    }

    private edu.udo.cs.miningmart.m4.M4Object getM4ObjectFromCache(String name, Class typeOfM4Object) {
        for (edu.udo.cs.miningmart.m4.M4Object myObj : this.loadedObjects.values()) {
            if (!typeOfM4Object.isAssignableFrom(myObj.getClass()) || !myObj.getName().equalsIgnoreCase(name)) continue;
            return myObj;
        }
        return null;
    }

    public void putM4ObjectToCache(edu.udo.cs.miningmart.m4.M4Object m4o) throws M4Exception {
        if (m4o == null) {
            throw new M4Exception("M4 Cache, method DB.putM4ObjectToCache(M4Object):\nRefusing to store a <null> object!");
        }
        long id = m4o.getId();
        if (id == 0L) {
            throw new M4Exception("M4 Cache, method DB.putM4ObjectToCache(M4Object):\nRefusing to store an M4Object with ID 0!\nObject is of type " + m4o.getClass().getName());
        }
        if (this.getM4ObjectFromCache(id) == null) {
            this.loadedObjects.put(new Long(id), m4o);
        }
    }

    public void removeM4ObjectFromCache(edu.udo.cs.miningmart.m4.M4Object m4o) {
        if (m4o != null && m4o.getId() != 0L && ((Object)m4o).equals(this.getM4ObjectFromCache(m4o.getId()))) {
            this.loadedObjects.remove(new Long(m4o.getId()));
        }
    }

    public static String attribPrefix(String attributeName, String prefix) {
        String ret = "SUBSTR(" + attributeName + ", 1, " + prefix.length() + ")";
        return ret;
    }

    public static String quote(String sql) {
        if (sql == null) {
            return null;
        }
        if (sql.startsWith("'") && sql.endsWith("'")) {
            return sql;
        }
        String tmp1 = sql;
        String tmp2 = "'";
        int i = tmp1.indexOf("'");
        while (i >= 0) {
            tmp2 = tmp2 + tmp1.substring(0, i + 1) + "'";
            tmp1 = tmp1.substring(i + 1);
            i = tmp1.indexOf("'");
        }
        return tmp2 + tmp1 + "'";
    }

    public String getSelectStringDistribValuesTimeColumn(String colSql, String tableName, String distribBase) {
        return this.busiDbc.getSelectStringDistribValuesTimeColumn(colSql, tableName, distribBase);
    }

    public boolean areSomeStatisticsStored(Columnset cs) throws M4Exception {
        if (cs == null) {
            return false;
        }
        if (cs.getId() == 0L) {
            return false;
        }
        String query = "SELECT csst_id FROM csstatist_t WHERE csst_csid = " + cs.getId();
        Long result = null;
        try {
            result = this.executeM4SingleValueSqlReadL(query);
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error checking whether columnset '" + cs.getName() + "' has pre-stored statistics: DbConnectionClosed: " + d.getMessage());
        }
        catch (SQLException s) {
            throw new M4Exception("SQL Error checking whether columnset '" + cs.getName() + "' has pre-stored statistics: " + s.getMessage());
        }
        return result != null;
    }

    private void insertColumnStatistField(String fieldName, int tableNumber, long colId, String value) throws M4Exception, DbConnectionClosed {
        if (tableNumber != 1 && tableNumber != 2) {
            throw new M4Exception("DB.java: updateColumnStatistFieldAndTrash called with wrong table number " + tableNumber);
        }
        try {
            long statId = this.getNextM4SequenceValue();
            String query = "INSERT INTO COLSTATIST" + tableNumber + "_T " + "(colst" + tableNumber + "_id, colst" + tableNumber + "_colid, " + fieldName + ") VALUES (" + statId + ", " + colId + ", " + value + ")";
            this.executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("DB.insertColumnStatistField: DB access error: " + sqle.getMessage());
        }
    }

    private void insertColumnSetStatistField(String fieldName, long csId, String value) throws M4Exception, DbConnectionClosed {
        try {
            long statId = this.getNextM4SequenceValue();
            String query = "INSERT INTO CSSTATIST_T (csst_id, csst_csid, " + fieldName + ") VALUES (" + statId + ", " + csId + ", " + value + ")";
            this.executeM4SqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4Exception("DB.insertColumnSetStatistField: DB access error: " + sqle.getMessage());
        }
    }

    public static String checkDouble(String test) throws M4Exception {
        if (test == null) {
            return null;
        }
        int a = test.indexOf(",");
        if (a > -1) {
            String pre = test.substring(0, a);
            String post = test.substring(a + 1);
            test = pre + "." + post;
        }
        if (test.startsWith(".")) {
            test = "0" + test;
        }
        try {
            Double.parseDouble(test);
        }
        catch (NumberFormatException nfe) {
            throw new M4Exception("Error trying to convert '" + test + "' into double, when reading a Value from the DB.");
        }
        return test;
    }

    public String getSelectStringAllBusDataTables() {
        return this.busiDbc.getSelectStringAllTables();
    }

    public String getSelectStringAllBusDataViews() {
        return this.busiDbc.getSelectStringAllViews();
    }

    public String getSelectStringAllColumnsForDbObject(String dbObjectName) {
        return this.busiDbc.getSelectStringAllColumnsForDbObject(dbObjectName);
    }

    public String getAttributeForColumnNames() {
        return this.busiDbc.getAttributeForColumnNames();
    }

    public String getNameOfNumericDatatype() {
        return this.busiDbc.getDatatypeName("NUMBER", -1);
    }

    public String getNameOfVarcharDatatype(int size) {
        return this.busiDbc.getDatatypeName("STRING", size);
    }

    public String getNameOfDateDatatype() {
        return this.busiDbc.getDatatypeName("DATE", -1);
    }

    public String getDbNameOfM4Datatype(String m4RelDatatypeName, int length, boolean useBusinessDBMS) throws M4CompilerError {
        try {
            if (useBusinessDBMS) {
                return this.getBusinessDbCore().getDatatypeName(m4RelDatatypeName, length);
            }
            return this.getM4DbCore().getDatatypeName(m4RelDatatypeName, length);
        }
        catch (DbConnectionClosed dbcc) {
            throw new M4CompilerError("CompilerDatabaseService.getDbNameOfM4Datatype: Db connection closed: " + dbcc.getMessage());
        }
    }

    public String getUniqueRowIdentifier(boolean useBusinessDBMS) throws M4CompilerError {
        try {
            if (useBusinessDBMS) {
                return this.getBusinessDbCore().getUniqueRowIdentifier();
            }
            return this.getM4DbCore().getUniqueRowIdentifier();
        }
        catch (DbConnectionClosed dbcc) {
            throw new M4CompilerError("CompilerDatabaseService.getUniqueRowIdentifier: " + dbcc.getMessage());
        }
    }

    public String getJdbcDriverClassName(boolean useBusinessDBMS) throws M4CompilerError {
        try {
            if (useBusinessDBMS) {
                return this.getBusinessDbCore().jdbcDriverClassName();
            }
            return this.getM4DbCore().jdbcDriverClassName();
        }
        catch (DbConnectionClosed dbcc) {
            throw new M4CompilerError("CompilerDatabaseService.getJdbcDriverClassName: " + dbcc.getMessage());
        }
    }

    public String getM4InstallationDirectory(boolean useBusinessDBMS) throws M4Exception {
        try {
            if (useBusinessDBMS) {
                return this.getBusinessDbCore().installDir();
            }
            return this.getM4DbCore().installDir();
        }
        catch (DbConnectionClosed dbcc) {
            throw new M4Exception("CompilerDatabaseService.getM4InstallationDirectory: " + dbcc.getMessage());
        }
    }

    public String getDateComparisonAsSqlString(boolean useBusinessDBMS, String dateOrTimeColumnName, String dateExpression, boolean greater, boolean orEqual, String timeFormat) throws M4CompilerError {
        try {
            if (useBusinessDBMS) {
                return this.getBusinessDbCore().getDateComparisonAsSqlString(dateOrTimeColumnName, dateExpression, greater, orEqual, timeFormat);
            }
            return this.getM4DbCore().getDateComparisonAsSqlString(dateOrTimeColumnName, dateExpression, greater, orEqual, timeFormat);
        }
        catch (DbConnectionClosed dbcc) {
            throw new M4CompilerError("CompilerDatabaseService.getDateComparisonAsSqlString: " + dbcc.getMessage());
        }
    }

    public String getColumnTestQuery(Column col) throws DbConnectionClosed {
        return this.getBusinessDbCore().getColumnTestQuery(col);
    }

    public String getAttributeForColumnTypes() {
        return this.busiDbc.getAttributeForColumnTypes();
    }

    public Collection getNamesOfBusSchemaDbObjects(boolean includeMmTables) throws M4Exception {
        Vector<String> ret = new Vector<String>();
        try {
            Vector<String> names = new Vector<String>();
            ResultSet rs = this.executeBusinessSqlRead(this.getSelectStringAllBusDataTables());
            while (rs.next()) {
                names.add(rs.getString(1));
            }
            rs.close();
            rs = this.executeBusinessSqlRead(this.getSelectStringAllBusDataViews());
            while (rs.next()) {
                names.add(rs.getString(1));
            }
            rs.close();
            if (includeMmTables) {
                ret = names;
            } else {
                Collection trashObjs = this.getNamesOfDbObjectsInTrash();
                for (String aDbObjName : names) {
                    Iterator it2 = trashObjs.iterator();
                    boolean found = false;
                    while (it2.hasNext()) {
                        String aTrashName = (String)it2.next();
                        if (!aDbObjName.equalsIgnoreCase(aTrashName)) continue;
                        found = true;
                    }
                    if (found) continue;
                    ret.add(aDbObjName);
                }
            }
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("DB.getNamesOfBusSchemaDbObjects(): Connection to DB was closed, caught exception: " + dbc.getMessage());
        }
        catch (SQLException sqle) {
            throw new M4Exception("DB.getNamesOfBusSchemaDbObjects(): SQL error caught: " + sqle.getMessage());
        }
        return ret;
    }

    public Collection getNamesOfDbObjectsInTrash() throws M4Exception {
        Vector<String> ret = new Vector<String>();
        try {
            String objtypeName = "ObjType";
            String query = "SELECT ObjName, SchemaName FROM dbtrash_t WHERE (" + objtypeName + " = '" + "V" + "' OR " + objtypeName + " = '" + "T" + "')";
            ResultSet rs = this.executeM4SqlRead(query);
            while (rs.next()) {
                if (!rs.getString(2).equalsIgnoreCase(this.getBusinessSchemaName())) continue;
                ret.add(rs.getString(1));
            }
            rs.close();
        }
        catch (DbConnectionClosed dbc) {
            throw new M4Exception("DB.getNamesOfDbObjectsInTrash(): Connection to DB was closed, caught exception: " + dbc.getMessage());
        }
        catch (SQLException sqle) {
            throw new M4Exception("DB.getNamesOfDbObjectsInTrash(): SQL error caught: " + sqle.getMessage());
        }
        ret.trimToSize();
        return ret;
    }

    public Collection getPrimaryKeysFromDbSchema(Columnset cs) throws M4Exception {
        try {
            Collection namesOfPkCols = this.getBusinessDbCore().getPrimaryKeyColumnNames(cs.getName());
            Vector<Column> ret = new Vector<Column>();
            if (namesOfPkCols != null) {
                for (String colName : namesOfPkCols) {
                    ret.add(cs.getColumn(colName));
                }
            }
            return ret;
        }
        catch (SQLException sqle) {
            throw new M4Exception("Sql error when trying to read primary key columns from SQL for columnset '" + cs.getName() + "': " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DbConnection closed when trying to read primary key columns from SQL for columnset '" + cs.getName() + "': " + d.getMessage());
        }
    }

    public Map getMapOfForeignKeyReferences(Columnset cs, Case currentCase) throws M4Exception {
        try {
            Map mappings = this.getBusinessDbCore().getTablesReferencedBy(cs.getName());
            HashMap<Column, Columnset> ret = new HashMap<Column, Columnset>();
            if (mappings != null) {
                for (Map.Entry mapentry : mappings.entrySet()) {
                    String colName = (String)mapentry.getKey();
                    String tableName = (String)mapentry.getValue();
                    Column col = cs.getColumn(colName);
                    Columnset foreignCs = null;
                    if (tableName != null && (foreignCs = this.getColumnsetFromCase(tableName, currentCase)) == null) {
                        foreignCs = this.createColumnsetFromTable(tableName);
                    }
                    ret.put(col, foreignCs);
                }
            }
            return ret;
        }
        catch (SQLException sqle) {
            throw new M4Exception("Sql error when trying to read foreign key references from SQL for columnset '" + cs.getName() + "': " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("DbConnection closed when trying to read foreign key references from SQL for columnset '" + cs.getName() + "': " + d.getMessage());
        }
    }

    public Columnset createColumnsetFromTable(String tableName) throws M4Exception {
        Columnset newColumnset = null;
        try {
            newColumnset = (Columnset)((Object)this.createNewInstance(Columnset.class));
            newColumnset.setName(tableName);
            newColumnset.setSchema(this.getBusinessSchemaName());
            newColumnset.setType(this.getBusinessDbCore().getTableOrViewType(tableName));
            newColumnset.createColumnsFromDbObject(tableName);
        }
        catch (SQLException sqle) {
            throw new M4Exception("Sql error when trying to create a Columnset from table/view '" + tableName + "': " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Connection to business schema was closed when trying to create a Columnset from table/view '" + tableName + "': " + d.getMessage());
        }
        return newColumnset;
    }

    public Columnset getColumnsetFromCase(String nameOfCs, Case theCase) throws M4Exception {
        if (theCase == null) {
            throw new M4Exception("Could not look for columnset '" + nameOfCs + "' in NULL case!");
        }
        for (Concept aCon : theCase.getConcepts()) {
            for (Columnset cs : aCon.getColumnSets()) {
                if (!cs.getName().equalsIgnoreCase(nameOfCs)) continue;
                return cs;
            }
        }
        return null;
    }

    public boolean isCrossTable(String dbObjectName) throws SQLException, DbConnectionClosed {
        boolean onlyFkCols = this.busiDbc.hasOnlyForeignKeyColumns(dbObjectName);
        if (onlyFkCols) {
            ResultSet rs = this.executeBusinessSqlRead(this.getSelectStringAllColumnsForDbObject(dbObjectName));
            int counter = 0;
            while (rs.next()) {
                ++counter;
            }
            rs.close();
            return counter > 1;
        }
        return false;
    }

    public Collection getCrossTablesReferringTo(String dbObjectName) throws SQLException, DbConnectionClosed {
        Map tablesReferring = this.busiDbc.getTablesReferringTo(dbObjectName);
        Collection theTableLists = tablesReferring.values();
        Vector<String> theCrossTables = new Vector<String>();
        for (Collection tableNames : theTableLists) {
            if (tableNames == null) continue;
            for (String tableName : tableNames) {
                if (tableName == null || !this.isCrossTable(tableName)) continue;
                theCrossTables.add(tableName);
            }
        }
        return theCrossTables;
    }

    public boolean dropBusinessTable(String tableName) throws M4Exception {
        return this.busiDbc.dropRelation(tableName);
    }

    public boolean dropM4Table(String tableName) throws M4Exception {
        return this.m4Dbc.dropRelation(tableName);
    }

    public boolean isBusinessTable(String dbObjectName) throws SQLException, DbConnectionClosed {
        return this.getBusinessDbCore().getTableOrViewType(dbObjectName) == "T";
    }

    public boolean isBusinessView(String dbObjectName) throws SQLException, DbConnectionClosed {
        return this.getBusinessDbCore().getTableOrViewType(dbObjectName) == "V";
    }

    public boolean isM4Table(String dbObjectName) throws SQLException, DbConnectionClosed {
        return this.getM4DbCore().getTableOrViewType(dbObjectName) == "T";
    }

    public boolean isM4View(String dbObjectName) throws SQLException, DbConnectionClosed {
        return this.getM4DbCore().getTableOrViewType(dbObjectName) == "V";
    }

    public boolean tableExistsInM4(String tableName) throws M4Exception {
        try {
            return this.getM4DbCore().tableExists(tableName);
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error trying to find out if table '" + tableName + "' exists: Connection to DB closed: " + d.getMessage());
        }
    }

    public boolean tableExistsInBusinessSchema(String tableName) throws M4Exception {
        try {
            return this.getBusinessDbCore().tableExists(tableName);
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error trying to find out if table '" + tableName + "' exists: Connection to DB closed: " + d.getMessage());
        }
    }

    public String getPowerExpression(String base, String exponent) throws M4Exception {
        try {
            return this.getBusinessDbCore().getPowerExpression(base, exponent);
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error trying to find power expression: Connection to DB closed: " + d.getMessage());
        }
    }

    public String getFloorExpression() throws M4Exception {
        try {
            return this.getBusinessDbCore().getFloorExpression();
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error trying to find floor expression: Connection to DB closed: " + d.getMessage());
        }
    }

    public String getRoundToDecimalPlacesExpression() throws M4Exception {
        try {
            return this.getBusinessDbCore().getRoundToDecimalPlacesExpression();
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error trying to find expression for rounding to n decimal places: Connection to DB closed: " + d.getMessage());
        }
    }

    public long getNumberOfMonthsBetween(String dbObjectName, String firstValue, String secondValue) throws M4Exception {
        try {
            return this.getBusinessDbCore().getNumberOfMonthsBetween(dbObjectName, firstValue, secondValue);
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error trying to find number of months between two dates: Connection to DB closed: " + d.getMessage());
        }
    }

    public String getAliasExpressionForInnerSelects(String aliasName) throws M4Exception {
        try {
            return this.getBusinessDbCore().getAliasExpressionForInnerSelects(aliasName);
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error trying to find alias expression: Connection to DB closed: " + d.getMessage());
        }
    }

    public void createReverseStepTable() throws M4Exception {
        try {
            String numberType = this.getDbNameOfM4Datatype("NUMBER", -1, false);
            String REVSTEP_TABLENAME = "revstep_t";
            String ATTRIB_REV_ID = "rev_id";
            String ATTRIB_REV_ORIGSTEP = "rev_orgstid";
            String ATTRIB_REV_REVSTEP = "rev_revstid";
            String M4_TABLE_NAME = "step_t";
            String ATTRIB_STEP_ID = "st_id";
            this.dropM4Table(REVSTEP_TABLENAME);
            String query = "CREATE TABLE " + REVSTEP_TABLENAME + " (" + ATTRIB_REV_ID + " " + numberType + " NOT NULL," + ATTRIB_REV_ORIGSTEP + " " + numberType + " NOT NULL," + ATTRIB_REV_REVSTEP + " " + numberType + " NOT NULL," + " CONSTRAINT REVST_PK PRIMARY KEY (" + ATTRIB_REV_ID + ")," + " CONSTRAINT REV_TO_STEP_FK1 FOREIGN KEY (" + ATTRIB_REV_ORIGSTEP + ") REFERENCES " + M4_TABLE_NAME + " (" + ATTRIB_STEP_ID + ")," + " CONSTRAINT REV_TO_STEP_FK2 FOREIGN KEY (" + ATTRIB_REV_REVSTEP + ") REFERENCES " + M4_TABLE_NAME + " (" + ATTRIB_STEP_ID + "))";
            this.executeM4SqlWrite(query);
            this.commitM4Transactions();
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error creating table for links to reversing steps: DB connection closed: " + d.getMessage());
        }
        catch (SQLException se) {
            throw new M4Exception("SQL exception creating table for links to reversing steps: " + se.getMessage());
        }
        catch (M4CompilerError m4c) {
            throw new M4Exception("M4 error creating table for links to reversing steps: " + m4c.getMessage());
        }
    }

    public void executeM4SqlWrite(String query) throws SQLException, DbConnectionClosed {
        this.getM4DbCore().executeSqlWrite(query);
    }

    public void executeBusinessSqlWrite(String query) throws SQLException, DbConnectionClosed {
        this.getBusinessDbCore().executeSqlWrite(query);
    }

    public ResultSet executeM4SqlRead(String query) throws SQLException, DbConnectionClosed {
        return this.getM4DbCore().executeSqlRead(query);
    }

    public ResultSet executeBusinessSqlRead(String query) throws SQLException, DbConnectionClosed {
        return this.getBusinessDbCore().executeSqlRead(query);
    }

    public Long executeM4SingleValueSqlReadL(String query) throws SQLException, DbConnectionClosed {
        return this.getM4DbCore().executeSingleValueSqlReadL(query);
    }

    public Long executeBusinessSingleValueSqlReadL(String query) throws SQLException, DbConnectionClosed {
        return this.getBusinessDbCore().executeSingleValueSqlReadL(query);
    }

    public String executeM4SingleValueSqlRead(String query) throws SQLException, DbConnectionClosed {
        return this.getM4DbCore().executeSingleValueSqlRead(query);
    }

    public String executeBusinessSingleValueSqlRead(String query) throws SQLException, DbConnectionClosed {
        return this.getBusinessDbCore().executeSingleValueSqlRead(query);
    }

    public boolean isForeignKeyColumn(Column theColumn) throws M4Exception {
        String name = theColumn.getName();
        Map m = null;
        Columnset cs = null;
        try {
            cs = theColumn.getColumnset();
            if (cs == null) {
                throw new M4Exception("DB.isColumnForeignKey: found no columnset for column '" + name + "'!");
            }
            m = this.getBusinessDbCore().getTablesReferencedBy(cs.getName());
        }
        catch (SQLException sqle) {
            throw new M4Exception("Error reading foreign key information for columnset '" + cs.getName() + "': " + sqle.getMessage());
        }
        catch (DbConnectionClosed d) {
            throw new M4Exception("Error testing if column '" + name + "' is a foreign key: connection to DB lost: " + d.getMessage());
        }
        for (Map.Entry myEntry : m.entrySet()) {
            String columnName = (String)myEntry.getKey();
            String tableReferenced = (String)myEntry.getValue();
            if (tableReferenced == null || !name.equalsIgnoreCase(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryKeyColumn(Column theColumn) throws M4Exception {
        String name = theColumn.getName();
        Collection primKeyCols = null;
        Columnset cs = theColumn.getColumnset();
        if (cs == null) {
            throw new M4Exception("DB.isColumnPrimaryKey: found no columnset for column '" + name + "'!");
        }
        primKeyCols = this.getPrimaryKeysFromDbSchema(cs);
        if (primKeyCols != null && !primKeyCols.isEmpty()) {
            for (Column myCol : primKeyCols) {
                if (myCol == null || !myCol.getName().equalsIgnoreCase(name)) continue;
                return true;
            }
        }
        return false;
    }

    public String getM4RelationalDatatypeName(String dbTypeName, boolean useBusinessDBMS) throws M4Exception {
        try {
            if (useBusinessDBMS) {
                return this.getBusinessDbCore().getM4DatatypeName(dbTypeName);
            }
            return this.getM4DbCore().getM4DatatypeName(dbTypeName);
        }
        catch (DbConnectionClosed dbcc) {
            throw new M4Exception("DB.getM4RelationalDatatypeName: Db connection closed:" + dbcc.getMessage());
        }
    }

    public String getM4RelTypeForConceptualType(String conceptualType) {
        if (conceptualType.equals("BINARY") || conceptualType.equals("NOMINAL") || conceptualType.equals("CATEGORIAL")) {
            return "STRING";
        }
        if (conceptualType.equals("NUMERIC")) {
            return "NUMBER";
        }
        if (conceptualType.equals("KEYATTRIB")) {
            return "KEY";
        }
        if (conceptualType.equals("TIME") || conceptualType.equals("TIMEGROUP")) {
            return "DATE";
        }
        return null;
    }

    public long getNextM4SequenceValue() throws DbConnectionClosed, M4Exception {
        return this.getM4DbCore().getNextM4SequenceValue();
    }

    protected void doPrint(Level verbosity, String message) {
        this.getCasePrintObject().doPrint(verbosity, message);
    }

    protected void doPrint(Exception ex) {
        this.getCasePrintObject().doPrint(Print.ERROR, ex.getMessage(), ex);
    }

    public M4InterfaceContext getCompilerAccessLogic() {
        return this.cal;
    }

    private DbCore getM4DbCore() throws DbConnectionClosed {
        return this.m4Dbc;
    }

    public DbCore getBusinessDbCore() throws DbConnectionClosed {
        return this.busiDbc;
    }

    public M4Object createNewInstance(Class c) throws M4Exception {
        Class coreClass = this.ensureCoreClass(c);
        if (!M4Object.class.isAssignableFrom(coreClass)) {
            throw new M4Exception("Error: M4Object.createNewInstance(Class) failed, because the Class object provided is not assignment compatible to M4Object!");
        }
        try {
            if (Modifier.isAbstract(coreClass.getModifiers())) {
                throw new M4Exception("DB.createNewInstance(" + coreClass.getName() + "): Cannot instantiate an abstract class!");
            }
            Constructor constr = coreClass.getConstructor(CONSTR_ARGS);
            if (constr == null) {
                throw new M4Exception("DB.createNewInstance(" + coreClass.getName() + "):\n" + " This class does not have the necessary constructor with argument class DB!");
            }
            Object[] parameters = new Object[]{this};
            return (M4Object)constr.newInstance(parameters);
        }
        catch (Exception e) {
            throw new M4Exception("Error: M4Object.createNewInstance(Class) failed:\n" + e.getMessage());
        }
    }

    public boolean createSQLView(Columnset cs) throws M4Exception {
        try {
            boolean materialized = this.hasToBeMaterialized(cs);
            this.getBusinessDbCore().createSQLView(cs, materialized);
            return materialized;
        }
        catch (SQLException sqle) {
            throw new M4Exception("Error when creating view for Columnset " + cs.getName() + ": " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4Exception("DB Connection closed when creating view for Columnset " + cs.getName() + ": " + dbe.getMessage());
        }
    }

    private boolean hasToBeMaterialized(Columnset cs) {
        return false;
    }

    public static String closeResultSet(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public static HashSet getDirtyObjectsForTable(String dbTableName) {
        HashMap localCopy = dirtyObjectSets;
        if (dbTableName == null) {
            return null;
        }
        HashSet ret = (HashSet)dirtyObjectSets.get(dbTableName);
        if (ret == null) {
            ret = new HashSet();
            dirtyObjectSets.put(dbTableName, ret);
        }
        return ret;
    }

    public static Collection getObjectsToBeDeletedForTable(String dbTableName) throws M4Exception {
        if (dbTableName == null) {
            return null;
        }
        HashSet<M4Data> ret = new HashSet<M4Data>();
        HashSet dirty = (HashSet)dirtyObjectSets.get(dbTableName);
        if (dirty == null || dirty.isEmpty()) {
            return ret;
        }
        for (M4Data myM4Obj : dirty) {
            if (!myM4Obj.isWaitingForDelete() && !myM4Obj.hasDeleteStatus()) continue;
            ret.add(myM4Obj);
        }
        if (dbTableName.equalsIgnoreCase("chain_t")) {
            LinkedList<edu.udo.cs.miningmart.m4.M4Object> chains = new LinkedList<edu.udo.cs.miningmart.m4.M4Object>();
            chains.addAll(ret);
            Vector<Chain> rightOrder = new Vector<Chain>();
            Object firstChainMovedToEnd = null;
            boolean firstIterationDone = false;
            while (!chains.isEmpty()) {
                Collection subChains;
                Chain current = (Chain)chains.removeFirst();
                if (firstChainMovedToEnd != null && firstChainMovedToEnd.equals(current)) {
                    firstIterationDone = true;
                }
                if ((subChains = current.getDirectSubChains()).isEmpty()) {
                    rightOrder.add(current);
                    continue;
                }
                if (!firstIterationDone) {
                    for (Chain sub : subChains) {
                        boolean subChainWasThere = chains.remove(sub);
                        if (!subChainWasThere) continue;
                        chains.addLast(sub);
                    }
                    if (firstChainMovedToEnd == null) {
                        firstChainMovedToEnd = current;
                    }
                    chains.addLast(current);
                    continue;
                }
                rightOrder.add(current);
            }
            return rightOrder;
        }
        return ret;
    }

    private static void clearDirtyObjectSets() {
        dirtyObjectSets.clear();
    }

    public void updateDatabase() throws M4Exception {
        if (this.m4Dbc == null || this.busiDbc == null) {
            return;
        }
        int numOfSets = ORDER_FOR_WRITING.length;
        HashMap<String, Collection> deleteThose = new HashMap<String, Collection>();
        boolean dirty = true;
        int passes = 0;
        try {
            int counter = 0;
            do {
                ++counter;
                for (int i = numOfSets - 1; i >= 0; --i) {
                    String dbTableName = ORDER_FOR_WRITING[i];
                    Collection c = DB.getObjectsToBeDeletedForTable(dbTableName);
                    Vector toBeDeleted = c != null ? new Vector(c) : new Vector();
                    for (M4Data m4ToDelete : toBeDeleted) {
                        try {
                            m4ToDelete.deleteSoon();
                            m4ToDelete.removeFromDb();
                        }
                        catch (M4Exception m4e) {}
                    }
                }
            } while (counter < 3);
        }
        catch (M4Exception m4e) {
            // empty catch block
        }
        while (passes++ < 3 && dirty) {
            int i;
            this.doPrint(Print.DB_WRITE, "*** Updating database! Pass " + passes + ": ***");
            for (i = 0; i < numOfSets; ++i) {
                String dbTableName = ORDER_FOR_WRITING[i];
                Collection deleteCol = M4Data.updateObjectsFromTable(dbTableName);
                Collection delMap = (Collection)deleteThose.get(dbTableName);
                if (delMap == null) {
                    deleteThose.put(dbTableName, deleteCol);
                    continue;
                }
                delMap.addAll(deleteCol);
            }
            dirty = false;
            for (i = 0; i < numOfSets; ++i) {
                String dbTableName = ORDER_FOR_WRITING[i];
                HashSet col = DB.getDirtyObjectsForTable(dbTableName);
                int colSize = col.size();
                this.doPrint(Print.DB_WRITE, "Remaining objects to be updated from table " + dbTableName + ": " + colSize);
                dirty = dirty || colSize > 0;
            }
        }
        if (dirty) {
            this.doPrint(Print.MAX, "DB.updateDatabase(): Warning, could not update all dirty database objects!\nIt might be a good idea to close and restart this application!");
        }
        for (int i = numOfSets - 1; i >= 0; --i) {
            String dbTableName = ORDER_FOR_WRITING[i];
            Collection dirtySet = (Collection)deleteThose.get(dbTableName);
            if (dirtySet == null) continue;
            M4Data.removeSetFromDb(dirtySet);
        }
        try {
            this.commitM4Transactions();
            this.commitBusinessTransactions();
            this.doPrint(Print.DB_WRITE, "Database is up to date now!");
        }
        catch (SQLException e) {
            this.clearM4Cache();
            throw new M4Exception("SQLException caught at DB.updateDatabase() when trying to commit changes:\n" + e.getMessage());
        }
        catch (DbConnectionClosed e) {
            this.clearM4Cache();
            throw new M4Exception("Error: The database connection was closed before the updates could be committed at DB.updateDatabase()!\nException message is:\n" + e.getMessage());
        }
    }
}

