/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.db;

import edu.udo.cs.miningmart.exception.M4Exception;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;

public class ConfigReader
implements Serializable {
    public static final String M4_DRIVER = "M4_JDBC_DRIVER";
    public static final String M4_LOCATION = "M4_HOST_PORT";
    public static final String M4_DBNAME = "M4_DBNAME";
    public static final String M4_USER = "M4_USER";
    public static final String M4_PW = "M4_PASSWORD";
    public static final String BUS_DRIVER = "BUS_JDBC_DRIVER";
    public static final String BUS_LOCATION = "BUS_HOST_PORT";
    public static final String BUS_DBNAME = "BUS_DBNAME";
    public static final String BUS_USER = "BUS_USER";
    public static final String BUS_PW = "BUS_PASSWORD";
    private String m4Url;
    private String m4Driver;
    private String m4Host;
    private String m4DbName;
    private String m4User;
    private String m4Pw;
    private String busUrl;
    private String busDriver;
    private String busHost;
    private String busDbName;
    private String busUser;
    private String busPw;

    public ConfigReader(String configFileName) throws M4Exception {
        String errMsg = "(I/O) Error trying to read Db config file '" + configFileName + "': ";
        try {
            LineNumberReader myLineReader = new LineNumberReader(new FileReader(configFileName));
            String myLine = myLineReader.readLine();
            if (myLine == null) {
                throw new M4Exception(errMsg + "Nothing found in the file.");
            }
            while (myLine != null && (myLine.trim().equals("") || myLine.trim().startsWith("#"))) {
                myLine = myLineReader.readLine();
            }
            if (myLine == null) {
                throw new M4Exception(errMsg + "No information found in the file.");
            }
            if (myLine.indexOf("=") == -1) {
                this.readOldFormatDbConfig(myLineReader, myLine, errMsg);
            } else {
                while (myLine != null) {
                    this.readKeyValuePair(myLine, errMsg);
                    myLine = myLineReader.readLine();
                    while (myLine != null && (myLine.equals("") || myLine.startsWith("#"))) {
                        myLine = myLineReader.readLine();
                    }
                }
                if (this.m4Driver != null && this.m4Host != null && this.busDriver != null && this.busHost != null) {
                    this.m4Url = this.m4Driver + this.m4Host;
                    this.busUrl = this.busDriver + this.busHost;
                }
            }
            if (this.busDbName == null || this.busPw == null || this.busUrl == null || this.busUser == null || this.m4DbName == null || this.m4Pw == null || this.m4Url == null || this.m4User == null) {
                throw new M4Exception(errMsg + "Not all information was found!");
            }
            myLineReader.close();
        }
        catch (IOException ioe) {
            throw new M4Exception(errMsg + ioe.getMessage());
        }
    }

    private void readKeyValuePair(String line, String errMsg) throws M4Exception {
        int indexOfEqualSign = line.indexOf("=");
        if (indexOfEqualSign == -1) {
            throw new M4Exception(errMsg + "Invalid key-value pair, line: " + line);
        }
        String key = line.substring(0, indexOfEqualSign).trim();
        String value = null;
        if (line.length() > indexOfEqualSign + 1) {
            value = line.substring(indexOfEqualSign + 1).trim();
        }
        if (value == null || value.equals("")) {
            throw new M4Exception(errMsg + "Empty value for key '" + key + "'!");
        }
        if (key.equals(M4_DBNAME)) {
            this.m4DbName = value;
        } else if (key.equals(M4_USER)) {
            this.m4User = value;
        } else if (key.equals(M4_DRIVER)) {
            this.m4Driver = value;
        } else if (key.equals(M4_LOCATION)) {
            this.m4Host = value;
        } else if (key.equals(M4_PW)) {
            this.m4Pw = value;
        } else if (key.equals(BUS_DBNAME)) {
            this.busDbName = value;
        } else if (key.equals(BUS_USER)) {
            this.busUser = value;
        } else if (key.equals(BUS_DRIVER)) {
            this.busDriver = value;
        } else if (key.equals(BUS_LOCATION)) {
            this.busHost = value;
        } else if (key.equals(BUS_PW)) {
            this.busPw = value;
        } else {
            throw new M4Exception(errMsg + "Unknown key found in this line: " + line);
        }
    }

    private void readOldFormatDbConfig(LineNumberReader lnr, String firstLine, String errMsg) throws M4Exception {
        this.m4DbName = firstLine;
        this.m4User = this.getNextLine(lnr, errMsg);
        this.m4Pw = this.getNextLine(lnr, errMsg);
        this.m4Driver = this.getNextLine(lnr, errMsg);
        this.m4Host = this.getNextLine(lnr, errMsg);
        this.m4Url = this.m4Driver + this.m4Host;
        String myLine = null;
        try {
            myLine = lnr.readLine();
        }
        catch (IOException ioe) {
            throw new M4Exception(errMsg + ioe.getMessage());
        }
        if (myLine == null || !myLine.trim().equals("")) {
            throw new M4Exception(errMsg + "Wrong file format: expected one empty line between M4 and Business connection infos!");
        }
        this.busDbName = this.getNextLine(lnr, errMsg);
        this.busUser = this.getNextLine(lnr, errMsg);
        this.busPw = this.getNextLine(lnr, errMsg);
        this.busDriver = this.getNextLine(lnr, errMsg);
        this.busHost = this.getNextLine(lnr, errMsg);
        this.busUrl = this.busDriver + this.busHost;
    }

    private String getNextLine(LineNumberReader lnr, String errMsg) throws M4Exception {
        try {
            String line = lnr.readLine();
            if (line == null) {
                throw new M4Exception(errMsg + "Unexpected end of file.");
            }
            if (line.trim().equals("")) {
                throw new M4Exception(errMsg + "Wrong file format, found empty line where information was expected.");
            }
            return line.trim();
        }
        catch (IOException ioe) {
            throw new M4Exception(errMsg + ioe.getMessage());
        }
    }

    public String getBusDbName() {
        return this.busDbName;
    }

    public String getBusPw() {
        return this.busPw;
    }

    public String getBusUrl() {
        return this.busUrl;
    }

    public String getBusDriver() {
        return this.busDriver;
    }

    public String getBusHost() {
        int colonIndex = this.busHost.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        int startIndex = this.busHost.startsWith("@") ? 1 : 2;
        return this.busHost.substring(startIndex, colonIndex);
    }

    public String getBusPort() {
        int colonIndex = this.busHost.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        String port = this.busHost.substring(colonIndex + 1);
        if (port.endsWith(":")) {
            port = port.substring(0, port.length() - 1);
        }
        return port;
    }

    public String getM4Driver() {
        return this.m4Driver;
    }

    public String getM4Host() {
        int colonIndex = this.m4Host.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        int startIndex = this.m4Host.startsWith("@") ? 1 : 2;
        return this.m4Host.substring(startIndex, colonIndex);
    }

    public String getM4Port() {
        int colonIndex = this.m4Host.indexOf(":");
        if (colonIndex == -1) {
            return null;
        }
        String port = this.m4Host.substring(colonIndex + 1);
        if (port.endsWith(":")) {
            port = port.substring(0, port.length() - 1);
        }
        return port;
    }

    public String getBusUser() {
        return this.busUser;
    }

    public String getM4DbName() {
        return this.m4DbName;
    }

    public String getM4Pw() {
        return this.m4Pw;
    }

    public String getM4Url() {
        return this.m4Url;
    }

    public String getM4User() {
        return this.m4User;
    }
}

