/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.db;

import edu.udo.cs.miningmart.compiler.utils.DrawSample;
import edu.udo.cs.miningmart.db.ConfigReader;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.db.DbCore;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.Feature;
import edu.udo.cs.miningmart.m4.M4InterfaceContext;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.m4.core.RelationalDatatypes;
import edu.udo.cs.miningmart.m4.utils.Print;
import edu.udo.cs.miningmart.storedProcedures.BusinessDbConnectionSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class CompilerDatabaseService
extends DB
implements BusinessDbConnectionSource {
    public CompilerDatabaseService(String m4Url, String m4DbName, String m4User, String m4Passwd, String dataUrl, String dataDbName, String dataUser, String dataPasswd, boolean computeStatistics, M4InterfaceContext cal) throws SQLException {
        super(m4Url, m4DbName, m4User, m4Passwd, dataUrl, dataDbName, dataUser, dataPasswd, computeStatistics, cal);
    }

    public CompilerDatabaseService(ConfigReader cr, boolean computeStatistics, M4InterfaceContext cal) throws SQLException {
        super(cr, computeStatistics, cal);
    }

    public CompilerDatabaseService(DB db, M4InterfaceContext m4i) {
        super(db, m4i);
    }

    public boolean createSQLView(Columnset cs, Step step) throws M4CompilerError {
        try {
            boolean materialized = super.createSQLView(cs);
            long stepId = step.getId();
            if (materialized) {
                this.addTableToTrash(cs.getName(), cs.getSchema(), stepId);
            } else {
                this.addViewToTrash(cs.getName(), cs.getSchema(), stepId);
            }
            return materialized;
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when creating view for Columnset " + cs.getName() + ": " + dbe.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4Exception caught when creating view for Columnset " + cs.getName() + ": " + m4e.getMessage());
        }
    }

    public void addTableToTrash(String tableName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(tableName, schemaName, "T", stepId);
    }

    public void addPkConstraintToTrash(String tableName, String constraintName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(tableName + "." + constraintName, schemaName, "PK", stepId);
    }

    public void addFkConstraintToTrash(String tableName, String constraintName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(tableName + "." + constraintName, schemaName, "FK", stepId);
    }

    public void addFunctionToTrash(String functionName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(functionName, schemaName, "F", stepId);
    }

    public void addIndexToTrash(String indexName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(indexName, schemaName, "I", stepId);
    }

    public void addViewToTrash(String viewName, String schemaName, long stepId) throws M4CompilerError {
        this.addDatabaseObjectToTrash(viewName, schemaName, "V", stepId);
    }

    private void addDatabaseObjectToTrash(String objectName, String schemaName, String objectType, long stepId) throws M4CompilerError {
        Step theStep = null;
        String msg = null;
        try {
            theStep = (Step)this.getM4Object(stepId, Step.class);
        }
        catch (M4Exception e) {
            msg = e.getMessage();
        }
        if (theStep == null) {
            throw new M4CompilerError("Could not add database object to trash of step with ID" + stepId + "!\n" + (msg == null ? " Step not found!" : "Exception: " + msg));
        }
        try {
            theStep.addDatabaseObjectToTrash(objectName, schemaName, objectType);
        }
        catch (M4Exception e) {
            throw new M4CompilerError(e.getMessage());
        }
    }

    public Connection getDatabaseConnectionForData() throws M4CompilerError {
        try {
            return this.getBusinessDbCore().getExternalDatabaseConnection();
        }
        catch (SQLException e) {
            throw new M4CompilerError("DB.getDatabaseConnectionForData(): Could not create new Connection for external usage:\n" + e.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed: " + dbe.getMessage());
        }
    }

    public long readCaseIdForStepId(long stepId) throws M4CompilerError {
        try {
            String query = "SELECT st_caid FROM step_t WHERE st_id = " + stepId;
            Long caseId = this.executeM4SingleValueSqlReadL(query);
            if (caseId == null) {
                throw new M4CompilerError("M4 Database: Case not found");
            }
            return caseId;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL error when reading case info for step " + stepId + ":\n" + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when reading case info for step " + stepId + ":\n" + dbe.getMessage());
        }
    }

    public String computeSum(Column col) throws M4CompilerError {
        try {
            Columnset cs = col.getColumnset();
            String query = "SELECT SUM(" + col.getSQLDefinition() + ") FROM " + cs.getSchemaPlusName();
            String sum = this.executeBusinessSingleValueSqlRead(query);
            return sum;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL Error trying to compute sum for column " + col.getId() + ":\n" + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when computing sum in column " + col.getId() + ":\n" + dbe.getMessage());
        }
    }

    public String computeNumberOfDistinctElements(Column col) throws M4CompilerError {
        try {
            Columnset cs = col.getColumnset();
            String query = "SELECT COUNT(DISTINCT(" + col.getSQLDefinition() + ")) FROM " + cs.getSchemaPlusName();
            String sum = this.executeBusinessSingleValueSqlRead(query);
            return sum;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL Error trying to compute no of elements for column " + col.getId() + ":\n" + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when computing element number in column " + col.getId() + ":\n" + dbe.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long testSQLColumn(Column col) throws M4CompilerError {
        String m4DataType;
        String dataType = null;
        ResultSet rs = null;
        try {
            String query = this.getColumnTestQuery(col);
            rs = this.executeBusinessSqlRead(query);
            ResultSetMetaData md = rs.getMetaData();
            dataType = md.getColumnTypeName(1);
        }
        catch (SQLException sqle) {
            try {
                throw new M4CompilerError("SQL Error testing SQL definition for column " + col.getId() + ": " + sqle.getMessage());
                catch (DbConnectionClosed dbe) {
                    throw new M4CompilerError("DB Connection closed when testing definition for column " + col.getId() + ": " + dbe.getMessage());
                }
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        if (dataType != null && (m4DataType = this.busiDbc.getM4DatatypeName(dataType)) != null) {
            try {
                return new RelationalDatatypes(this).getIdForName(m4DataType);
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError("M4 error when testing a new Column: " + m4e.getMessage());
            }
        }
        throw new M4CompilerError("SQL-Datatype returned for column not known: Got " + dataType + " but expected NUMBER/NUMERIC or VARCHAR or DATE or CHAR");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCountOfElements(Column col) throws M4CompilerError {
        Vector<String> theElements = new Vector<String>();
        ResultSet rs = null;
        try {
            String query = "SELECT " + col.getName() + ", COUNT(" + col.getName() + ") AS ItemsCount " + "FROM " + col.getColumnset().getName() + " GROUP BY " + col.getName() + " ORDER BY " + col.getName();
            rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                theElements.add(rs.getString("ItemsCount") + "," + rs.getString(col.getName()));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ":\n" + sqle.getMessage());
                catch (DbConnectionClosed dbe) {
                    throw new M4CompilerError("DB Connection closed when counting elements in column " + col.getId() + ": " + dbe.getMessage());
                }
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        theElements.trimToSize();
        String[] El = new String[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (String)theElements.get(i);
            ++i;
        }
        return El;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCountOfElements(Column colCA, Column colTA) throws M4CompilerError {
        Vector<String> theElements = new Vector<String>();
        ResultSet rs = null;
        try {
            String query = "SELECT " + colTA.getName() + ", " + colCA.getName() + ", COUNT(" + colTA.getName() + ") AS ItemsCount " + "FROM " + colTA.getColumnset().getName() + " GROUP BY " + colTA.getName() + ", " + colCA.getName() + " ORDER BY " + colTA.getName();
            this.doPrint(Print.DB_READ, "DB Query: " + query);
            rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                theElements.add(rs.getString("ItemsCount") + "," + rs.getString(colCA.getName()) + "," + rs.getString(colTA.getName()));
            }
        }
        catch (SQLException sqle) {
            try {
                throw new M4CompilerError("Error trying to read distinct values in column " + colTA.getName() + "," + colCA.getName() + ": " + sqle.getMessage());
                catch (DbConnectionClosed dbe) {
                    throw new M4CompilerError("DB Connection closed when counting elements in column " + colCA.getId() + ": " + dbe.getMessage());
                }
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        theElements.trimToSize();
        String[] El = new String[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (String)theElements.get(i);
            ++i;
        }
        return El;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCountOfElements(Column colCA, Column colTA, long sampleSize) throws DbConnectionClosed, M4CompilerError {
        Vector<String> theElements = new Vector<String>();
        ResultSet rs = null;
        try {
            Columnset cs = colTA.getColumnset();
            String tableName = cs.getSchemaPlusName();
            String query = "SELECT COUNT(*) FROM " + tableName;
            String rowcount = this.executeBusinessSingleValueSqlRead(query);
            this.doPrint(Print.OPERATOR, "Sample " + sampleSize + " of " + rowcount);
            double sampleRatio = (double)sampleSize / (double)Long.parseLong(rowcount) * 100.0;
            this.doPrint(Print.OPERATOR, "SampleRatio:" + sampleRatio + "%");
            if (sampleRatio < 100.0) {
                Vector<String> selectedCols = new Vector<String>();
                selectedCols.add(colCA.getName().toUpperCase());
                selectedCols.add(colTA.getName().toUpperCase());
                tableName = "SAMPLE_" + cs.getId();
                String tmpTableName = "TMP_" + cs.getId();
                new DrawSample(colCA.getColumnset(), selectedCols, tableName, tmpTableName, new Long(rowcount), sampleSize, null, this);
                query = "SELECT " + colTA.getName() + ", " + colCA.getName() + ", COUNT(" + colTA.getName() + ") AS ItemsCount " + " FROM " + tableName + " GROUP BY " + colTA.getName() + ", " + colCA.getName() + " ORDER BY " + colTA.getName();
            } else {
                query = "SELECT " + colTA.getSQLDefinition() + " " + colTA.getName() + ", " + colCA.getSQLDefinition() + " " + colCA.getName() + ", COUNT(" + colTA.getSQLDefinition() + ") AS ItemsCount " + " FROM " + tableName + " GROUP BY " + colTA.getSQLDefinition() + ", " + colCA.getSQLDefinition() + " ORDER BY " + colTA.getSQLDefinition();
            }
            this.doPrint(Print.DB_READ, "DB Query: " + query);
            rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                theElements.add(rs.getString("ItemsCount") + "," + rs.getString(colCA.getName()) + "," + rs.getString(colTA.getName()));
            }
            this.dropBusinessTable(tableName);
        }
        catch (SQLException sqle) {
            try {
                throw new M4CompilerError("Error trying to read distinct values in column " + colTA.getName() + "," + colCA.getName() + ": " + sqle.getMessage());
                catch (M4Exception m4e) {
                    throw new M4CompilerError(m4e.getMessage());
                }
                catch (DbConnectionClosed dbe) {
                    throw new M4CompilerError("DB Connection closed when counting elements in column " + colCA.getId() + ": " + dbe.getMessage());
                }
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        theElements.trimToSize();
        String[] El = new String[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            El[i] = (String)theElements.get(i);
            ++i;
        }
        return El;
    }

    public String[][] getFrquencyTable(Column theClassAttribute, Feature[] theAttributes, String[] classValues) throws M4CompilerError {
        int i;
        ArrayList<String> Attr = new ArrayList<String>();
        ArrayList<long[]> AVal = new ArrayList<long[]>();
        String query = "SELECT * FROM ";
        String t = "";
        for (i = 0; i < theAttributes.length; ++i) {
            t = i == 0 ? theAttributes[i].getName() : t + ", " + theAttributes[i].getName();
            String s = "SELECT DISTINCT " + theAttributes[i].getName() + " FROM " + theClassAttribute.getColumnset().getName() + " ORDER BY " + theAttributes[i].getName();
            if (i != 0) {
                query = query + ", ";
            }
            query = query + "(" + s + ") AS T" + i;
        }
        query = query + " ORDER BY " + t;
        ResultSet rs = null;
        try {
            rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                String s = rs.getString(theAttributes[0].getName());
                for (i = 1; i < theAttributes.length; ++i) {
                    s = s + ", " + rs.getString(theAttributes[i].getName());
                }
                Attr.add(s);
                AVal.add(new long[classValues.length + 1]);
            }
            Attr.add("Total");
            AVal.add(new long[classValues.length + 1]);
            rs.close();
        }
        catch (SQLException sqle) {
            String s = "Error trying to read distinct values in columns " + theAttributes[0].getName();
            for (i = 1; i < theAttributes.length; ++i) {
                s = s + ", " + theAttributes[i].getName();
            }
            s = s + ": " + sqle.getMessage();
            throw new M4CompilerError(s);
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when computing frequency table: " + dbe.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
        try {
            for (i = 0; i < classValues.length; ++i) {
                int n;
                String s = theAttributes[0].getName();
                for (n = 1; n < theAttributes.length; ++n) {
                    s = s + " || ', ' || " + theAttributes[n].getName();
                }
                query = "SELECT (" + s + ") AS Label, Count(*) AS Freq " + " FROM " + theClassAttribute.getColumnset().getName() + " WHERE " + theClassAttribute.getName() + " = '" + classValues[i] + "'" + " GROUP BY ";
                s = theAttributes[0].getName();
                for (n = 1; n < theAttributes.length; ++n) {
                    s = s + ", " + theAttributes[n].getName();
                }
                query = query + s;
                rs = this.executeBusinessSqlRead(query);
                n = 0;
                while (rs.next()) {
                    s = rs.getString("Label");
                    while (!s.equals(Attr.get(n))) {
                        ++n;
                    }
                    ((long[])AVal.get((int)n))[i] = Long.parseLong(rs.getString("Freq"));
                }
                rs.close();
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL Error when accessing frequency table: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when accessing frequency table: " + dbe.getMessage());
        }
        finally {
            DB.closeResultSet(rs);
        }
        String[][] retVal = new String[Attr.size()][classValues.length + 2];
        long[] sumCA = new long[classValues.length + 1];
        for (i = 0; i < Attr.size() - 1; ++i) {
            retVal[i][0] = (String)Attr.get(i);
            long[] val = (long[])AVal.get(i);
            long sum = 0L;
            for (int n = 0; n < classValues.length; ++n) {
                retVal[i][n + 1] = Long.toString(val[n]);
                sum += val[n];
                sumCA[n] = sumCA[n] + val[n];
            }
            retVal[i][classValues.length + 1] = Long.toString(sum);
        }
        i = Attr.size() - 1;
        retVal[i][0] = (String)Attr.get(i);
        long sum = 0L;
        for (int n = 0; n < classValues.length; ++n) {
            retVal[i][n + 1] = Long.toString(sumCA[n]);
            sum += sumCA[n];
        }
        retVal[i][classValues.length + 1] = Long.toString(sum);
        return retVal;
    }

    public String computeNumberOfElementsForValue(Column col, String value) throws M4CompilerError {
        try {
            Columnset cs = col.getColumnset();
            String valueForQuery = col.getColumnDataType() == 13L ? DB.quote(value) : value;
            String query = "SELECT COUNT(*) FROM " + cs.getSchemaPlusName() + " WHERE " + col.getSQLDefinition() + " = " + valueForQuery;
            String sum = this.executeBusinessSingleValueSqlRead(query);
            return sum;
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL error when computing no of elements per Value for column " + col.getId() + ": " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when computing no of elements per Value for column " + col.getId() + ": " + dbe.getMessage());
        }
    }

    public void executeDBProcedure(String procedureName, String[] parameters, boolean businessDb) throws M4CompilerError {
        try {
            DbCore dbc = businessDb ? this.getBusinessDbCore() : this.getM4DbCore();
            dbc.executeDBProcedure(procedureName, parameters);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("SQL error executing a stored procedure: " + sqle.getMessage());
        }
        catch (DbConnectionClosed dbe) {
            throw new M4CompilerError("DB Connection closed when executing a stored procedure: " + dbe.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getDistinctElements(Column col) throws M4CompilerError {
        Vector<String> theElements = new Vector<String>();
        ResultSet rs = null;
        try {
            String query = "SELECT distinct(" + col.getSQLDefinition() + ") " + "FROM " + col.getColumnset().getSchemaPlusName();
            rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                theElements.add(rs.getString(1));
            }
            rs.close();
        }
        catch (SQLException sqle) {
            try {
                throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ": " + sqle.getMessage());
                catch (DbConnectionClosed dbe) {
                    throw new M4CompilerError("DB Connection closed when reading distinct values for column " + col.getId() + ": " + dbe.getMessage());
                }
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        theElements.trimToSize();
        String[] distEl = new String[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            distEl[i] = (String)theElements.get(i);
            ++i;
        }
        return distEl;
    }

    public String[] getDistinctElements(long columnId) throws M4CompilerError {
        try {
            return this.getDistinctElements((Column)this.getM4Object(columnId, Column.class));
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 error when reading distinct elements for Column with Id " + columnId + ": " + m4e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getDistinctElementsWithoutNull(Column col) throws M4CompilerError {
        Vector<String> theElements = new Vector<String>();
        ResultSet rs = null;
        try {
            String query = "SELECT distinct(" + col.getSQLDefinition() + ") " + "FROM " + col.getColumnset().getSchemaPlusName();
            rs = this.executeBusinessSqlRead(query);
            while (rs.next()) {
                String s = rs.getString(col.getName());
                if (rs.wasNull()) continue;
                theElements.add(s);
            }
            rs.close();
        }
        catch (SQLException sqle) {
            try {
                throw new M4CompilerError("Error trying to read distinct values in column " + col.getName() + ": " + sqle.getMessage());
                catch (DbConnectionClosed dbe) {
                    throw new M4CompilerError("DB Connection closed when reading distinct values for column " + col.getId() + ": " + dbe.getMessage());
                }
            }
            catch (Throwable throwable) {
                DB.closeResultSet(rs);
                throw throwable;
            }
        }
        DB.closeResultSet(rs);
        theElements.trimToSize();
        String[] distEl = new String[theElements.size()];
        int i = 0;
        while (i < theElements.size()) {
            distEl[i] = (String)theElements.get(i);
            ++i;
        }
        return distEl;
    }

    public Collection getDeviatingValues(Column col, String[] expectedValues) throws M4CompilerError {
        if (col == null) {
            return null;
        }
        String[] actualValues = this.getDistinctElementsWithoutNull(col);
        Vector<String> ret = new Vector<String>();
        if (expectedValues != null) {
            for (int i = 0; i < actualValues.length; ++i) {
                if (this.arrayContainsIgnoringCase(expectedValues, actualValues[i])) continue;
                ret.add(actualValues[i]);
            }
        }
        return ret;
    }

    private boolean arrayContainsIgnoringCase(String[] theArray, String oneElement) {
        if (theArray == null) {
            return false;
        }
        for (int i = 0; i < theArray.length; ++i) {
            if (!theArray[i].equalsIgnoreCase(oneElement)) continue;
            return true;
        }
        return false;
    }

    public Collection getInputConceptsFor(Step step) throws M4Exception {
        return step.getInputConceptsThatAreParameters();
    }

    private DbCore getM4DbCore() throws DbConnectionClosed {
        if (this.cal.getStopRequest()) {
            this.stopDbThreads();
        }
        return this.m4Dbc;
    }

    public DbCore getBusinessDbCore() throws DbConnectionClosed {
        if (this.cal.getStopRequest()) {
            this.stopDbThreads();
        }
        return this.busiDbc;
    }

    private void stopDbThreads() throws DbConnectionClosed {
        this.m4Dbc.stopDbThread();
        this.busiDbc.stopDbThread();
        throw new DbConnectionClosed("Requested to stop DB threads.");
    }

    public String getSelectStringForColumnDataType(String owner, String tableName, String columnName) {
        return this.busiDbc.getSelectStringColumnDataTypes(tableName, owner, columnName);
    }
}

