/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.MMS3;

import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Attribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NominalAttribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NumericAttribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Schema;
import edu.udo.cs.miningmart.compiler.wrapper.dista.DLFTokenizer;
import edu.udo.cs.miningmart.compiler.wrapper.dista.MMS3.Center;
import edu.udo.cs.miningmart.compiler.wrapper.dista.MMS3.Centers;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class CentersParser {
    DLFTokenizer m_st;
    Schema l_schema;

    public CentersParser(Reader r) {
        this.m_st = new DLFTokenizer(r);
    }

    protected Attribute parseAttr() throws Exception {
        Attribute attr = null;
        String ty = this.m_st.getWord();
        if (ty.equals("nom")) {
            this.m_st.checkBeginRecord();
            attr = new NominalAttribute();
            attr.setName(this.m_st.getString());
            attr.setWeight(this.m_st.getNumber());
            this.m_st.checkEndRecord();
        } else if (ty.equals("num")) {
            this.m_st.checkBeginRecord();
            attr = new NumericAttribute();
            attr.setName(this.m_st.getString());
            attr.setWeight(this.m_st.getNumber());
            ((NumericAttribute)attr).setMinValue(this.m_st.getNumber());
            ((NumericAttribute)attr).setMaxValue(this.m_st.getNumber());
            this.m_st.checkEndRecord();
        } else {
            throw new Exception(this.m_st.errorMsg("expected nom/num words"));
        }
        return attr;
    }

    protected Center parseCenter() throws Exception {
        Center r = new Center(this.l_schema);
        this.m_st.checkBeginList();
        for (int i = 0; i < this.l_schema.getAttributes().size(); ++i) {
            Attribute attr = (Attribute)this.l_schema.getAttributes().elementAt(i);
            if (attr instanceof NumericAttribute) {
                r.setValue(i, this.m_st.getNumericValue());
                continue;
            }
            if (attr instanceof NominalAttribute) {
                r.setValue(i, this.m_st.getNominalValue());
                continue;
            }
            throw new Exception(this.m_st.errorMsg("internal error: unknow attribute class"));
        }
        this.m_st.checkEndList();
        return r;
    }

    public Centers parse() throws Exception {
        Centers cs = new Centers();
        this.l_schema = new Schema();
        cs.setSchema(this.l_schema);
        this.m_st.nextToken();
        if (!this.m_st.getWord().equals("mms3")) {
            throw new Exception(this.m_st.errorMsg("expected mms3 word"));
        }
        this.m_st.checkBeginRecord();
        this.m_st.checkBeginList();
        while (!this.m_st.isEndList()) {
            this.l_schema.addAttr(this.parseAttr());
        }
        this.m_st.checkBeginList();
        while (!this.m_st.isEndList()) {
            cs.addCenter(this.parseCenter());
        }
        this.m_st.checkEndRecord();
        this.m_st.checkEOF();
        this.l_schema = null;
        return cs;
    }

    public static void main(String[] args) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            CentersParser tp = new CentersParser(r);
            Centers centers = tp.parse();
            BufferedWriter w = new BufferedWriter(new FileWriter(args[1]));
            PrintWriter pw = new PrintWriter(w);
            centers.dumpOn(pw);
            pw.close();
            ((Writer)w).close();
        }
        catch (Exception e) {
            System.out.print(e + "\n");
        }
    }
}

