/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista;

import edu.udo.cs.miningmart.compiler.wrapper.dista.DMException;
import java.io.Reader;
import java.io.StreamTokenizer;

public class DLFTokenizer
extends StreamTokenizer {
    public DLFTokenizer(Reader r) {
        super(r);
        this.quoteChar(39);
    }

    public final String errorMsg(String m) {
        String msg = "Error in line " + this.lineno() + " : " + m;
        msg = msg + ". Status [" + (char)this.ttype + " " + this.sval + " " + this.nval + "] ";
        return msg;
    }

    public final String getWord() throws Exception {
        if (this.ttype != -3) {
            throw new DMException(this.errorMsg("Expected Word"));
        }
        String s = this.sval;
        this.nextToken();
        return s;
    }

    public final String getString() throws Exception {
        if (this.ttype != 39) {
            throw new DMException(this.errorMsg("Expected String"));
        }
        String s = this.sval;
        this.nextToken();
        return s;
    }

    public final double getNumber() throws Exception {
        if (this.ttype != -2) {
            throw new DMException(this.errorMsg("Expected Number"));
        }
        double s = this.nval;
        this.nextToken();
        return s;
    }

    public final Double getNumericValue() throws Exception {
        Double v;
        if (this.ttype == -2) {
            v = new Double(this.nval);
        } else if (this.ttype == -3 && this.sval.equals("null")) {
            v = null;
        } else if (this.ttype == 63) {
            v = null;
        } else {
            throw new DMException(this.errorMsg("Expected a Numeric Value"));
        }
        this.nextToken();
        return v;
    }

    public final String getNominalValue() throws Exception {
        String v;
        if (this.ttype == 39) {
            v = this.sval;
        } else if (this.ttype == -3 && this.sval.equals("null")) {
            v = null;
        } else if (this.ttype == 63) {
            v = null;
        } else {
            throw new DMException(this.errorMsg("Expected a Nominal Value"));
        }
        this.nextToken();
        return v;
    }

    public final void checkBeginRecord() throws Exception {
        if (this.ttype != 91) {
            throw new DMException(this.errorMsg("Expected Begin Record"));
        }
        this.nextToken();
    }

    public final void checkEndRecord() throws Exception {
        if (this.ttype != 93) {
            throw new DMException(this.errorMsg("Expected End Record"));
        }
        this.nextToken();
    }

    public final void checkBeginList() throws Exception {
        if (this.ttype != 40) {
            throw new DMException(this.errorMsg("Expected Begin List"));
        }
        this.nextToken();
    }

    public final void checkEndList() throws Exception {
        if (this.ttype != 41) {
            throw new DMException(this.errorMsg("Expected End List"));
        }
        this.nextToken();
    }

    public final boolean isEndList() throws Exception {
        if (this.ttype == 41) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public final boolean isEndRecord() throws Exception {
        if (this.ttype == 93) {
            this.nextToken();
            return true;
        }
        return false;
    }

    public final void checkEOF() throws Exception {
        if (this.ttype != -1) {
            throw new DMException(this.errorMsg("Expected EOF"));
        }
    }

    public final boolean isEOF() throws Exception {
        return this.ttype != -1;
    }
}

