/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.C45;

import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.C45Wrapper;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Tree;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Tree2PLSql;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.TreeParser;
import edu.udo.cs.miningmart.m4.Step;
import edu.udo.cs.miningmart.operator.ExecutableOperator;
import java.io.BufferedReader;
import java.io.FileReader;

public class TreeWrapper
extends C45Wrapper {
    protected Tree m_tree;
    protected double m_pruning_confidence = 0.25;
    protected int m_min_obj = 2;

    public TreeWrapper(Step step, ExecutableOperator exOp) throws Exception {
        super(step, exOp);
    }

    public void setPruningConfidence(double v) {
        this.m_pruning_confidence = v;
    }

    public void setMinObj(int v) {
        this.m_min_obj = v;
    }

    protected void callTool() throws Exception {
        this.callScript("c4.5 -c " + this.m_pruning_confidence + " -m " + this.m_min_obj + " -f " + this.m_file_name);
        this.callScript("tree2dlf -f " + this.m_file_name);
    }

    protected void importResult() throws Exception {
        BufferedReader r = new BufferedReader(new FileReader(this.m_file_name + "_tree.dlf"));
        TreeParser tp = new TreeParser(r);
        this.m_tree = tp.parse();
    }

    protected void saveResult() throws Exception {
        Tree2PLSql t2sql = new Tree2PLSql();
        t2sql.setMetaData(this.m_md);
        t2sql.setResultName(this.m_result_name);
        t2sql.setConnection(this.getM4Db());
        t2sql.convert(this.m_tree);
    }
}

