/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.wrapper.dista.C45;

import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Attribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Cond;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NominalAttribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NominalCond;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NumericAttribute;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.NumericCond;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Rule;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Rules;
import edu.udo.cs.miningmart.compiler.wrapper.dista.C45.Schema;
import edu.udo.cs.miningmart.compiler.wrapper.dista.DLFTokenizer;
import edu.udo.cs.miningmart.compiler.wrapper.dista.DMException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class RulesParser {
    DLFTokenizer m_st;
    Schema l_schema;

    public RulesParser(Reader r) {
        this.m_st = new DLFTokenizer(r);
    }

    protected Attribute parseAttr() throws Exception {
        Attribute attr = null;
        String ty = this.m_st.getWord();
        if (ty.equals("nom")) {
            this.m_st.checkBeginRecord();
            attr = new NominalAttribute();
            attr.setName(this.m_st.getString());
            this.m_st.checkEndRecord();
        } else if (ty.equals("num")) {
            this.m_st.checkBeginRecord();
            attr = new NumericAttribute();
            attr.setName(this.m_st.getString());
            this.m_st.checkEndRecord();
        } else {
            throw new DMException(this.m_st.errorMsg("expected nom/num words"));
        }
        return attr;
    }

    protected Cond parseNominalCond() throws Exception {
        NominalCond cond = new NominalCond();
        this.m_st.checkBeginRecord();
        if (!this.m_st.getWord().equals("eq")) {
            throw new DMException(this.m_st.errorMsg("expected = string"));
        }
        cond.setAttr(this.l_schema.findAttr(this.m_st.getString()));
        cond.setValueName(this.m_st.getString());
        this.m_st.checkEndRecord();
        return cond;
    }

    protected Cond parseNumericCond() throws Exception {
        NumericCond cond = new NumericCond();
        this.m_st.checkBeginRecord();
        cond.setOp(this.m_st.getWord());
        cond.setAttr(this.l_schema.findAttr(this.m_st.getString()));
        cond.setValue(this.m_st.getNumber());
        this.m_st.checkEndRecord();
        return cond;
    }

    protected Cond parseCond() throws Exception {
        Cond n = null;
        String ty = this.m_st.getWord();
        if (ty.equals("nom")) {
            n = this.parseNominalCond();
        } else if (ty.equals("num")) {
            n = this.parseNumericCond();
        } else {
            throw new DMException(this.m_st.errorMsg("expected nom/num words"));
        }
        return n;
    }

    protected Rule parseRule() throws Exception {
        Rule r = new Rule();
        this.m_st.checkBeginRecord();
        this.m_st.checkBeginList();
        while (!this.m_st.isEndList()) {
            r.addCond(this.parseCond());
        }
        r.setReturnValueName(this.m_st.getString());
        this.m_st.checkEndRecord();
        return r;
    }

    public Rules parse() throws Exception {
        Rules rules = new Rules();
        this.l_schema = new Schema();
        rules.setSchema(this.l_schema);
        this.m_st.nextToken();
        if (!this.m_st.getWord().equals("rules")) {
            throw new DMException(this.m_st.errorMsg("expected rules word"));
        }
        this.m_st.checkBeginRecord();
        this.m_st.checkBeginList();
        while (!this.m_st.isEndList()) {
            this.l_schema.addAttr(this.parseAttr());
        }
        this.m_st.checkBeginList();
        while (!this.m_st.isEndList()) {
            rules.addRule(this.parseRule());
        }
        rules.setDefReturnValueName(this.m_st.getString());
        this.m_st.checkEndRecord();
        this.m_st.checkEOF();
        this.l_schema = null;
        return rules;
    }

    public static void main(String[] args) {
        try {
            BufferedReader r = new BufferedReader(new FileReader(args[0]));
            RulesParser tp = new RulesParser(r);
            Rules rules = tp.parse();
            BufferedWriter w = new BufferedWriter(new FileWriter(args[1]));
            PrintWriter pw = new PrintWriter(w);
            rules.dumpOn(pw);
            pw.close();
            ((Writer)w).close();
        }
        catch (Exception e) {
            System.out.print(e + "\n");
        }
    }
}

