/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.wrapper;

import edu.udo.cs.miningmart.compiler.utils.DrawSample;
import edu.udo.cs.miningmart.compiler.wrapper.ColumnInfo;
import edu.udo.cs.miningmart.compiler.wrapper.SVM_Wrapper;
import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;

public abstract class DB_SVM
extends SVM_Wrapper {
    private String defaultGamma = "0,1";
    private boolean viewWasCreated = false;
    private String keyCol = null;

    public DB_SVM(CompilerDatabaseService databaseObj, Print printObj, String nameForDatabaseUse, String nameOfDatabaseSchema, long stepId, String colNameKeyColumn) throws M4CompilerError {
        super(databaseObj, printObj, nameForDatabaseUse, nameOfDatabaseSchema, stepId);
        this.keyCol = colNameKeyColumn;
        this.sampleSize = -1L;
    }

    public DB_SVM(CompilerDatabaseService databaseObj, Print printObj, String nameForDatabaseUse, String nameOfDatabaseSchema, long stepId, String colNameKeyColumn, long sampleSize) throws M4CompilerError {
        this(databaseObj, printObj, nameForDatabaseUse, nameOfDatabaseSchema, stepId, colNameKeyColumn);
        this.sampleSize = sampleSize;
    }

    public void callSVM(Columnset inputColumnset, Column targetColumn, long conceptId, String c, String kernelType, String epsilon, Vector predictingColumns) throws M4CompilerError {
        this.checkForConversion(inputColumnset, predictingColumns, targetColumn);
        this.makeParameterTable(inputColumnset, c, epsilon, kernelType);
        String[] procedureParams = new String[]{CompilerDatabaseService.quote(this.getParTableName())};
        this.getDatabaseObj().executeDBProcedure("mySVM", procedureParams, true);
        this.getDatabaseObj().addTableToTrash(this.getModelTableName(), this.schema, this.myStepId);
        this.getDatabaseObj().addTableToTrash(this.getLogTableName(), this.schema, this.myStepId);
        this.readSVMParameterB();
        if (this.forClassification) {
            this.extractXiAlpha();
        }
        this.extractNumberSV();
        Vector<String> colNamesPredictingAttributes = new Vector<String>();
        for (int i = 0; i < predictingColumns.size(); ++i) {
            colNamesPredictingAttributes.add(((Column)predictingColumns.get(i)).getName());
        }
        this.createDecisionFunctionAsSQL_Function(kernelType);
    }

    private void makeParameterTable(Columnset inputColumnset, String c, String epsilon, String kernelType) throws M4CompilerError {
        String parTableName = this.getParTableName();
        String modelName = this.getModelTableName();
        String logTableName = this.getLogTableName();
        this.checkKernel(kernelType);
        c = this.checkDouble(c);
        epsilon = this.checkDouble(epsilon);
        if (!this.forClassification) {
            this.lossPos = this.checkDouble(this.lossPos);
            this.lossNeg = this.checkDouble(this.lossNeg);
        }
        boolean inputIsView = false;
        String inputViewName = null;
        if (this.shouldCreateInputView()) {
            inputIsView = true;
            inputViewName = this.createInputView(inputColumnset);
        }
        this.createParameterTable(parTableName);
        Vector theKernelParams = this.getKernelParams(kernelType);
        if (theKernelParams != null && !theKernelParams.isEmpty()) {
            String g = (String)theKernelParams.get(0);
            this.defaultGamma = g.substring(g.indexOf(" ") + 1);
        }
        try {
            CompilerDatabaseService db = this.getDatabaseObj();
            if (inputIsView) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "trainset", inputViewName));
            } else {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "trainset", this.inputTableName));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "verbosity", "0"));
            if (this.forClassification) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "svm_type", "pattern"));
                if (this.targetPositive != null && !this.targetPositive.equals("")) {
                    db.executeBusinessSqlWrite(this.insertionString(parTableName, "target_concept", this.targetPositive));
                }
            } else {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "svm_type", "regression"));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "kernel:type", kernelType));
            if (kernelType.equalsIgnoreCase("radial")) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "kernel:gamma", this.defaultGamma));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "c", c));
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "epsilon", epsilon));
            if (!this.forClassification) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "Cpos", this.lossPos));
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "Cneg", this.lossNeg));
            }
            if (inputIsView) {
                for (int i = 0; i < this.theColumnInfos.length - 1; ++i) {
                    db.executeBusinessSqlWrite(this.insertionString(parTableName, "x_column", "X" + i));
                }
            } else {
                for (int i = 0; i < this.theColumnInfos.length - 1; ++i) {
                    db.executeBusinessSqlWrite(this.insertionString(parTableName, "x_column", this.theColumnInfos[i].getColumnName()));
                }
            }
            if (inputIsView) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "y_column", "Y"));
            } else {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "y_column", this.theColumnInfos[this.theColumnInfos.length - 1].getColumnName()));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "model_name", modelName));
            if (this.keyCol != null) {
                db.executeBusinessSqlWrite(this.insertionString(parTableName, "key_column", this.keyCol));
            }
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "xi_alpha", ""));
            db.executeBusinessSqlWrite(this.insertionString(parTableName, "log_name", logTableName));
            db.commitBusinessTransactions();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: could not fill parameter table '" + parTableName + "' for mySVM/db; SQL exception: " + sqle.getMessage());
        }
    }

    private void createParameterTable(String name) throws M4CompilerError {
        try {
            try {
                this.getDatabaseObj().dropBusinessTable(name);
            }
            catch (M4Exception m4e) {
                throw new M4CompilerError(m4e.getMessage());
            }
            String query = "CREATE TABLE " + name + "(PARAMETER VARCHAR2(100) NOT NULL, VALUE VARCHAR2(100))";
            this.getDatabaseObj().executeBusinessSqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: could not create parameter table '" + name + "' for mySVM/db; SQL exception: " + sqle.getMessage());
        }
        this.getDatabaseObj().addTableToTrash(name, this.schema, this.myStepId);
    }

    private boolean shouldCreateInputView() {
        if (this.sampleSize > -1L) {
            return true;
        }
        for (int i = 0; i < this.theColumnInfos.length; ++i) {
            if (this.theColumnInfos[i].mappingIsUsed()) {
                return true;
            }
            if (!Character.isLetter(this.theColumnInfos[i].getSelectString().charAt(0))) {
                return true;
            }
            if (this.theColumnInfos[i].getSelectString().startsWith("to_number")) {
                return true;
            }
            if (!this.theColumnInfos[i].hasMissingValues()) continue;
            return true;
        }
        return false;
    }

    private String createInputView(Columnset inputColumnset) throws M4CompilerError {
        String inViewName = this.getInputViewName();
        this.createNominalConversionFunctions();
        try {
            this.getDatabaseObj().dropBusinessTable(inViewName);
            String ttable = "tmp1_" + this.myStepId;
            boolean useSample = this.sampleSize > -1L;
            Vector<String> allColNames = new Vector<String>();
            for (int i = 0; i < this.theColumnInfos.length; ++i) {
                allColNames.add(this.theColumnInfos[i].getColumnName());
            }
            if (useSample) {
                new DrawSample(inputColumnset, allColNames, ttable, "tmp2_" + this.myStepId, null, this.sampleSize, null, this.getDatabaseObj());
                this.getDatabaseObj().addTableToTrash(ttable, inputColumnset.getSchema(), this.myStepId);
            }
            String query = "CREATE TABLE " + inViewName + " AS (";
            String select = "SELECT ";
            for (int i = 0; i < this.theColumnInfos.length; ++i) {
                boolean thisIsTargetColumn = i == this.theColumnInfos.length - 1;
                String alias = thisIsTargetColumn ? "X" + i + ", " : "Y";
                select = this.theColumnInfos[i].mappingIsUsed() ? select + this.getConversionFunctionName(i) + "(" + this.theColumnInfos[i].getSelectString() + ") AS " + alias : select + this.theColumnInfos[i].getSelectString() + " AS " + alias;
            }
            if (this.keyCol == null) {
                throw new M4CompilerError("DB-SVM: need to construct input view, but found no key column for input table!");
            }
            select = select + ", " + this.keyCol;
            query = useSample ? query + select + " FROM " + ttable : query + select + " FROM " + this.inputTableName;
            query = query + " WHERE " + this.theColumnInfos[this.theColumnInfos.length - 1].getSelectString() + " IS NOT NULL)";
            this.getDatabaseObj().executeBusinessSqlWrite(query);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: could not create inputView '" + inViewName + "' for mySVM/db; SQL exception: " + sqle.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
        this.getDatabaseObj().addTableToTrash(inViewName, this.schema, this.myStepId);
        this.viewWasCreated = true;
        return inViewName;
    }

    private String insertionString(String tableName, String paramName, String value) {
        return "insert into " + tableName + " values ('" + paramName + "', '" + value + "')";
    }

    protected void checkColSetType(String type) throws M4CompilerError {
        if (type.equals("V") && this.keyCol == null) {
            throw new M4CompilerError("DB-SVM wrapper: No parameter 'TheKey' found, but input columnset is View!");
        }
    }

    protected void checkKernel(String kern) throws M4CompilerError {
        if (!kern.equalsIgnoreCase("dot") && !kern.equalsIgnoreCase("radial")) {
            throw new M4CompilerError("DB-SVM wrapper: unknown or disallowed kernel type: " + kern + "!");
        }
    }

    protected Vector getColNamesInput() {
        Vector<String> inputNames = new Vector<String>(this.theColumnInfos.length - 1);
        for (int i = 0; i < this.theColumnInfos.length - 1; ++i) {
            if (this.viewWasCreated) {
                inputNames.add("X" + i);
                continue;
            }
            inputNames.add(this.theColumnInfos[i].getColumnName());
        }
        return inputNames;
    }

    protected String getModelTablePlusCondition() throws M4CompilerError {
        String s = "";
        if (this.viewWasCreated) {
            s = this.getInputViewName() + ", " + this.getModelTableName() + " WHERE " + this.getInputViewName() + "." + this.keyCol + " = " + this.getModelTableName() + ".KEY";
        } else {
            String key = null;
            if (this.keyCol != null) {
                key = this.keyCol;
            } else {
                if (this.usePostgres) {
                    throw new M4CompilerError("DB_SVM: Cannot work on input table without specified key under Postgres!");
                }
                key = "ROWID";
            }
            s = this.inputTableName + ", " + this.getModelTableName() + " WHERE " + this.inputTableName + "." + key + " = " + this.getModelTableName() + ".KEY";
        }
        return s;
    }

    private void createNominalConversionFunctions() throws M4CompilerError {
        try {
            for (int i = 0; i < this.theColumnInfos.length; ++i) {
                if (!this.theColumnInfos[i].mappingIsUsed()) continue;
                String conversionFunction = this.createConversionFunction(this.theColumnInfos[i], this.schema, this.getConversionFunctionName(i));
                this.getDatabaseObj().executeBusinessSqlWrite(conversionFunction);
                this.getDatabaseObj().addFunctionToTrash(this.getConversionFunctionName(i), this.schema, this.myStepId);
            }
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: could not create boolean conversion functions, SQL exception: " + sqle.getMessage());
        }
    }

    private String createConversionFunction(ColumnInfo ci, String schema, String functionName) {
        String theFunction = "CREATE OR REPLACE function ";
        if (this.useOracle) {
            theFunction = theFunction + functionName + "\n(\n";
            theFunction = theFunction + "X IN VARCHAR";
            theFunction = theFunction + "\n)\nRETURN NUMBER \nAS\n";
            theFunction = theFunction + "BEGIN\n";
        }
        if (this.usePostgres) {
            theFunction = theFunction + schema + "." + functionName + "\n(\n";
            theFunction = theFunction + "NUMERIC";
            theFunction = theFunction + "\n)\nRETURNS NUMERIC \nAS '\n";
        }
        theFunction = theFunction + "  DECLARE\n";
        if (this.useOracle) {
            theFunction = theFunction + "    retValue NUMBER;\n";
        }
        if (this.usePostgres) {
            theFunction = theFunction + "    X ALIAS FOR $1;\n";
            theFunction = theFunction + "    retValue NUMERIC;\n";
        }
        theFunction = theFunction + "  BEGIN\n";
        if (ci.mappingIsUsed()) {
            Iterator it = ci.getValuesIterator();
            boolean first = true;
            while (it.hasNext()) {
                String value = (String)it.next();
                String command = first ? "IF" : "ELSIF";
                first = false;
                theFunction = theFunction + "    " + command + " X = '" + value + "'\n" + "      THEN retValue := " + ci.getMappedValue(value) + ";\n";
            }
            theFunction = theFunction + "    END IF;\n";
        }
        theFunction = theFunction + "    RETURN retValue;\n";
        theFunction = theFunction + "  END;\n";
        if (this.useOracle) {
            theFunction = theFunction + "END;\n";
        }
        if (this.usePostgres) {
            theFunction = theFunction + "' LANGUAGE 'plpgsql';";
        }
        return theFunction;
    }

    private String getConversionFunctionName(int index) {
        return this.getDecisionFunctionName() + index;
    }

    private void readSVMParameterB() throws M4CompilerError {
        try {
            String query = "SELECT alpha FROM " + this.getModelTableName() + " WHERE key IS NULL";
            String valueD = this.getDatabaseObj().executeBusinessSingleValueSqlRead(query);
            if (valueD == null) {
                throw new M4CompilerError("DB-SVM wrapper: could not find parameter b in SVM output! Tried to check in table: " + this.getModelTableName());
            }
            this.b = Double.parseDouble(valueD);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: error trying to read parameter b: " + sqle.getMessage());
        }
        catch (NumberFormatException nfe) {
            throw new M4CompilerError("DB-SVM wrapper: error trying to read parameter b: " + nfe.getMessage());
        }
    }

    protected void extractNumberSV() throws M4CompilerError {
        try {
            String query = "SELECT COUNT(*) FROM " + this.getModelTableName() + " WHERE key IS NOT NULL";
            Long count = this.getDatabaseObj().executeBusinessSingleValueSqlReadL(query);
            if (count == null) {
                throw new M4CompilerError("DB-SVM wrapper: could not extract number of support vectors in SVM output! Tried to check in table: " + this.getModelTableName());
            }
            this.noSV = count.intValue();
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("DB-SVM wrapper: error trying to read number of support vectors: " + sqle.getMessage());
        }
    }
}

