/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.utils;

import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.DbConnectionClosed;
import edu.udo.cs.miningmart.exception.M4CompilerError;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.Column;
import edu.udo.cs.miningmart.m4.Columnset;
import edu.udo.cs.miningmart.m4.PrimaryKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

abstract class Sampling {
    public static final long COMMIT_LIMIT = 10000L;
    private final Columnset sourceCs;
    private final String tempTable;
    private final Collection selectedColumns;
    private final long rowcount;
    private final Random random;
    private final DB db;
    protected boolean materializedInput;
    protected boolean usingPostgres;
    protected boolean usingOracle;
    protected boolean usingMysql;
    private String inputTableName;
    private static String SUFFIX_FOR_MATERIALIZED_INPUT = "_MATERIALIZED_FOR_SAMPLING";
    protected Vector allRowIds;
    protected String[] thePrimaryKey;
    protected String numericDatatypeName;
    protected String rowIdentifierName;

    protected Sampling(Columnset sourceCs, Collection selectedColumns, String tempTable, Long rowcount, Long seed, DB db) throws M4CompilerError {
        this.sourceCs = sourceCs;
        this.db = db;
        this.inputTableName = this.sourceCs.getSchemaPlusName();
        this.usingPostgres = this.db.getBusinessDbms() == 2;
        this.usingOracle = this.db.getBusinessDbms() == 1;
        this.usingMysql = this.db.getBusinessDbms() == 3;
        this.numericDatatypeName = this.db.getNameOfNumericDatatype();
        this.rowIdentifierName = this.db.getUniqueRowIdentifier(true);
        this.thePrimaryKey = this.findPrimaryKeyAttribute();
        this.selectedColumns = selectedColumns;
        this.tempTable = tempTable;
        this.allRowIds = new Vector();
        this.rowcount = this.calculateRowCount(rowcount, this.sourceCs, this.db, this.usingPostgres, this.allRowIds, this.inputTableName);
        this.random = seed == null ? new Random() : new Random(seed);
    }

    private long calculateRowCount(Long rowcount, Columnset cs, DB db, boolean usingPostgres, Vector allRowIds, String inputTableName) throws M4CompilerError {
        try {
            if (rowcount == null) {
                String selectWhat = "";
                selectWhat = this.usingOracle ? "COUNT(*)" : this.thePrimaryKey[0];
                String query = "SELECT " + selectWhat + " FROM " + this.inputTableName;
                ResultSet rs = db.executeBusinessSqlRead(query);
                if (this.usingOracle) {
                    rowcount = rs.next() ? new Long(rs.getLong(1)) : null;
                } else {
                    this.allRowIds = new Vector();
                    while (rs.next()) {
                        this.allRowIds.add(new Long(rs.getLong(1)));
                        this.allRowIds.trimToSize();
                    }
                    rowcount = new Long(this.allRowIds.size());
                }
                if (rowcount == null) {
                    String readNumberOfRows = "SELECT COUNT(*) FROM " + this.inputTableName;
                    rowcount = this.db.executeBusinessSingleValueSqlReadL(readNumberOfRows);
                }
                if (rowcount == null) {
                    throw new M4CompilerError("Constructor of DrawSample: Could not determine number of rows for Columnset " + cs.getName());
                }
            }
        }
        catch (SQLException e) {
            throw new M4CompilerError("miningmart.compiler.utils.DrawSample:\n" + e.getMessage());
        }
        return rowcount;
    }

    public String getSourceAttributes() throws M4CompilerError {
        try {
            Collection columns = this.getSourceTableColumns();
            StringBuffer sb = new StringBuffer();
            for (Column theCol : columns) {
                String colName = theCol.getName().toUpperCase();
                if (this.selectedColumns != null && !this.selectedColumns.contains(colName) || theCol.getTheBaseAttribute() == null) continue;
                sb.append(colName + ", ");
            }
            int le = sb.length();
            if (le >= 2) {
                sb.delete(le - 2, le);
            }
            return sb.toString();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getSourceAttributeDefinitions() throws M4CompilerError {
        try {
            Collection columns = this.getSourceTableColumns();
            StringBuffer sb = new StringBuffer();
            for (Column theColumn : columns) {
                if (this.selectedColumns != null && !this.selectedColumns.contains(theColumn.getName().toUpperCase()) || theColumn.getTheBaseAttribute() == null) continue;
                String sql = theColumn.getSQLDefinition();
                String name = theColumn.getName();
                if (sql == null || sql.equals(name) || this.materializedInput) {
                    sb.append(name);
                } else {
                    sb.append("(" + sql + ") AS " + name);
                }
                sb.append(", ");
            }
            int le = sb.length();
            if (le >= 2) {
                sb.delete(le - 2, le);
            }
            return sb.toString();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getSourceTableName() {
        return this.inputTableName;
    }

    public Collection getSourceTableColumns() throws M4CompilerError {
        try {
            return this.sourceCs.getColumns();
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("M4 interface error in Sampling: " + m4e.getMessage());
        }
    }

    public String getTempTableName() {
        return this.tempTable;
    }

    public long getRowCount() {
        return this.rowcount;
    }

    public double getNextRandomDouble() {
        return this.random.nextDouble();
    }

    protected void dbWrite(String sql) throws SQLException, DbConnectionClosed {
        this.db.executeBusinessSqlWrite(sql);
    }

    protected void deleteTable(String tableName) throws M4CompilerError {
        try {
            this.db.dropBusinessTable(tableName);
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError(m4e.getMessage());
        }
    }

    protected void commit() throws DbConnectionClosed, SQLException {
        this.db.commitBusinessTransactions();
    }

    private void createInputTable() throws M4CompilerError {
        this.inputTableName = this.inputTableName + SUFFIX_FOR_MATERIALIZED_INPUT;
        this.materializedInput = true;
        try {
            String inputSelect = this.sourceCs.getCompleteSQLQuery();
            if (inputSelect.toUpperCase().indexOf(" FROM (SELECT") > -1) {
                inputSelect = inputSelect + " AS ZZZ";
            }
            String sql = "CREATE TABLE " + this.inputTableName + " AS " + inputSelect;
            this.db.executeBusinessSqlWrite(sql);
        }
        catch (SQLException sqle) {
            throw new M4CompilerError("Sampling: could not materialize input view for Postgres: " + sqle.getMessage());
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Sampling: could not materialize input view for Postgres: " + m4e.getMessage());
        }
    }

    private String[] findPrimaryKeyAttribute() throws M4CompilerError {
        if (this.usingOracle) {
            String[] keyAttribute = new String[]{this.db.getUniqueRowIdentifier(true), this.db.getDbNameOfM4Datatype("NUMBER", 0, true)};
            return keyAttribute;
        }
        try {
            PrimaryKey pk = this.sourceCs.getPrimaryKey();
            if (pk != null) {
                Collection pkCols = pk.getAllColumns();
                Iterator it = pkCols.iterator();
                Column primKeyColumn = null;
                if (it.hasNext()) {
                    primKeyColumn = (Column)it.next();
                }
                if (primKeyColumn != null) {
                    String[] keyAttribute = new String[]{primKeyColumn.getName(), primKeyColumn.getColumnDataTypeName()};
                    return keyAttribute;
                }
            }
        }
        catch (M4Exception m4e) {
            throw new M4CompilerError("Sampling: M4 exception when determining primary key for Columnset '" + this.sourceCs.getName() + "': " + m4e.getMessage());
        }
        if (this.usingMysql) {
            throw new M4CompilerError("Cannot use Sampling under Mysql because no primary key is defined in the input!");
        }
        if (this.sourceCs.getType().equals("V") && this.usingPostgres) {
            this.createInputTable();
        } else {
            this.materializedInput = false;
        }
        String[] keyAttribute = new String[]{this.rowIdentifierName, this.numericDatatypeName};
        return keyAttribute;
    }
}

