/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.miningmart.compiler.utils;

import edu.udo.cs.miningmart.compiler.utils.AttributeCreationTool;
import edu.udo.cs.miningmart.db.DB;
import edu.udo.cs.miningmart.exception.M4Exception;
import edu.udo.cs.miningmart.m4.BaseAttribute;
import edu.udo.cs.miningmart.m4.Chain;
import edu.udo.cs.miningmart.m4.Concept;
import edu.udo.cs.miningmart.m4.core.Column;
import edu.udo.cs.miningmart.m4.utils.Print;
import java.util.Collection;

public class PivotizeWithoutAggregation
extends AttributeCreationTool {
    private final int GENERIC_FEAT_CONSTR_ID = 90;
    private Column myPivotColumn;
    private edu.udo.cs.miningmart.m4.core.BaseAttribute myPivotBA;

    public PivotizeWithoutAggregation(Concept inputConcept, BaseAttribute indexBA, BaseAttribute pivotBA, Chain chain) throws M4Exception {
        super(inputConcept, indexBA, chain);
        String msgIntro = "Constructor of " + this.getClass().getName() + ":\n";
        if (pivotBA == null) {
            throw new M4Exception(msgIntro + "The given Pivot BaseAttribute is NULL!");
        }
        if (!inputConcept.equals(pivotBA.getConcept())) {
            throw new M4Exception(msgIntro + "The specified BaseAttribute to be pivotized does not belong to the InputConcept!");
        }
        this.myPivotBA = (edu.udo.cs.miningmart.m4.core.BaseAttribute)pivotBA;
        Collection pivotColCollection = this.myPivotBA.getColumns();
        if (pivotColCollection.size() != 1) {
            boolean exception = true;
            if (pivotColCollection.size() > 1) {
                for (Column col : pivotColCollection) {
                    if (col == null || !this.myInputColumnset.equals(col.getColumnset())) continue;
                    this.myDB.getCasePrintObject().doPrint(Print.MAX, msgIntro + "WARNING: found multiple Columns in Pivot BaseAttribute, choosing the one linked to the found Columnset!");
                    pivotColCollection.clear();
                    pivotColCollection.add(col);
                    exception = false;
                    break;
                }
            }
            if (exception) {
                throw new M4Exception(msgIntro + "Found no (suitable) Column for Pivot BaseAttribute!");
            }
        }
        this.myPivotColumn = (Column)pivotColCollection.iterator().next();
        if (this.myPivotColumn == null) {
            throw new M4Exception(msgIntro + "Pivot BaseAttribute has a null entry instead of the column!");
        }
    }

    protected void insertSpecificParameters(int loopNr, int parNr, String targetValS) throws M4Exception {
        int stringConDT = 1;
        boolean indexBaNominal = this.myIndexBA.getConceptualDataType() == 1L || this.myIndexBA.getConceptualDataType() == 2L;
        String theSQL = "(CASE WHEN " + this.myIndexBA.getName() + " = " + (indexBaNominal ? DB.quote(targetValS) : targetValS) + " THEN " + this.myPivotBA.getName() + " ELSE NULL END)";
        this.createInputValueParameter("SQL_String", loopNr, theSQL, stringConDT, parNr++);
    }

    protected int getIdOfOperator() {
        return 90;
    }

    protected String getNameOfOperator() {
        return "GenericFeatureConstruction";
    }

    protected String getNameOfNewStep() {
        return "Pivotize Attribute w/o Aggr.";
    }

    protected String getConceptualDatatypeNameOfNewAttributes() throws M4Exception {
        return this.myIndexBA.getConceptualDataTypeName();
    }
}

