/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.tools.math.Averagable;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JLabel;

public abstract class AverageVector
extends ResultObjectAdapter
implements Comparable {
    private ArrayList averagesList = new ArrayList();

    protected abstract Object clone();

    public int size() {
        return this.averagesList.size();
    }

    public void addAveragable(Averagable avg) {
        this.averagesList.add(avg);
    }

    public void removeAveragable(Averagable avg) {
        this.averagesList.remove(avg);
    }

    public Averagable getAveragable(int index) {
        return (Averagable)this.averagesList.get(index);
    }

    public Averagable getAveragable(String name) {
        Iterator i = this.averagesList.iterator();
        while (i.hasNext()) {
            Averagable a = (Averagable)i.next();
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public String toResultString() {
        String result = this.getName() + ":\n";
        ListIterator i = this.averagesList.listIterator();
        while (i.hasNext()) {
            result = result + ((Averagable)i.next()).toResultString() + "\n";
        }
        return result;
    }

    public String toString() {
        String result = "AverageVector [";
        for (int i = 0; i < this.size(); ++i) {
            Averagable avg = this.getAveragable(i);
            if (i > 0) {
                result = result + ", ";
            }
            result = result + avg;
        }
        return result + "]";
    }

    public String toHTML() {
        String result = "<h1>" + this.getName() + "</h1><ol>";
        ListIterator i = this.averagesList.listIterator();
        while (i.hasNext()) {
            result = result + "<li>" + ((Averagable)i.next()).toHTML() + "</li>";
        }
        result = result + "</ol>";
        return result;
    }

    public Component getVisualisationComponent() {
        JLabel label = new JLabel("<html>" + this.toHTML() + "</html>");
        label.setFont(label.getFont().deriveFont(0));
        return label;
    }

    public void buildAverages(AverageVector av) {
        if (this.size() != av.size()) {
            throw new IllegalArgumentException("Performance vectors have different size!");
        }
        for (int i = 0; i < this.size(); ++i) {
            this.getAveragable(i).buildAverage(av.getAveragable(i));
        }
    }
}

