/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.WekaInstancesAdaptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.gui.beans.KnowledgeFlowApp;

public class WekaTools {
    public static ExampleSet toYaleExampleSet(Instances instances) {
        return WekaTools.toYaleExampleSet(instances, null, 0);
    }

    public static ExampleSet toYaleExampleSet(Instances instances, String attributeNamePrefix) {
        return WekaTools.toYaleExampleSet(instances, attributeNamePrefix, 0);
    }

    public static ExampleSet toYaleExampleSet(Instances instances, String attributeNamePrefix, int datamanagement) {
        int classIndex = instances.classIndex();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        int number = 1;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            weka.core.Attribute wekaAttribute = instances.attribute(i);
            Attribute attribute = AttributeFactory.createAttribute(wekaAttribute.name(), wekaAttribute.isNominal() ? 1 : 4);
            if (i != classIndex && attributeNamePrefix != null && attributeNamePrefix.length() > 0) {
                attribute.setName(attributeNamePrefix + "_" + number++);
            }
            attributes.add(attribute);
        }
        Attribute label = null;
        if (classIndex >= 0) {
            label = (Attribute)attributes.get(classIndex);
            label.setName("label");
        }
        for (int i = 0; i < instances.numInstances(); ++i) {
            boolean incompleteAttributeExists = false;
            Instance instance = instances.instance(i);
            for (int j = 0; j < attributes.size(); ++j) {
                Attribute attribute = (Attribute)attributes.get(j);
                if (!attribute.isNominal()) continue;
                double wekaValue = instance.value(j);
                String nominalValue = instances.attribute(j).value((int)wekaValue);
                attribute.mapString(nominalValue);
                if (attribute.getNumberOfValues() >= instances.attribute(j).numValues()) continue;
                incompleteAttributeExists = true;
            }
            if (!incompleteAttributeExists) break;
        }
        for (int j = 0; j < attributes.size(); ++j) {
            Attribute attribute = (Attribute)attributes.get(j);
            if (!attribute.isNominal()) continue;
            attribute.sortNominalMappings();
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        DataRowFactory factory = new DataRowFactory(datamanagement);
        LinkedList<DataRow> dataList = new LinkedList<DataRow>();
        int numberOfYaleAttributes = instances.numAttributes();
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            DataRow dataRow = factory.create(numberOfYaleAttributes);
            for (int a = 0; a < instances.numAttributes(); ++a) {
                Attribute attribute = table.getAttribute(a);
                double wekaValue = instance.value(a);
                if (attribute.isNominal()) {
                    String nominalValue = instances.attribute(a).value((int)wekaValue);
                    dataRow.set(attribute, attribute.mapString(nominalValue));
                    continue;
                }
                dataRow.set(attribute, wekaValue);
            }
            dataList.add(dataRow);
        }
        table.readExamples(new ListDataRowReader(dataList.iterator()));
        return table.createCompleteExampleSet(label, null, null, null);
    }

    public static Instances toWekaInstances(ExampleSet exampleSet, String name, Attribute label, boolean labelKnown) {
        return WekaTools.toWekaInstances(exampleSet, name, label, labelKnown, false);
    }

    public static Instances toWekaInstances(ExampleSet exampleSet, String name, Attribute label, boolean labelKnown, boolean associationLearning) {
        return new WekaInstancesAdaptor(name, exampleSet, labelKnown, associationLearning);
    }

    public static String[] getWekaParametersFromList(List yaleParameters) {
        String[] parameters = new String[yaleParameters.size() * 2];
        Iterator i = yaleParameters.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object[] parameter = (Object[])i.next();
            parameters[j++] = "-" + (String)parameter[0];
            parameters[j++] = (String)parameter[1];
        }
        return parameters;
    }

    public static String[] getWekaParametersFromTypes(Operator operator, List parameterTypes) {
        LinkedList<String> parameterStrings = new LinkedList<String>();
        Iterator i = parameterTypes.iterator();
        while (i.hasNext()) {
            ParameterType type = (ParameterType)i.next();
            try {
                String defaultValue;
                if (type instanceof ParameterTypeBoolean) {
                    if (new Boolean(operator.getParameterAsBoolean(type.getKey())).equals(type.getDefaultValue())) continue;
                    parameterStrings.add("-" + type.getKey());
                    continue;
                }
                String value = operator.getParameterAsString(type.getKey());
                if (value == null || (defaultValue = (String)type.getDefaultValue()) != null && defaultValue.equals(value)) continue;
                parameterStrings.add("-" + type.getKey());
                parameterStrings.add(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot use parameter " + type.getKey() + ": " + e.getMessage());
            }
        }
        String[] result = new String[parameterStrings.size()];
        parameterStrings.toArray(result);
        return result;
    }

    public static ParameterType guessParameterType(Option option, String[] options) {
        if (option.numArguments() == 0) {
            return new ParameterTypeBoolean(option.name(), option.description(), WekaTools.getBooleanDefault(option.name(), options));
        }
        String defaultString = WekaTools.getStringDefault(option.name(), options);
        if (defaultString == null) {
            return new ParameterTypeString(option.name(), option.description());
        }
        return new ParameterTypeString(option.name(), option.description(), defaultString);
    }

    private static boolean getBooleanDefault(String key, String[] options) {
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("-" + key)) continue;
            return true;
        }
        return false;
    }

    private static String getStringDefault(String key, String[] options) {
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("-" + key) || i + 1 >= options.length) continue;
            return options[i + 1];
        }
        return null;
    }

    private static String[] removeMetaOptions(String[] options) {
        int index = -1;
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].trim().equals("--")) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return options;
        }
        String[] result = new String[index];
        System.arraycopy(options, 0, result, 0, index);
        return result;
    }

    public static void addParameterTypes(OptionHandler handler, List types, List wekaParameters) {
        Option option;
        String[] defaultOptions = WekaTools.removeMetaOptions(handler.getOptions());
        Enumeration options = handler.listOptions();
        while (options.hasMoreElements() && (option = (Option)options.nextElement()).name().trim().length() != 0) {
            if (option.name().trim().toLowerCase().equals("w")) continue;
            ParameterType type = WekaTools.guessParameterType(option, defaultOptions);
            types.add(type);
            wekaParameters.add(type);
        }
    }

    public static JarFile getWekaJar() throws IOException {
        String wekaJar = System.getProperty("yale.weka.jar");
        if (wekaJar != null) {
            return new JarFile(new File(wekaJar));
        }
        return new JarFile(ParameterService.getLibraryFile("weka.jar"));
    }

    public static String[] getWekaClasses(Class superclass) {
        return WekaTools.getWekaClasses(superclass, null, true);
    }

    public static String[] getWekaClasses(Class superclass, String packageName, boolean includePackage) {
        JarFile jar = null;
        try {
            jar = WekaTools.getWekaJar();
        }
        catch (IOException e) {
            return new String[0];
        }
        LinkedList classes = new LinkedList();
        Tools.findImplementationsInJar(jar, superclass, classes);
        if (packageName != null) {
            Iterator i = classes.iterator();
            while (i.hasNext()) {
                if (includePackage && ((String)i.next()).indexOf(packageName) == -1) {
                    i.remove();
                }
                if (includePackage || ((String)i.next()).indexOf(packageName) == -1) continue;
                i.remove();
            }
        }
        String[] names = new String[classes.size()];
        classes.toArray(names);
        return names;
    }

    public static void registerWekaOperators(ClassLoader classLoader, String[] classNames, String operatorClass, String firstDescription, String firstGroup, String icon) {
        for (int i = 0; i < classNames.length; ++i) {
            String infoString = null;
            try {
                Class<?> clazz = Class.forName(classNames[i], true, classLoader);
                Object wekaObject = clazz.newInstance();
                infoString = KnowledgeFlowApp.getGlobalInfo(wekaObject);
                boolean generalIndex = false;
                int index = -1;
                infoString = WekaTools.htmlEscape(infoString, "&", "and");
                infoString = WekaTools.htmlEscape(infoString, "<i>", "");
                infoString = WekaTools.htmlEscape(infoString, "</i>", "");
                infoString = WekaTools.htmlEscape(infoString, "<b>", "");
                infoString = WekaTools.htmlEscape(infoString, "</b>", "");
                infoString = WekaTools.htmlEscape(infoString, "<tt>", "");
                infoString = WekaTools.htmlEscape(infoString, "</tt>", "");
                if (infoString.indexOf("^") >= 0) {
                    infoString = infoString.substring(0, infoString.indexOf(".") + 1).trim();
                }
                if (infoString.indexOf("^") >= 0) {
                    infoString = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            int lastIndex = classNames[i].lastIndexOf(".");
            String name = classNames[i].substring(lastIndex + 1);
            String packageName = classNames[i].substring(0, lastIndex);
            String group = packageName.substring(packageName.lastIndexOf(".") + 1);
            String groupStart = group.substring(0, 1);
            String groupEnd = group.substring(1);
            group = groupStart.toUpperCase() + groupEnd.toLowerCase();
            try {
                OperatorDescription description = new OperatorDescription(classLoader, name, operatorClass, infoString != null ? infoString : firstDescription.trim() + " " + name, firstGroup.endsWith(".") ? firstGroup + group : firstGroup, icon);
                description.createOperatorInstance();
                OperatorService.registerOperator(description);
                continue;
            }
            catch (OperatorCreationException e) {
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private static String htmlEscape(String toEscape, String what, String by) {
        String result = toEscape;
        int index = 0;
        int generalIndex = 0;
        while ((index = result.indexOf(what, generalIndex)) >= 0) {
            String first = result.substring(0, index);
            String last = result.substring(index + what.length());
            result = first + by + last;
            generalIndex = index + by.length();
        }
        return result;
    }
}

