/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.IOException;

public class TempFileService {
    public static final String[] DELETE_TEMP_FILES = new String[]{"no", "directly", "on_exit"};
    public static final int NO = 0;
    public static final int DIRECTLY = 1;
    public static final int ON_EXIT = 2;
    private static int deleteTempFiles;
    private static final String TMP_PREFIX = "_yale_";
    private static File tmpDir;
    private static String tmpDirString;

    public static void init(Experiment experiment) throws OperatorException {
        deleteTempFiles = experiment.getRootOperator().getParameterAsInt("delete_temp_files");
        String tempDirName = experiment.getRootOperator().getParameterAsString("temp_dir");
        LogService.logMessage("TempFileService: delete_temp_files = " + DELETE_TEMP_FILES[deleteTempFiles], 0);
        if (tempDirName == null) {
            File experimentFile = experiment.getExperimentFile();
            tempDirName = experimentFile == null ? "unnamed.tmp" : experimentFile.getName() + ".tmp";
        }
        if (!(tmpDir = experiment.resolveFileName(tempDirName)).exists()) {
            LogService.logMessage("Creating temp directory " + tmpDir, 3);
            if (!Tools.mkdir(tmpDir.getAbsoluteFile())) {
                throw new UserError(null, 311, tmpDir);
            }
            if (deleteTempFiles > 0) {
                tmpDir.deleteOnExit();
            }
        }
    }

    public static File createTempFile() {
        try {
            File file = File.createTempFile(TMP_PREFIX, null, tmpDir);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString() + ": Cannot create temp file.");
        }
    }

    public static File createTempFile(String name) {
        return TempFileService.createTempFile(name, (String)null);
    }

    public static File createTempFile(String name, String extension) {
        try {
            File file = File.createTempFile(TMP_PREFIX + name, extension, tmpDir);
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString() + ": Cannot create temp file.");
        }
    }

    public static File createTempFile(File oldfile) {
        return TempFileService.createTempFile("", oldfile);
    }

    public static File createTempFile(String name, File oldfile) {
        try {
            File newfile = File.createTempFile(TMP_PREFIX + name, null, tmpDir);
            if (!oldfile.exists()) {
                throw new RuntimeException("TempFileService: Cannot rename file '" + oldfile.getPath() + ". File does not exist.");
            }
            if (newfile.exists()) {
                newfile.delete();
            }
            if (!oldfile.renameTo(newfile)) {
                throw new RuntimeException("TempFileService: Cannot rename '" + oldfile.getPath() + "' to '" + newfile.getPath() + "'! Original file exists, " + "but cannot be renamed.");
            }
            LogService.logMessage("TempFileService: Renamed file '" + oldfile.getPath() + "' to '" + newfile.getPath() + "'.", 0);
            if (deleteTempFiles > 0) {
                newfile.deleteOnExit();
            }
            return newfile;
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString() + ": Cannot create temp file.");
        }
    }

    public static String createTempFiles(String name, String[] extensions, File[] files) {
        try {
            File tempFile = File.createTempFile(TMP_PREFIX + name, "", tmpDir);
            for (int i = 0; i < files.length; ++i) {
                files[i] = new File(tempFile.getAbsolutePath() + extensions[i]);
                if (deleteTempFiles <= 0) continue;
                files[i].deleteOnExit();
            }
            return tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString() + ": Cannot create temp file.");
        }
    }

    public static void deleteTempFile(File file) {
        switch (deleteTempFiles) {
            case 1: {
                if (file.exists()) {
                    LogService.logMessage("Deleting temporary file '" + file.getName() + "' (" + file.length() + " bytes)", 0);
                    file.delete();
                }
                return;
            }
            case 2: {
                file.deleteOnExit();
                return;
            }
        }
    }

    public static File getTempDir() {
        return tmpDir;
    }
}

