/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.operator.OperatorDescription;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class GroupTree {
    private Set operators = new TreeSet();
    private Map children = new TreeMap();
    private String name = null;
    private GroupTree parent = null;

    public GroupTree(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setParent(GroupTree parent) {
        this.parent = parent;
    }

    public GroupTree getParent() {
        return this.parent;
    }

    public void addSubGroup(GroupTree child) {
        this.children.put(child.getName(), child);
        child.setParent(this);
    }

    public GroupTree getSubGroup(String name) {
        return (GroupTree)this.children.get(name);
    }

    public Collection getSubGroups() {
        return this.children.values();
    }

    public void addOperatorDescription(OperatorDescription description) {
        this.operators.add(description);
    }

    public Set getOperatorDescriptions() {
        return this.operators;
    }

    public Set getAllOperatorDescriptions() {
        TreeSet result = new TreeSet();
        this.addAllOperatorDescriptions(result);
        return result;
    }

    private void addAllOperatorDescriptions(Set operators) {
        operators.addAll(this.operators);
        Iterator i = this.children.values().iterator();
        while (i.hasNext()) {
            GroupTree child = (GroupTree)i.next();
            child.addAllOperatorDescriptions(operators);
        }
    }

    public String toString() {
        String result = "(" + this.name + "# " + this.operators.size();
        result = result + this.getSubGroups().toString();
        result = result + ")";
        return result;
    }
}

