/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.Tools;
import edu.udo.cs.yale.operator.validation.ValidationChain;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.LinkedList;
import java.util.List;

public class RandomSplitValidationChain
extends ValidationChain {
    public RandomSplitValidationChain(OperatorDescription description) {
        super(description);
    }

    public IOObject[] estimatePerformance(ExampleSet inputSet) throws OperatorException {
        double splitRatio = this.getParameterAsDouble("split_ratio");
        SplittedExampleSet eSet = new SplittedExampleSet(inputSet, splitRatio, this.getParameterAsInt("sampling_type"));
        eSet.selectSingleSubset(0);
        this.learn(eSet);
        eSet.selectSingleSubset(1);
        IOContainer evalRes = this.evaluate(eSet);
        LinkedList averageVectors = new LinkedList();
        Tools.handleAverages(evalRes, averageVectors);
        PerformanceVector performanceVector = this.getPerformanceVector(averageVectors);
        if (performanceVector != null) {
            this.setResult(performanceVector.getMainCriterion());
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    public int getNumberOfValidationSteps() {
        return 1;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("split_ratio", "Relative size of the training set.", 0.0, 1.0, 0.7);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("sampling_type", "Defines the sampling type of this simple validation.", SplittedExampleSet.SAMPLING_NAMES, 1));
        return types;
    }
}

