/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

public class LearningCurveOperator
extends OperatorChain {
    private double lastFraction = Double.NaN;
    private double lastPerformance = Double.NaN;
    private double lastDeviation = Double.NaN;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public LearningCurveOperator(OperatorDescription description) {
        super(description);
        this.addValue(new Value("fraction", "The used fraction of data.."){

            public double getValue() {
                return LearningCurveOperator.this.lastFraction;
            }
        });
        this.addValue(new Value("performance", "The last performance (main criterion)."){

            public double getValue() {
                return LearningCurveOperator.this.lastPerformance;
            }
        });
        this.addValue(new Value("deviation", "The variance of the last performance (main criterion)."){

            public double getValue() {
                return LearningCurveOperator.this.lastDeviation;
            }
        });
    }

    public IOObject[] apply() throws OperatorException {
        double stepFraction;
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = LearningCurveOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        this.lastFraction = stepFraction = this.getParameterAsDouble("step_fraction");
        while (this.lastFraction <= 1.0) {
            SplittedExampleSet splitted = new SplittedExampleSet(exampleSet, this.lastFraction);
            splitted.selectSingleSubset(0);
            IOContainer result = this.getOperator(0).apply(new IOContainer(new IOObject[]{splitted}));
            PerformanceVector performance = (PerformanceVector)result.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? LearningCurveOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector") : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
            this.lastPerformance = performance.getMainCriterion().getValue();
            this.lastDeviation = performance.getMainCriterion().getStandardDeviation();
            this.lastFraction += stepFraction;
        }
        return new IOObject[0];
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = LearningCurveOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[0];
    }

    public int getNumberOfSteps() {
        return (int)(1.0 / this.getParameterAsDouble("step_fraction")) * this.getNumberOfChildrensSteps();
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).checkIO(input);
        }
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = LearningCurveOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, input)) {
            throw new IllegalInputException(this, this.getOperator(0), class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = LearningCurveOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
        }
        return this.getDeliveredOutputClasses();
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("step_fraction", "The fraction of examples which would be additionally used in each step.", 0.0, 1.0, 0.05);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

