/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import java.util.Iterator;
import java.util.List;

public class RenameAttributeOperator
extends Operator {
    private static final String REGULAR_NAME = "regular";
    private static final String[] TARGET_TYPES = new String[]{"regular", "id", "label", "prediction", "cluster", "weight", "batch"};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public RenameAttributeOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        String oldName;
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = RenameAttributeOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        Attribute attribute = exampleSet.getAttribute(oldName = this.getParameterAsString("old_name"));
        if (attribute == null) {
            Iterator i = exampleSet.getSpecialAttributes().keySet().iterator();
            while (i.hasNext()) {
                Attribute current = exampleSet.getAttribute((String)i.next());
                if (!current.getName().equals(oldName)) continue;
                attribute = current;
                break;
            }
            if (attribute == null) {
                throw new UserError((Operator)this, 111, oldName);
            }
        }
        String newName = this.getParameterAsString("new_name");
        attribute.setName(newName);
        if (this.getParameterAsBoolean("change_attribute_type")) {
            exampleSet.removeAttribute(attribute);
            String newType = this.getParameterAsString("target_type");
            if (newType == null || newType.trim().length() == 0) {
                throw new UserError((Operator)this, 201, new Object[]{"target_type", "change_attribute_type", "true"});
            }
            if (newType.equals(REGULAR_NAME)) {
                exampleSet.addAttribute(attribute);
            } else {
                exampleSet.setSpecialAttribute(newType, attribute);
            }
        }
        return new IOObject[]{exampleSet};
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = RenameAttributeOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = RenameAttributeOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString("old_name", "The old name of the attribute.", false));
        types.add(new ParameterTypeString("new_name", "The new name of the attribute.", false));
        types.add(new ParameterTypeBoolean("change_attribute_type", "Indicates if the attribute type should be changed.", false));
        types.add(new ParameterTypeStringCategory("target_type", "The target type of the attribute (only changed if parameter change_attribute_type is true).", TARGET_TYPES, TARGET_TYPES[0]));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

