/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.preprocessing.ValueReplenishment;

public class MissingValueReplenishment
extends ValueReplenishment {
    private static final int NONE = 0;
    private static final int MINIMUM = 1;
    private static final int MAXIMUM = 2;
    private static final int AVERAGE = 3;
    private static final String[] REP_NAMES = new String[]{"none", "minimum", "maximum", "average"};

    public MissingValueReplenishment(OperatorDescription description) {
        super(description);
    }

    public String[] getFunctionNames() {
        return REP_NAMES;
    }

    public int getDefaultFunction() {
        return 0;
    }

    public int getDefaultColumnFunction() {
        return 3;
    }

    public boolean replenishValue(double currentValue) {
        return Double.isNaN(currentValue);
    }

    public double getReplenishmentValue(int functionIndex, Attribute attribute, double currentValue) {
        switch (functionIndex) {
            case 0: {
                return currentValue;
            }
            case 1: {
                return attribute.getMinimum();
            }
            case 2: {
                return attribute.getMaximum();
            }
            case 3: {
                return attribute.getAverage();
            }
        }
        throw new RuntimeException("Illegal value functionIndex: " + functionIndex);
    }
}

