/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.tools.math.Averagable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class RootRelativeSquaredError
extends MeasuredPerformance {
    private double deviationSum = 0.0;
    private double relativeSum = 0.0;
    private double trueLabelSum = 0.0;
    private int exampleCounter = 0;

    public void writeCriterionData(PrintWriter out) throws IOException {
        out.println("deviation_sum: " + this.deviationSum);
        out.println("relative_sum: " + this.relativeSum);
        out.println("true_label_sum: " + this.trueLabelSum);
        out.println("example_count: " + this.exampleCounter);
    }

    public void readCriterionData(BufferedReader in) throws IOException {
        String line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.deviationSum = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.relativeSum = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.trueLabelSum = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.exampleCounter = Integer.parseInt(line);
    }

    public String getName() {
        return "root_relative_squared_error";
    }

    public String getDescription() {
        return "Averaged root-relative-squared error";
    }

    public int getExampleCount() {
        return this.exampleCounter;
    }

    public void startCounting(ExampleSet exampleSet) throws OperatorException {
        if (exampleSet.getSize() <= 1) {
            throw new UserError(null, 919, this.getName(), (Object)"relative errors can only be calculated for test sets with more than 2 examples.");
        }
        this.trueLabelSum = 0.0;
        this.deviationSum = 0.0;
        this.relativeSum = 0.0;
        this.exampleCounter = 0;
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            double label = example.getLabel();
            if (Double.isNaN(label)) continue;
            ++this.exampleCounter;
            this.trueLabelSum += label;
        }
    }

    public void countExample(Example example) {
        double label = example.getLabel();
        double diff = Math.abs(label - example.getPredictedLabel());
        this.deviationSum += diff * diff;
        double relDiff = Math.abs(label - this.trueLabelSum / (double)this.exampleCounter);
        this.relativeSum += relDiff * relDiff;
    }

    public double getValue() {
        return Math.sqrt(this.deviationSum / this.relativeSum);
    }

    public double getVariance() {
        return Double.NaN;
    }

    public double getFitness() {
        return 1.0 / this.getValue();
    }

    protected void cloneAveragable(Averagable newPC) {
        RootRelativeSquaredError newRelative = (RootRelativeSquaredError)newPC;
        this.deviationSum = newRelative.deviationSum;
        this.relativeSum = newRelative.relativeSum;
        this.trueLabelSum = newRelative.trueLabelSum;
        this.exampleCounter = newRelative.exampleCounter;
    }

    public void buildSingleAverage(Averagable performance) {
        RootRelativeSquaredError other = (RootRelativeSquaredError)performance;
        this.deviationSum += other.deviationSum;
        this.relativeSum += other.relativeSum;
    }
}

