/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.operator.performance.PerformanceComparator;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.math.Averagable;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class PerformanceVector
extends AverageVector {
    private PerformanceComparator comparator = new DefaultComparator(0.0);
    private String mainCriterion = null;

    public void setComparator(PerformanceComparator comparator) {
        this.comparator = comparator;
    }

    public void addCriterion(PerformanceCriterion crit) {
        this.addAveragable(crit);
    }

    public PerformanceCriterion getCriterion(int index) {
        return (PerformanceCriterion)this.getAveragable(index);
    }

    public PerformanceCriterion getCriterion(String name) {
        return (PerformanceCriterion)this.getAveragable(name);
    }

    public void setMainCriterionName(String mcName) {
        if (this.getAveragable(mcName) == null) {
            LogService.logMessage("Main criterion not found: '" + mcName + "'.", 6);
        }
        this.mainCriterion = mcName;
    }

    public PerformanceCriterion getMainCriterion() {
        if (this.mainCriterion == null) {
            return (PerformanceCriterion)this.getAveragable(0);
        }
        PerformanceCriterion pc = (PerformanceCriterion)this.getAveragable(this.mainCriterion);
        if (pc == null) {
            return (PerformanceCriterion)this.getAveragable(0);
        }
        return pc;
    }

    public int compareTo(Object o) {
        double result = this.comparator.compare(this, (PerformanceVector)o);
        if (result < 0.0) {
            return -1;
        }
        if (result > 0.0) {
            return 1;
        }
        return 0;
    }

    protected Object clone() {
        PerformanceVector av = new PerformanceVector();
        for (int i = 0; i < this.size(); ++i) {
            Averagable avg = this.getAveragable(i);
            av.addAveragable((Averagable)avg.clone());
        }
        return av;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("PerformanceVector [");
        for (int i = 0; i < this.size(); ++i) {
            boolean isMainCriterion;
            Averagable avg = this.getAveragable(i);
            boolean bl = isMainCriterion = this.mainCriterion != null && avg.getName().equals(this.mainCriterion);
            if (this.mainCriterion != null && avg.getName().equals(this.mainCriterion)) {
                result.append("\n*****");
            } else {
                result.append("\n-----");
            }
            result.append(avg);
        }
        result.append("\n]");
        return result.toString();
    }

    public String toHTML() {
        StringBuffer result = new StringBuffer("<h1>" + this.getName() + "</h1>");
        result.append("<h3>main criterion: " + this.getMainCriterion().getName() + "</h3><ol>");
        for (int i = 0; i < this.size(); ++i) {
            Averagable avg = this.getAveragable(i);
            result.append("<li>" + avg.toHTML() + "</li>");
        }
        result.append("</ol>");
        return result.toString();
    }

    public void writePerformanceVector(File outFile) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(outFile));
        this.writePerformanceVector(out);
        out.close();
    }

    public void writePerformanceVector(PrintWriter out) throws IOException {
        out.println("number of criteria: " + this.size());
        for (int i = 0; i < this.size(); ++i) {
            PerformanceCriterion pc = this.getCriterion(i);
            if (this.mainCriterion != null && pc.getName().equals(this.mainCriterion)) {
                out.print("*** ");
            } else {
                out.print("--- ");
            }
            out.println(pc.getName() + ":\t" + pc.getValue());
            pc.writePerformanceCriterion(out);
        }
    }

    public static PerformanceVector readPerformanceVector(File inFile) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        PerformanceVector pv = PerformanceVector.readPerformanceVector(in);
        in.close();
        return pv;
    }

    public static PerformanceVector readPerformanceVector(BufferedReader in) throws IOException {
        PerformanceVector pv = new PerformanceVector();
        String line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        int numberOfCriteria = Integer.parseInt(line);
        for (int i = 0; i < numberOfCriteria; ++i) {
            in.readLine();
            PerformanceCriterion pc = PerformanceCriterion.readPerformanceCriterion(in);
            pv.addCriterion(pc);
        }
        return pv;
    }

    public static class DefaultComparator
    implements PerformanceComparator {
        private double mdlWeight = 0.0;

        public DefaultComparator(double mdlWeight) {
            this.mdlWeight = mdlWeight;
        }

        public int compare(PerformanceVector av1, PerformanceVector av2) {
            if (av1.getCriterion("mdl") != null) {
                int mainResult = av1.getMainCriterion().compareTo(av2.getMainCriterion());
                double fitness1 = av1.getMainCriterion().getFitness();
                double fitness2 = av2.getMainCriterion().getFitness();
                double mdl1 = av1.getCriterion("mdl").getValue();
                double mdl2 = av2.getCriterion("mdl").getValue();
                double result1 = fitness1 / Math.max(fitness1, fitness2) - this.mdlWeight * (mdl1 / Math.max(mdl1, mdl2));
                double result2 = fitness2 / Math.max(fitness1, fitness2) - this.mdlWeight * (mdl2 / Math.max(mdl1, mdl2));
                return Double.compare(result1, result2);
            }
            return av1.getMainCriterion().compareTo(av2.getMainCriterion());
        }
    }
}

