/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.operator.performance.MeasuredPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.tools.math.Averagable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class MinMaxCriterion
extends MeasuredPerformance {
    private MeasuredPerformance delegate;
    private double fitness = Double.POSITIVE_INFINITY;
    private double fitnessSum = 0.0;
    private double value = Double.NaN;
    private double weight = 1.0;
    private int counter = 0;

    public MinMaxCriterion() {
    }

    public MinMaxCriterion(MeasuredPerformance delegate, double weight) {
        this.delegate = delegate;
        this.weight = weight;
        if (!Double.isNaN(delegate.getFitness())) {
            this.fitness = delegate.getFitness();
            this.value = delegate.getValue();
            ++this.counter;
        }
    }

    public void writeCriterionData(PrintWriter out) throws IOException {
        this.delegate.writePerformanceCriterion(out);
        out.println("fitness: " + this.fitness);
        out.println("fitness_sum: " + this.fitnessSum);
        out.println("value: " + this.value);
        out.println("weight: " + this.weight);
        out.println("counter: " + this.counter);
    }

    public void readCriterionData(BufferedReader in) throws IOException {
        this.delegate = (MeasuredPerformance)PerformanceCriterion.readPerformanceCriterion(in);
        String line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.fitness = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.fitnessSum = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.value = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.weight = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.counter = Integer.parseInt(line);
    }

    public int getExampleCount() {
        return this.delegate.getExampleCount();
    }

    public void countExample(Example example) {
        this.delegate.countExample(example);
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public double getValue() {
        return this.weight * this.value + (1.0 - this.weight) * this.delegate.getValue();
    }

    public double getFitness() {
        return this.weight * this.fitness + (1.0 - this.weight) * (this.fitnessSum / (double)this.counter);
    }

    public double getVariance() {
        return Double.NaN;
    }

    public void cloneAveragable(Averagable avg) {
        MinMaxCriterion mmc = (MinMaxCriterion)avg;
        this.delegate = mmc.delegate;
        this.fitness = mmc.fitness;
        this.fitnessSum = mmc.fitnessSum;
        this.counter = mmc.counter;
        this.weight = mmc.weight;
    }

    public void buildSingleAverage(Averagable avg) {
        MinMaxCriterion mmc = (MinMaxCriterion)avg;
        double currentFitness = mmc.delegate.getFitness();
        if (currentFitness < this.fitness) {
            this.fitness = currentFitness;
            this.value = mmc.delegate.getValue();
        }
        this.fitnessSum += currentFitness;
        ++this.counter;
        this.delegate.buildAverage(mmc.delegate);
    }
}

