/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.performance;

import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.tools.math.Averagable;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;

public class EstimatedPerformance
extends PerformanceCriterion {
    private String name;
    private double value;
    private int exampleCount = 1;
    private boolean reciprocalFitness;

    public EstimatedPerformance() {
    }

    public EstimatedPerformance(String name, double value, int numberOfExamples, boolean reciprocalFitness) {
        this.name = name;
        this.setValue(value, numberOfExamples);
        this.reciprocalFitness = reciprocalFitness;
    }

    public void writeCriterionData(PrintWriter out) throws IOException {
        out.println("name: " + this.name);
        out.println("value: " + this.value);
        out.println("example_count: " + this.exampleCount);
        out.println("reciprocal_fitness: " + this.reciprocalFitness);
    }

    public void readCriterionData(BufferedReader in) throws IOException {
        String line = in.readLine();
        this.name = line = line.substring(line.indexOf(":") + 1).trim();
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.value = Double.parseDouble(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.exampleCount = Integer.parseInt(line);
        line = in.readLine();
        line = line.substring(line.indexOf(":") + 1).trim();
        this.reciprocalFitness = line.equals("true");
    }

    public int getExampleCount() {
        return this.exampleCount;
    }

    public double getVariance() {
        return Double.NaN;
    }

    public void setValue(double value, int numberOfExamples) {
        this.value = value * (double)numberOfExamples;
        this.exampleCount = numberOfExamples;
    }

    public double getValue() {
        return this.value / (double)this.exampleCount;
    }

    public double getFitness() {
        if (this.reciprocalFitness) {
            if (this.getValue() == 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 1.0 / this.getValue();
        }
        return this.getValue();
    }

    public String getName() {
        return this.name;
    }

    protected void cloneAveragable(Averagable other) {
        EstimatedPerformance ep = (EstimatedPerformance)other;
        this.name = ep.name;
        this.reciprocalFitness = ep.reciprocalFitness;
        this.exampleCount = ep.exampleCount;
        this.value = ep.value;
    }

    public void buildSingleAverage(Averagable performance) {
        EstimatedPerformance other = (EstimatedPerformance)performance;
        this.exampleCount += other.exampleCount;
        this.value += other.value;
    }
}

