/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.parameter;

import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class Parameters {
    private SortedMap keyToValueMap = new TreeMap();
    private SortedMap keyToTypeMap = new TreeMap();

    public Parameters() {
    }

    public Parameters(List parameterTypes) {
        Iterator i = parameterTypes.iterator();
        while (i.hasNext()) {
            ParameterType type = (ParameterType)i.next();
            this.keyToTypeMap.put(type.getKey(), type);
        }
    }

    public void copy(Parameters parameters) {
        Object key;
        TreeMap newKey2ValueMap = new TreeMap();
        TreeMap newKey2TypeMap = new TreeMap();
        Iterator i = this.keyToTypeMap.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            Object newType = parameters.keyToTypeMap.get(key);
            if (newType == null) {
                throw new NullPointerException("Error during copying a parameters object: the new parameters does not contain '" + key + "'!");
            }
            newKey2TypeMap.put(key, newType);
        }
        i = this.keyToValueMap.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            Object newValue = parameters.getParameter((String)key);
            newKey2ValueMap.put(key, newValue);
        }
        this.keyToValueMap = newKey2ValueMap;
        this.keyToTypeMap = newKey2TypeMap;
    }

    public Object clone() {
        Object key;
        Parameters clone = new Parameters(new LinkedList());
        Iterator i = this.keyToValueMap.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            clone.keyToValueMap.put(key, this.keyToValueMap.get(key));
        }
        i = this.keyToTypeMap.keySet().iterator();
        while (i.hasNext()) {
            key = i.next();
            clone.keyToTypeMap.put(key, this.keyToTypeMap.get(key));
        }
        return clone;
    }

    public ParameterType getParameterType(String key) {
        return (ParameterType)this.keyToTypeMap.get(key);
    }

    public void setParameter(String key, Object value) {
        ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
        if (type == null) {
            LogService.logMessage("Illegal key: '" + key + "'", 4);
            type = value instanceof List ? new ParameterTypeList(key, "guessed", new ParameterTypeString(null, null)) : new ParameterTypeString(key, "guessed");
            this.keyToTypeMap.put(key, type);
        }
        this.keyToValueMap.put(key, type.checkValue(value));
    }

    public void setParameterWithoutCheck(String key, Object value) {
        if (value == null) {
            this.keyToValueMap.remove(key);
        } else {
            this.keyToValueMap.put(key, value);
        }
    }

    public Object getParameter(String key) {
        if (this.keyToValueMap.containsKey(key)) {
            return this.keyToValueMap.get(key);
        }
        ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
        if (type == null) {
            return null;
        }
        Object value = type.getDefaultValue();
        if (value == null && !type.isOptional()) {
            LogService.logMessage("Parameter '" + key + "' is not set and has no default value.", 6);
        } else {
            this.keyToValueMap.put(key, value);
            LogService.logMessage("Parameter '" + key + "' is not set. Using default ('" + type.toString(value) + "').", 0);
        }
        return value;
    }

    public Set getKeys() {
        return this.keyToValueMap.keySet();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Parameters) {
            String otherXML;
            String thisXML = this.getXML("");
            return thisXML.equals(otherXML = ((Parameters)o).getXML(""));
        }
        return false;
    }

    public String getXML(String indent) {
        StringBuffer result = new StringBuffer();
        Iterator i = this.keyToValueMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object value = this.keyToValueMap.get(key);
            ParameterType type = (ParameterType)this.keyToTypeMap.get(key);
            if (type != null) {
                result.append(type.getXML(indent, key, value));
                continue;
            }
            result.append(indent + "<parameter key=\"" + key + "\"\tvalue=\"" + value.toString() + "\"/>\n");
        }
        return result.toString();
    }
}

