/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import Jama.Matrix;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.meta.ParameterOptimizationOperator;
import edu.udo.cs.yale.operator.meta.ParameterSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

public class QuadraticParameterOptimizationOperator
extends ParameterOptimizationOperator {
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$operator$meta$ParameterSet == null ? (class$edu$udo$cs$yale$operator$meta$ParameterSet = QuadraticParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.meta.ParameterSet")) : class$edu$udo$cs$yale$operator$meta$ParameterSet, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = QuadraticParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    private static final String[] EXCEED_BEHAVIORS = new String[]{"ignore", "clip", "fail"};
    private static final int IGNORE = 0;
    private static final int CLIP = 1;
    private static final int FAIL = 2;
    private ParameterSet best;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$meta$ParameterSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public QuadraticParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        this.getParametersToOptimize();
        int ifExceedsRegion = this.getParameterAsInt("if_exceeds_region");
        int ifExceedsRange = this.getParameterAsInt("if_exceeds_range");
        for (int index = 0; index < this.parameterList.size(); ++index) {
            String[] valuesToSort = this.values[index];
            for (int ind1 = 0; ind1 < valuesToSort.length; ++ind1) {
                double val1 = Double.parseDouble(valuesToSort[ind1]);
                for (int ind2 = ind1 + 1; ind2 < valuesToSort.length; ++ind2) {
                    double val2 = Double.parseDouble(valuesToSort[ind2]);
                    if (!(val1 > val2)) continue;
                    String s = valuesToSort[ind1];
                    valuesToSort[ind1] = valuesToSort[ind2];
                    valuesToSort[ind2] = s;
                    val1 = val2;
                }
            }
        }
        this.best = null;
        int[] bestIndex = new int[this.parameterList.size()];
        ParameterSet[] allParameters = new ParameterSet[this.numberOfCombinations];
        int paramIndex = 0;
        while (true) {
            boolean ok;
            block51: {
                int j;
                LogService.logMessage("Using parameter set", 3);
                for (int j2 = 0; j2 < this.operators.length; ++j2) {
                    this.operators[j2].getParameters().setParameter(this.parameters[j2], this.values[j2][this.currentIndex[j2]]);
                    LogService.logMessage(this.operators[j2] + "." + this.parameters[j2] + " = " + this.values[j2][this.currentIndex[j2]], 3);
                }
                this.setInput(input.copy());
                PerformanceVector performance = this.getPerformance();
                String[] currentValues = new String[this.parameters.length];
                for (j = 0; j < this.parameters.length; ++j) {
                    currentValues[j] = this.values[j][this.currentIndex[j]];
                }
                allParameters[paramIndex] = new ParameterSet(this.operators, this.parameters, currentValues, performance);
                if (this.best == null || performance.compareTo(this.best.getPerformance()) > 0) {
                    this.best = allParameters[paramIndex];
                    for (j = 0; j < this.parameterList.size(); ++j) {
                        bestIndex[j] = this.currentIndex[j];
                    }
                }
                int k = 0;
                ok = true;
                do {
                    int n = k;
                    this.currentIndex[n] = this.currentIndex[n] + 1;
                    if (this.currentIndex[n] < this.values[k].length) break block51;
                    this.currentIndex[k] = 0;
                } while (++k < this.currentIndex.length);
                ok = false;
            }
            if (!ok) break;
            ++paramIndex;
        }
        int nrParameters = 0;
        for (int i = 0; i < this.parameterList.size(); ++i) {
            if (this.values[i].length > 2) {
                LogService.logMessage("Param " + i + ", bestI = " + bestIndex[i], 0);
                ++nrParameters;
                if (bestIndex[i] == 0) {
                    int n = i;
                    bestIndex[n] = bestIndex[n] + 1;
                }
                if (bestIndex[i] != this.values[i].length - 1) continue;
                int n = i;
                bestIndex[n] = bestIndex[n] - 1;
                continue;
            }
            LogService.logMessage("Parameter " + this.parameters[i] + " has <3 values, skipped.", 4);
        }
        if (nrParameters > 3) {
            LogService.logMessage("Optimization not recommended for >3 values. Check results carefully!", 4);
        }
        if (nrParameters > 0) {
            int j;
            int i;
            int threetok = 1;
            for (int i2 = 0; i2 < nrParameters; ++i2) {
                threetok *= 3;
            }
            LogService.logMessage("Optimising " + nrParameters + " parameters", 0);
            Matrix Designmatrix = new Matrix(threetok, nrParameters + nrParameters * (nrParameters + 1) / 2 + 1);
            Matrix y = new Matrix(threetok, 1);
            paramIndex = 0;
            for (int i3 = this.parameterList.size() - 1; i3 >= 0; --i3) {
                this.currentIndex[i3] = this.values[i3].length > 2 ? bestIndex[i3] - 1 : bestIndex[i3];
                paramIndex = paramIndex * this.values[i3].length + this.currentIndex[i3];
            }
            block13: for (int row = 0; row < Designmatrix.getRowDimension(); ++row) {
                int i4;
                y.set(row, 0, allParameters[paramIndex].getPerformance().getMainCriterion().getFitness());
                Designmatrix.set(row, 0, 1.0);
                int c = 1;
                for (i4 = 0; i4 < nrParameters; ++i4) {
                    if (this.values[i4].length <= 2) continue;
                    Designmatrix.set(row, c, this.param2coded(this.values[i4][this.currentIndex[i4]], this.logBase[i4]));
                    ++c;
                }
                for (i4 = 0; i4 < nrParameters; ++i4) {
                    if (this.values[i4].length <= 2) continue;
                    for (int j3 = i4 + 1; j3 < nrParameters; ++j3) {
                        if (this.values[j3].length <= 2) continue;
                        Designmatrix.set(row, c, this.param2coded(this.values[i4][this.currentIndex[i4]], this.logBase[i4]) * this.param2coded(this.values[j3][this.currentIndex[j3]], this.logBase[j3]));
                        ++c;
                    }
                }
                for (i4 = 0; i4 < nrParameters; ++i4) {
                    if (this.values[i4].length <= 2) continue;
                    Designmatrix.set(row, c, this.param2coded(this.values[i4][this.currentIndex[i4]], this.logBase[i4]) * this.param2coded(this.values[i4][this.currentIndex[i4]], this.logBase[i4]));
                    ++c;
                }
                int k = 0;
                c = 1;
                while (k < this.parameterList.size()) {
                    if (this.values[k].length > 2) {
                        int n = k;
                        this.currentIndex[n] = this.currentIndex[n] + 1;
                        paramIndex += c;
                        if (this.currentIndex[k] <= bestIndex[k] + 1) continue block13;
                        this.currentIndex[k] = bestIndex[k] - 1;
                        paramIndex -= 3 * c;
                        c *= this.values[k].length;
                        ++k;
                        continue;
                    }
                    c *= this.values[k].length;
                    ++k;
                }
            }
            Matrix beta = Designmatrix.solve(y);
            for (int i5 = 0; i5 < Designmatrix.getColumnDimension(); ++i5) {
                LogService.logMessage(" -- Writing " + beta.get(i5, 0) + " at position " + i5 + " in vector b", 4);
            }
            Matrix p = new Matrix(nrParameters, nrParameters);
            int betapos = nrParameters + 1;
            for (int j4 = 0; j4 < nrParameters - 1; ++j4) {
                for (i = 1 + j4; i < nrParameters; ++i) {
                    p.set(i, j4, beta.get(betapos, 0) * 0.5);
                    p.set(j4, i, beta.get(betapos, 0) * 0.5);
                    ++betapos;
                }
            }
            for (int i6 = 0; i6 < nrParameters; ++i6) {
                p.set(i6, i6, beta.get(betapos, 0));
                ++betapos;
            }
            Matrix y2 = new Matrix(nrParameters, 1);
            for (i = 0; i < nrParameters; ++i) {
                y2.set(i, 0, beta.get(i + 1, 0));
            }
            y2 = y2.times(-0.5);
            Matrix x = new Matrix(nrParameters, 1);
            try {
                x = p.solve(y2);
            }
            catch (RuntimeException e) {
                LogService.logMessage("Quadratic optimization failed. (invalid matrix)", 4);
            }
            String[] Qvalues = new String[this.parameterList.size()];
            int pc = 0;
            boolean ok = true;
            for (j = 0; j < this.parameterList.size(); ++j) {
                if (this.values[j].length > 2) {
                    if (x.get(pc, 0) > Double.parseDouble(this.values[j][bestIndex[j] + 1]) || x.get(pc, 0) < Double.parseDouble(this.values[j][bestIndex[j] - 1])) {
                        LogService.logMessage("Parameter " + this.parameters[j] + " exceeds region of interest (" + x.get(pc, 0) + ")", 4);
                        if (ifExceedsRegion == 1) {
                            if (x.get(pc, 0) > Double.parseDouble(this.values[j][bestIndex[j] + 1])) {
                                x.set(pc, 0, Double.parseDouble(this.values[j][bestIndex[j] + 1]));
                            } else {
                                x.set(pc, 0, Double.parseDouble(this.values[j][bestIndex[j] - 1]));
                            }
                        } else if (ifExceedsRegion == 2) {
                            ok = false;
                        }
                    }
                    if (x.get(pc, 0) < Double.parseDouble(this.values[j][0]) || x.get(pc, 0) > Double.parseDouble(this.values[j][this.values[j].length - 1])) {
                        LogService.logMessage("Parameter " + this.parameters[j] + " exceeds range (" + x.get(pc, 0) + ")", 4);
                        if (ifExceedsRange == 0) {
                            LogService.logMessage("  but no measures taken. Check parameters manually!", 4);
                        } else if (ifExceedsRange == 1) {
                            if (x.get(pc, 0) > Double.parseDouble(this.values[j][0])) {
                                x.set(pc, 0, Double.parseDouble(this.values[j][0]));
                            } else {
                                x.set(pc, 0, Double.parseDouble(this.values[j][this.values[j].length - 1]));
                            }
                        } else {
                            ok = false;
                        }
                    }
                    Qvalues[j] = this.coded2param(x.get(pc, 0), this.logBase[j]);
                    ++pc;
                    continue;
                }
                Qvalues[j] = this.values[j][bestIndex[j]];
            }
            LogService.logMessage("Optimised parameter set:", 4);
            for (j = 0; j < this.operators.length; ++j) {
                this.operators[j].getParameters().setParameter(this.parameters[j], Qvalues[j]);
                LogService.logMessage("  " + this.operators[j] + "." + this.parameters[j] + " = " + Qvalues[j], 3);
            }
            if (ok) {
                this.setInput(input.copy());
                PerformanceVector Qperformance = this.getPerformance();
                LogService.logMessage("Old: " + this.best.getPerformance().getMainCriterion().getFitness(), 2);
                LogService.logMessage("New: " + Qperformance.getMainCriterion().getFitness(), 2);
                if (Qperformance.compareTo(this.best.getPerformance()) > 0) {
                    this.best = new ParameterSet(this.operators, this.parameters, Qvalues, Qperformance);
                    LogService.logMessage("Optimised parameter set does increase the performance", 2);
                } else {
                    LogService.logMessage("Could not increase performance by quadratic optimization", 2);
                }
            } else {
                LogService.logMessage("Parameters outside admissible range, not using optimised parameter set.", 4);
            }
        } else {
            LogService.logMessage("No parameters to optimize", 4);
        }
        return new IOObject[]{this.best, this.best.getPerformance()};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeCategory("if_exceeds_region", "What to do if range is exceeded.", EXCEED_BEHAVIORS, 1));
        types.add(new ParameterTypeCategory("if_exceeds_range", "What to do if range is exceeded.", EXCEED_BEHAVIORS, 2));
        return types;
    }

    protected PerformanceVector getPerformance() throws OperatorException {
        IOObject[] evalout = super.apply();
        IOContainer evalCont = new IOContainer(evalout);
        return (PerformanceVector)evalCont.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = QuadraticParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            Operator o = this.getOperator(i);
            input = o.checkIO(input);
        }
        return OUTPUT_CLASSES;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return 1 + this.numberOfCombinations * (this.getNumberOfChildrensSteps() + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

