/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import Jama.Matrix;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.meta.MatrixBasedParameterOptimizationOperator;
import edu.udo.cs.yale.operator.meta.ParameterSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.List;

public class PatternSearchParameterOptimizationOperator
extends MatrixBasedParameterOptimizationOperator {
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$operator$meta$ParameterSet == null ? (class$edu$udo$cs$yale$operator$meta$ParameterSet = PatternSearchParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.meta.ParameterSet")) : class$edu$udo$cs$yale$operator$meta$ParameterSet, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = PatternSearchParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, class$edu$udo$cs$yale$operator$meta$ParameterSet == null ? (class$edu$udo$cs$yale$operator$meta$ParameterSet = PatternSearchParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.meta.ParameterSet")) : class$edu$udo$cs$yale$operator$meta$ParameterSet, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = PatternSearchParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    private static final String[] patternTypes = new String[]{"standardPattern"};
    private Matrix[] roundResults;
    private static final int standardPattern = 0;
    private int pattern;
    private int numberOfEvaluationSteps;
    private int numberRepetition;
    private int patternSize;
    private int fittestIndex;
    private double scale;
    private double minscale;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$meta$ParameterSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public PatternSearchParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    public void setSearchPattern(Matrix patternAnchor, double anchorYValue) {
        if (this.pattern == 0) {
            this.patternSize = 2 * this.parameterListSize + 1;
            this.fittestIndex = this.patternSize - 1;
            this.yValues = new double[this.patternSize];
            this.operationMatrix = new Matrix(this.parameterListSize, this.patternSize);
            this.insertVector(patternAnchor, this.patternSize - 1, anchorYValue);
            double value = 1.0 * this.scale;
            for (int i = 0; i < this.patternSize - 1; ++i) {
                Matrix generate = new Matrix(this.parameterListSize, 1);
                if (i >= this.parameterListSize) {
                    value = -1.0 * value;
                }
                generate.set(i % this.parameterListSize, 0, value);
                this.insertVector(generate, i, 0.0);
            }
        }
    }

    public void rangeExceptionHandling(Matrix irregularVector) {
        boolean inRange = true;
        double parameterValue = 0.0;
        for (int i = 0; i < this.parameterListSize; ++i) {
            double min = this.parameterRange[i].parameterLowerBound;
            double max = this.parameterRange[i].parameterUpperBound;
            parameterValue = this.coded2param4RangeVerification(irregularVector.get(i, 0), this.parameterLogbase[i]);
            if (parameterValue >= min && parameterValue <= max) continue;
            this.yValues[i] = Double.NEGATIVE_INFINITY;
        }
    }

    public IOObject[] apply() throws OperatorException {
        int i;
        IOContainer input = this.getInput();
        this.numberOfEvaluationSteps = this.getParameterAsInt("number_of_evaluation_steps");
        this.pattern = this.getParameterAsInt("pattern");
        this.numberRepetition = this.getParameterAsInt("grade_of_repetition");
        this.roundResults = new Matrix[this.numberRepetition];
        this.scale = this.getParameterAsDouble("scaling_constant");
        this.minscale = this.getParameterAsDouble("minimal_size_of_the_search_pattern");
        this.getParametersToOptimize();
        Matrix patternAnchor = new Matrix(this.parameterListSize, 1);
        Matrix currentPoint = new Matrix(this.parameterListSize, 1);
        int iterations = 1;
        double anchorYValue = 0.0;
        for (i = 0; i < this.parameterListSize; ++i) {
            if (this.parameterIsInRange(i)) {
                patternAnchor.set(i, 0, this.parameterValues[i]);
                continue;
            }
            this.rangeExceptionHandling(patternAnchor);
        }
        for (int r = 0; r < this.numberRepetition; ++r) {
            this.setDataToExperiment(patternAnchor, 0);
            this.setInput(input.copy());
            PerformanceVector anchorPerformance = this.getPerformance();
            anchorYValue = anchorPerformance.getMainCriterion().getFitness();
            this.setSearchPattern(patternAnchor, anchorYValue);
            while (iterations <= this.numberOfEvaluationSteps && this.minscale <= this.scale) {
                for (int i2 = 0; i2 < this.patternSize - 1; ++i2) {
                    currentPoint = patternAnchor.plus(this.getVector(i2));
                    if (this.vectorIsInRange(currentPoint)) {
                        this.setDataToExperiment(currentPoint, 0);
                        this.setInput(input.copy());
                        PerformanceVector performance = this.getPerformance();
                        this.insertVector(currentPoint, i2, performance.getMainCriterion().getFitness());
                        continue;
                    }
                    this.rangeExceptionHandling(currentPoint);
                }
                int max = this.determineHigh(this.patternSize);
                if (this.fittestIndex == max || this.yValues[this.fittestIndex] == this.yValues[max]) {
                    this.scale /= 2.0;
                    this.setSearchPattern(patternAnchor, anchorYValue);
                } else {
                    this.fittestIndex = max;
                    patternAnchor = this.getVector(this.fittestIndex);
                    anchorYValue = this.yValues[max];
                    this.setSearchPattern(patternAnchor, anchorYValue);
                }
                ++iterations;
            }
            this.roundResults[r] = this.getVector(this.fittestIndex);
            patternAnchor = this.getRandomVectorWithinRange();
        }
        currentPoint = this.roundResults[0];
        for (i = 1; i < this.numberRepetition; ++i) {
            currentPoint = currentPoint.plus(this.roundResults[i]);
        }
        currentPoint = currentPoint.times((double)(1 / this.numberRepetition));
        this.setDataToExperiment(currentPoint, 0);
        this.setInput(input.copy());
        PerformanceVector finalPerformance = this.getPerformance();
        ParameterSet opt = new ParameterSet(this.operatorArray, this.parameterNames, this.transformVector(currentPoint), finalPerformance);
        return new IOObject[]{opt, opt.getPerformance()};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_evaluation_steps", "Determines how often the search algorithm iterates.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("pattern", "Chooses the style of the search-pattern.", patternTypes, 0));
        types.add(new ParameterTypeInt("grade_of_repetition", "Determines how often the operator repeats his action using a randomly selected starting point.", 1, Integer.MAX_VALUE, 1));
        types.add(new ParameterTypeDouble("scaling_constant", "Scales the size of the search-pattern.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("minimal_size_of_the_search_pattern", "Optimization stops when the size of the search-pattern reaches this value.", 0.0, Double.POSITIVE_INFINITY, 0.01));
        return types;
    }

    protected PerformanceVector getPerformance() throws OperatorException {
        IOObject[] evalout = super.apply();
        IOContainer evalCont = new IOContainer(evalout);
        return (PerformanceVector)evalCont.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = PatternSearchParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            Operator o = this.getOperator(i);
            input = o.checkIO(input);
        }
        return OUTPUT_CLASSES;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return 1 * (this.getNumberOfChildrensSteps() + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

