/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import Jama.Matrix;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.meta.MatrixBasedParameterOptimizationOperator;
import edu.udo.cs.yale.operator.meta.ParameterSet;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

public class NelderMeadParameterOptimizationOperator
extends MatrixBasedParameterOptimizationOperator {
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$operator$meta$ParameterSet == null ? (class$edu$udo$cs$yale$operator$meta$ParameterSet = NelderMeadParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.meta.ParameterSet")) : class$edu$udo$cs$yale$operator$meta$ParameterSet, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = NelderMeadParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    private int scale;
    private int eSteps;
    private double amax;
    private double rCoeff;
    private double eCoeff;
    private double cCoeff;
    private double sCoeff;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$meta$ParameterSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public NelderMeadParameterOptimizationOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        int i;
        IOContainer input = this.getInput();
        this.getParametersToOptimize();
        this.scale = this.getParameterAsInt("scaling_constant");
        this.eSteps = this.getParameterAsInt("number_of_evaluation_steps");
        this.amax = this.getParameterAsDouble("accepted_maximum");
        this.rCoeff = this.getParameterAsDouble("reflection_coefficient");
        this.eCoeff = this.getParameterAsDouble("expansion_coefficient");
        this.cCoeff = this.getParameterAsDouble("contraction_coefficient");
        this.sCoeff = this.getParameterAsDouble("shrinkage_coefficient");
        int high = 0;
        int low = 0;
        Matrix p1 = new Matrix(this.parameterListSize, 1);
        Matrix p2 = new Matrix(this.parameterListSize, 1);
        double p1Value = 0.0;
        double p2Value = 0.0;
        double maxOptValue = Double.NEGATIVE_INFINITY;
        Matrix maxOptVector = new Matrix(this.parameterListSize, 1);
        this.operationMatrix = new Matrix(this.parameterListSize, this.parameterListSize + 1);
        this.yValues = new double[this.parameterListSize + 1];
        Matrix startingPoint = new Matrix(this.parameterListSize, 1);
        for (i = 0; i < this.parameterListSize; ++i) {
            startingPoint.set(i, 0, this.parameterValues[i]);
        }
        this.insertVector(startingPoint, 0, 0.0);
        for (i = 0; i < this.parameterListSize; ++i) {
            Matrix outPut = new Matrix(this.parameterListSize, 1);
            for (int j = 0; j < this.parameterListSize; ++j) {
                outPut.set(j, 0, this.getRandomValueWithinRange(j));
            }
            outPut.set(i, 0, startingPoint.get(i, 0) * (double)this.scale);
            this.insertVector(outPut, i + 1, 0.0);
        }
        for (i = 0; i <= this.parameterListSize; ++i) {
            this.setDataToExperiment(this.operationMatrix, i);
            this.setInput(input.copy());
            PerformanceVector performance = this.getPerformance();
            this.yValues[i] = performance.getMainCriterion().getFitness();
        }
        high = this.determineHigh(this.parameterListSize);
        for (int iterations = 1; iterations <= this.eSteps; ++iterations) {
            low = this.determineLow(this.parameterListSize);
            Matrix centroid = this.determineCentroid(low);
            p1 = centroid.times(1.0 + this.rCoeff).minus(this.getVector(low).times(this.rCoeff));
            if (this.vectorIsInRange(p1)) {
                this.setDataToExperiment(p1, 0);
                this.setInput(input.copy());
                PerformanceVector performance1 = this.getPerformance();
                p1Value = performance1.getMainCriterion().getFitness();
            } else {
                p1Value = Double.NEGATIVE_INFINITY;
            }
            if (p1Value > this.yValues[high]) {
                p2 = p1.times(1.0 + this.eCoeff).minus(centroid.times(this.eCoeff));
                if (this.vectorIsInRange(p2)) {
                    this.setDataToExperiment(p2, 0);
                    this.setInput(input.copy());
                    PerformanceVector performance2 = this.getPerformance();
                    p2Value = performance2.getMainCriterion().getFitness();
                } else {
                    p2Value = Double.NEGATIVE_INFINITY;
                }
                if (p2Value > this.yValues[high]) {
                    this.insertVector(p2, low, p2Value);
                    LogService.logMessage("*** Perform Expansion-step ***", 2);
                } else {
                    this.insertVector(p1, low, p1Value);
                    LogService.logMessage("*** Perform Reflection-step ***", 2);
                }
            } else {
                boolean newLow = false;
                for (int i2 = 0; i2 <= this.parameterListSize; ++i2) {
                    newLow = p1Value < this.yValues[i2] && i2 != low;
                }
                if (newLow) {
                    if (p1Value > this.yValues[high]) {
                        this.insertVector(p1, low, p1Value);
                    }
                    if (this.vectorIsInRange(p2 = this.getVector(low).times(this.cCoeff).plus(centroid.times(1.0 - this.cCoeff)))) {
                        this.setDataToExperiment(p2, 0);
                        this.setInput(input.copy());
                        PerformanceVector performance2 = this.getPerformance();
                        p2Value = performance2.getMainCriterion().getFitness();
                    } else {
                        p2Value = Double.NEGATIVE_INFINITY;
                    }
                    if (p2Value < this.yValues[low]) {
                        for (int i3 = 0; i3 <= this.parameterListSize; ++i3) {
                            this.insertVector(this.getVector(i3).plus(this.getVector(high)).times(this.sCoeff), i3, this.yValues[i3]);
                            Matrix currentPoint = this.operationMatrix.getMatrix(0, this.parameterListSize - 1, i3, i3);
                            if (this.vectorIsInRange(currentPoint)) {
                                this.setDataToExperiment(this.operationMatrix, i3);
                                this.setInput(input.copy());
                                PerformanceVector performance = this.getPerformance();
                                this.yValues[i3] = performance.getMainCriterion().getFitness();
                                continue;
                            }
                            this.yValues[i3] = Double.NEGATIVE_INFINITY;
                        }
                        LogService.logMessage("*** Perform Shrinkage-step ***", 2);
                    } else {
                        this.insertVector(p2, low, p2Value);
                        LogService.logMessage("*** Perform Contraction-step ***", 2);
                    }
                } else {
                    this.insertVector(p1, low, p1Value);
                    LogService.logMessage("*** Perform Reflection-step ***", 2);
                }
            }
            high = this.determineHigh(this.parameterListSize);
            if (this.yValues[high] > maxOptValue) {
                maxOptValue = this.yValues[high];
                maxOptVector = this.getVector(high);
            }
            if (this.amax <= this.yValues[high]) break;
        }
        this.setDataToExperiment(maxOptVector, 0);
        this.setInput(input.copy());
        PerformanceVector maxOptPerformance = this.getPerformance();
        ParameterSet maxOpt = new ParameterSet(this.operatorArray, this.parameterNames, this.transformVector(maxOptVector), maxOptPerformance);
        return new IOObject[]{maxOpt, maxOpt.getPerformance()};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("number_of_evaluation_steps", "Number of iterations the algorithm computes.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("accepted_maximum", "Algorithm stops if the fitness of the supervised learner has reached this value.", 0.0, Double.POSITIVE_INFINITY, 0.8);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("reflection_coefficient", "reflection coefficient", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("expansion_coefficient", "expansion coefficient", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 2.0));
        types.add(new ParameterTypeDouble("contraction_coefficient", "contraction coefficient", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.5));
        types.add(new ParameterTypeDouble("shrinkage_coefficient", "shrinkage coefficient", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.5));
        types.add(new ParameterTypeInt("scaling_constant", "Scales initial operationmatrix.", 1, Integer.MAX_VALUE, 1));
        return types;
    }

    protected PerformanceVector getPerformance() throws OperatorException {
        IOObject[] evalout = super.apply();
        IOContainer evalCont = new IOContainer(evalout);
        return (PerformanceVector)evalCont.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = NelderMeadParameterOptimizationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            Operator o = this.getOperator(i);
            input = o.checkIO(input);
        }
        return OUTPUT_CLASSES;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return 1 * (this.getNumberOfChildrensSteps() + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

