/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.performance.EstimatedPerformance;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.LinkedList;
import java.util.List;

public class MartinsIterationOperator
extends OperatorChain {
    private int iteration = 0;
    private PerformanceVector performance;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public MartinsIterationOperator(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "best performance"){

            public double getValue() {
                if (MartinsIterationOperator.this.performance != null) {
                    return MartinsIterationOperator.this.performance.getMainCriterion().getValue();
                }
                return Double.NaN;
            }
        });
        this.addValue(new Value("iteration", "current iteration"){

            public double getValue() {
                return MartinsIterationOperator.this.iteration;
            }
        });
    }

    public String getDeprecationInfo() {
        return "Deprecated.";
    }

    public IOObject[] apply() throws OperatorException {
        IOContainer input = this.getInput();
        String operatorName = this.getParameterAsString("operator_name");
        Operator operator = this.getExperiment().getOperator(operatorName);
        int maxIteration = this.getParameterAsInt("max_iteration");
        PerformanceVector pv = new PerformanceVector();
        String perfName = "";
        this.iteration = 1;
        while (this.iteration <= maxIteration) {
            LinkedList<String[]> paraList = new LinkedList<String[]>();
            paraList.add(new String[]{"iteration", this.iteration + ""});
            operator.getParameters().setParameter("prediction_parameters", paraList);
            this.setInput(input.copy());
            this.performance = this.getPerformance();
            double auc = this.performance.getCriterion("AUC").getValue();
            perfName = "AUC_" + this.iteration;
            EstimatedPerformance perfCrit = new EstimatedPerformance(perfName, auc, 1, false);
            pv.addCriterion(perfCrit);
            System.out.println(this.iteration + ": " + auc);
            this.inApplyLoop();
            ++this.iteration;
        }
        pv.setMainCriterionName(perfName);
        return new IOObject[]{pv};
    }

    private PerformanceVector getPerformance() throws OperatorException {
        IOObject[] evalout = super.apply();
        IOContainer evalCont = new IOContainer(evalout);
        return (PerformanceVector)evalCont.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = MartinsIterationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = MartinsIterationOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).checkIO(input);
        }
        return this.getDeliveredOutputClasses();
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return 1;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString("operator_name", "The name.", null));
        types.add(new ParameterTypeInt("max_iteration", "The maximum iteration.", 1, Integer.MAX_VALUE, 10));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

