/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.weka;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.Learner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.weka.GenericWekaLearner;
import edu.udo.cs.yale.operator.learner.weka.WekaClassifier;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaLearnerCapabilities;
import edu.udo.cs.yale.tools.WekaTools;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import weka.classifiers.Classifier;
import weka.core.Instances;
import weka.core.OptionHandler;

public class GenericWekaMetaLearner
extends OperatorChain
implements Learner {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = GenericWekaMetaLearner.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = GenericWekaMetaLearner.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model};
    public static final String[] WEKA_CLASSIFIERS = WekaTools.getWekaClasses(class$weka$classifiers$Classifier == null ? (class$weka$classifiers$Classifier = GenericWekaMetaLearner.class$("weka.classifiers.Classifier")) : class$weka$classifiers$Classifier, ".meta.", true);
    private List wekaParameters = new LinkedList();
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$Model;
    static /* synthetic */ Class class$weka$classifiers$Classifier;

    public GenericWekaMetaLearner(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = GenericWekaMetaLearner.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        Model model = this.learn(exampleSet);
        String filename = this.getParameterAsString("model_file");
        try {
            if (filename != null) {
                model.writeModel(this.getExperiment().resolveFileName(filename));
            }
        }
        catch (IOException e) {
            LogService.logMessage("WekaMetaLearner'" + this.getName() + "': " + "Cannot write model to file!", 6);
        }
        return new IOObject[]{model};
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        Classifier classifier = this.getWekaClassifier(this.getWekaParameters());
        LogService.logMessage(this.getName() + ": Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "TempInstances", exampleSet.getLabel(), true);
        try {
            LogService.logMessage(this.getName() + ": Building Weka classifier.", 0);
            classifier.buildClassifier(instances);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, new Object[]{this.getOperatorClassName(), e});
        }
        return new WekaClassifier(exampleSet.getLabel(), classifier);
    }

    public String getWekaClassPath() {
        for (int i = 0; i < WEKA_CLASSIFIERS.length; ++i) {
            if (!WEKA_CLASSIFIERS[i].endsWith(this.getOperatorClassName())) continue;
            return WEKA_CLASSIFIERS[i];
        }
        return null;
    }

    public List getWekaParameterList() {
        return this.wekaParameters;
    }

    private Classifier getWekaClassifier(String[] parameters) throws OperatorException {
        String classifierName = this.getWekaClassPath();
        Classifier classifier = null;
        try {
            classifier = Classifier.forName((String)classifierName, (String[])parameters);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{classifierName, e});
        }
        return classifier;
    }

    private String[] getWekaParameters() {
        int i;
        String[] parameters = WekaTools.getWekaParametersFromTypes(this, this.wekaParameters);
        GenericWekaLearner inner = (GenericWekaLearner)this.getOperator(0);
        String[] innerParameters = WekaTools.getWekaParametersFromTypes(inner, inner.getWekaParameterList());
        int n = 0;
        String[] result = new String[parameters.length + 3 + innerParameters.length];
        for (i = 0; i < parameters.length; ++i) {
            result[n++] = parameters[i];
        }
        result[n++] = "-W";
        result[n++] = inner.getWekaClassPath();
        result[n++] = "--";
        for (i = 0; i < innerParameters.length; ++i) {
            result[n++] = innerParameters[i];
        }
        return result;
    }

    public boolean supportsCapability(LearnerCapability capability) {
        try {
            Classifier classifier = this.getWekaClassifier(this.getWekaParameters());
            return WekaLearnerCapabilities.supportsCapability(classifier, capability);
        }
        catch (OperatorException e) {
            return false;
        }
    }

    public boolean shouldEstimatePerformance() {
        return false;
    }

    public boolean shouldCalculateWeights() {
        return false;
    }

    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), (Object)"estimation of performance not supported.");
    }

    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), (Object)"calculation of weights not supported.");
    }

    public int getNumberOfSteps() {
        return 1;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getMaxNumberOfInnerOperators() {
        return 1;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        if (!(this.getOperator(0) instanceof GenericWekaLearner)) {
            throw new IllegalInputException((Operator)this, "Inner operator of a Weka meta learning operator must be another Weka learning scheme.");
        }
        if (!IODescription.containsClass(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = GenericWekaMetaLearner.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet, input)) {
            throw new IllegalInputException((Operator)this, class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = GenericWekaMetaLearner.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        }
        return this.getDeliveredOutputClasses();
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        Classifier classifier = null;
        try {
            classifier = this.getWekaClassifier(null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka classifier " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList();
        if (classifier != null && classifier instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)classifier, types, this.wekaParameters);
        }
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

