/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.lazy;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.IOModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DefaultModel
extends IOModel {
    private double value;
    private double[] confidences;

    public DefaultModel(Attribute label) {
        super(label);
    }

    public DefaultModel(Attribute label, double value) {
        this(label, value, null);
    }

    public DefaultModel(Attribute label, double value, double[] confidences) {
        super(label);
        this.value = value;
        this.confidences = confidences;
    }

    public void apply(ExampleSet exampleSet) throws OperatorException {
        Attribute label = this.getLabel();
        ExampleReader r = exampleSet.getExampleReader();
        while (r.hasNext()) {
            Example example = r.next();
            example.setPredictedLabel(this.value);
            if (!label.isNominal()) continue;
            for (int i = 0; i < this.confidences.length; ++i) {
                example.setConfidence(label.mapIndex(i), this.confidences[i]);
            }
        }
    }

    public void readData(ObjectInputStream in) throws IOException {
        this.value = in.readDouble();
        int numberOfConfidences = in.readInt();
        if (numberOfConfidences > 0) {
            this.confidences = new double[numberOfConfidences];
            for (int i = 0; i < this.confidences.length; ++i) {
                this.confidences[i] = in.readDouble();
            }
        }
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeDouble(this.value);
        if (this.confidences == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.confidences.length);
            for (int i = 0; i < this.confidences.length; ++i) {
                out.writeDouble(this.confidences[i]);
            }
        }
    }

    public String toString() {
        return super.toString() + "\ndefault value: " + (this.getLabel().isNominal() ? this.getLabel().mapIndex((int)this.value) : this.value + "");
    }
}

