/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Individual;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Population;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PopulationOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;

public class TournamentSelection
implements PopulationOperator {
    private double popSize;
    private double tournamentFraction;
    private boolean keepBest = false;

    public TournamentSelection(int popSize, double tournamentFraction, boolean keepBest) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.tournamentFraction = tournamentFraction;
    }

    public void operate(Population population) {
        LinkedList<Object> newGeneration = new LinkedList<Object>();
        int tournamentSize = Math.max((int)Math.round((double)population.getNumberOfIndividuals() * this.tournamentFraction), 1);
        if (this.keepBest && population.getBestEver() != null) {
            newGeneration.add(population.getBestEver().clone());
        }
        while ((double)newGeneration.size() < this.popSize) {
            Individual winner = null;
            for (int k = 0; k < tournamentSize; ++k) {
                Individual current = population.get(RandomGenerator.getGlobalRandomGenerator().nextInt(population.getNumberOfIndividuals()));
                if (winner != null && !(current.getFitness() > winner.getFitness())) continue;
                winner = current;
            }
            newGeneration.add(winner.clone());
        }
        population.clear();
        population.addAll(newGeneration);
    }
}

