/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.gui.SimplePlotterDialog;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.ClassificationOptimizationFunction;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Crossover;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.EvoSVMModel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Individual;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Kernel;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Mutation;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.OptimizationFunction;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Population;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PopulationOperator;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.RegressionOptimizationFunction;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.SupportVector;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.TournamentSelection;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.awt.Dialog;
import java.awt.Window;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class EvoOptimization {
    private static final double IS_ZERO = 1.0E-10;
    private ExampleSet exampleSet;
    private Kernel kernel;
    private double c;
    private double epsilon = 0.0;
    private int maxIterations;
    private int generationsWithoutImprovement;
    private double[] ys;
    private Population population;
    private int popSize;
    private Collection popOps;
    private OptimizationFunction optimizationFunction;
    private boolean showPlot = false;

    public EvoOptimization(ExampleSet exampleSet, Kernel kernel, double c, int maxIterations, int generationsWithoutImprovement, int popSize, double crossoverProb, double mutationSigma, double tournamentFraction, boolean keepBest, boolean showPlot) {
        boolean regression;
        this.exampleSet = exampleSet;
        this.kernel = kernel;
        this.kernel.init(exampleSet);
        this.showPlot = showPlot;
        this.c = c;
        if (this.c <= 0.0) {
            this.c = 0.0;
            for (int i = 0; i < exampleSet.getSize(); ++i) {
                this.c += kernel.getDistance(i, i);
            }
            this.c = (double)exampleSet.getSize() / this.c;
            LogService.logMessage("Determine probably good value for C: set to " + this.c, 2);
        }
        this.popSize = popSize < 1 ? exampleSet.getSize() : popSize;
        this.maxIterations = maxIterations;
        this.generationsWithoutImprovement = generationsWithoutImprovement < 1 ? this.maxIterations : generationsWithoutImprovement;
        this.ys = new double[exampleSet.getSize()];
        ExampleReader reader = exampleSet.getExampleReader();
        int index = 0;
        Attribute label = exampleSet.getLabel();
        boolean bl = regression = !label.isBooleanClassification();
        while (reader.hasNext()) {
            Example example = reader.next();
            if (!regression) {
                this.ys[index++] = example.getLabel() == (double)label.getPositiveIndex() ? 1.0 : -1.0;
                continue;
            }
            this.ys[index++] = example.getLabel();
        }
        this.optimizationFunction = !regression ? new ClassificationOptimizationFunction() : new RegressionOptimizationFunction(this.epsilon);
        this.popOps = new LinkedList();
        Mutation mutation = new Mutation(mutationSigma < 0.0 ? this.c / 10.0 : mutationSigma, this.c);
        this.popOps.add(new TournamentSelection(popSize, tournamentFraction, keepBest));
        this.popOps.add(new Crossover(crossoverProb));
        this.popOps.add(mutation);
    }

    public EvoSVMModel train() {
        this.population = this.createStartPopulation();
        this.evaluate(this.population);
        Statistics stats = null;
        Window plotter = null;
        if (this.showPlot) {
            stats = new Statistics("Fitness vs. Generations");
            stats.init(new String[]{"Generations", "Fitness"});
            stats.init(new String[]{"Generations", "Best Fitness", "Current Fitness"});
            plotter = new SimplePlotterDialog(stats, false);
            ((SimplePlotterDialog)plotter).setXAxis(0);
            ((SimplePlotterDialog)plotter).plotColumn(1, true);
            ((SimplePlotterDialog)plotter).plotColumn(2, true);
            ((Dialog)plotter).setVisible(true);
            stats.add(new Object[]{new Double(0.0), new Double(this.population.getBestEver().getFitness()), new Double(this.population.getCurrentBest().getFitness())});
        }
        while (true) {
            if (this.population.getGeneration() >= this.maxIterations) {
                LogService.logMessage("EvoSVM finished: maximum number of iterations reached.", 2);
                break;
            }
            if (this.population.getGenerationsWithoutImprovement() > this.generationsWithoutImprovement) {
                LogService.logMessage("EvoSVM converged in generation " + this.population.getGeneration() + ": No improvement in last " + this.generationsWithoutImprovement + " generations.", 2);
                break;
            }
            Iterator i = this.popOps.iterator();
            while (i.hasNext()) {
                ((PopulationOperator)i.next()).operate(this.population);
            }
            this.evaluate(this.population);
            if (this.showPlot) {
                stats.add(new Object[]{new Double(this.population.getGeneration()), new Double(this.population.getBestEver().getFitness()), new Double(this.population.getCurrentBest().getFitness())});
            }
            this.population.nextGeneration();
        }
        if (this.showPlot) {
            plotter.dispose();
        }
        return this.getModel(this.population.getBestEver().getAlphas());
    }

    private void evaluate(Population population) {
        Individual currentBest = null;
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            Individual current = population.get(i);
            double fitness = this.optimizationFunction.getFunctionValue(current.getAlphas(), this.ys, this.kernel);
            current.setFitness(fitness);
            if (currentBest != null && !(fitness > currentBest.getFitness())) continue;
            currentBest = (Individual)current.clone();
        }
        population.setCurrentBest(currentBest);
        Individual bestEver = population.getBestEver();
        if (bestEver == null || currentBest.getFitness() > bestEver.getFitness()) {
            population.setBestEver((Individual)currentBest.clone());
        }
    }

    private Population createStartPopulation() {
        Population population = new Population();
        for (int i = 0; i < this.popSize; ++i) {
            double[] alphas = null;
            alphas = new double[this.exampleSet.getSize()];
            for (int j = 0; j < alphas.length; ++j) {
                alphas[j] = RandomGenerator.getGlobalRandomGenerator().nextDoubleInRange(0.0, this.c);
            }
            population.add(new Individual(alphas));
        }
        return population;
    }

    private EvoSVMModel getModel(double[] alphas) {
        int i;
        ExampleReader reader = this.exampleSet.getExampleReader();
        LinkedList<SupportVector> supportVectors = new LinkedList<SupportVector>();
        int index = 0;
        while (reader.hasNext()) {
            double currentAlpha = alphas[index];
            Example currentExample = reader.next();
            if (currentAlpha != 0.0) {
                double[] x = new double[this.exampleSet.getNumberOfAttributes()];
                for (int a = 0; a < x.length; ++a) {
                    x[a] = currentExample.getValue(this.exampleSet.getAttribute(a));
                }
                supportVectors.add(new SupportVector(x, this.ys[index], currentAlpha));
            }
            ++index;
        }
        double[] sum = new double[this.exampleSet.getSize()];
        reader = this.exampleSet.getExampleReader();
        index = 0;
        while (reader.hasNext()) {
            Example current = reader.next();
            double[] x = new double[this.exampleSet.getNumberOfAttributes()];
            for (int a = 0; a < x.length; ++a) {
                x[a] = current.getValue(this.exampleSet.getAttribute(a));
            }
            sum[index] = this.kernel.getSum(supportVectors, x);
            ++index;
        }
        double bSum = 0.0;
        int bCounter = 0;
        for (i = 0; i < alphas.length; ++i) {
            if (this.ys[i] * alphas[i] - this.c < -1.0E-10 && this.ys[i] * alphas[i] > 1.0E-10) {
                bSum += this.ys[i] - sum[i] - this.epsilon;
                ++bCounter;
                continue;
            }
            if (!(this.ys[i] * alphas[i] + this.c > 1.0E-10) || !(this.ys[i] * alphas[i] < -1.0E-10)) continue;
            bSum += this.ys[i] - sum[i] - this.epsilon;
            ++bCounter;
        }
        if (bCounter == 0) {
            bSum = 0.0;
            for (i = 0; i < alphas.length; ++i) {
                if (!(this.ys[i] * alphas[i] < 1.0E-10) || !(this.ys[i] * alphas[i] > -1.0E-10)) continue;
                bSum += this.ys[i] - sum[i];
                ++bCounter;
            }
            if (bCounter == 0) {
                bSum = 0.0;
                for (i = 0; i < alphas.length; ++i) {
                    bSum += this.ys[i] - sum[i];
                    ++bCounter;
                }
            }
        }
        return new EvoSVMModel(this.exampleSet.getLabel(), supportVectors, this.kernel, bSum / (double)bCounter);
    }
}

