/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel.evosvm;

import edu.udo.cs.yale.operator.learner.kernel.evosvm.Individual;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.Population;
import edu.udo.cs.yale.operator.learner.kernel.evosvm.PopulationOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;

public class Crossover
implements PopulationOperator {
    private double prob;
    private RandomGenerator random;

    public Crossover(double prob) {
        this.prob = prob;
        this.random = RandomGenerator.getGlobalRandomGenerator();
    }

    public void crossover(Individual i1, Individual i2) {
        int i;
        double[] alphas1 = i1.getAlphas();
        double[] alphas2 = i2.getAlphas();
        boolean[] swap = new boolean[alphas1.length];
        for (i = 0; i < swap.length; ++i) {
            swap[i] = this.random.nextBoolean();
        }
        for (i = 0; i < swap.length; ++i) {
            if (!swap[i]) continue;
            double dummy = alphas1[i];
            alphas1[i] = alphas2[i];
            alphas2[i] = dummy;
        }
        i1.setAlphas(alphas1);
        i2.setAlphas(alphas2);
    }

    public void operate(Population population) {
        if (population.getNumberOfIndividuals() < 2) {
            return;
        }
        LinkedList<Object> matingPool = new LinkedList<Object>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            matingPool.add(population.get(i).clone());
        }
        LinkedList<Object> l = new LinkedList<Object>();
        while (matingPool.size() > 1) {
            Individual p1 = (Individual)matingPool.remove(this.random.nextInt(matingPool.size()));
            Individual p2 = (Individual)matingPool.remove(this.random.nextInt(matingPool.size()));
            l.add(p1.clone());
            l.add(p2.clone());
            if (!(this.random.nextDouble() < this.prob)) continue;
            this.crossover(p1, p2);
            l.add(p1);
            l.add(p2);
        }
        l.addAll(matingPool);
        population.clear();
        population.addAll(l);
    }
}

