/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.ResultSetDataRowReader;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.DatabaseHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public abstract class ResultSetExampleSource
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ResultSetExampleSource.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public ResultSetExampleSource(OperatorDescription description) {
        super(description);
    }

    public abstract ResultSet getResultSet() throws OperatorException;

    public abstract void setNominalValues(List var1, ResultSet var2, Attribute var3) throws OperatorException;

    public IOObject[] apply() throws OperatorException {
        int dataRowType = this.getParameterAsInt("datamanagement");
        ResultSet resultSet = this.getResultSet();
        List attributeList = null;
        try {
            attributeList = DatabaseHandler.createAttributes(resultSet);
        }
        catch (SQLException e) {
            throw new UserError((Operator)this, (Throwable)e, 304, (Object)e.getMessage());
        }
        this.setNominalValues(attributeList, resultSet, ResultSetExampleSource.find(attributeList, this.getParameterAsString("label_attribute")));
        ResultSetDataRowReader reader = new ResultSetDataRowReader(new DataRowFactory(dataRowType), attributeList, resultSet);
        MemoryExampleTable table = new MemoryExampleTable(attributeList, reader);
        return new IOObject[]{this.createExampleSet(table)};
    }

    private static Attribute find(List attributeList, String name) throws OperatorException {
        if (name == null) {
            return null;
        }
        Iterator i = attributeList.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        throw new UserError(null, 111, name);
    }

    protected ExampleSet createExampleSet(ExampleTable table) throws OperatorException {
        String labelName = this.getParameterAsString("label_attribute");
        String weightName = this.getParameterAsString("weight_attribute");
        String idName = this.getParameterAsString("id_attribute");
        Attribute label = table.findAttribute(labelName);
        Attribute weight = table.findAttribute(weightName);
        Attribute id = table.findAttribute(idName);
        return table.createCompleteExampleSet(label, null, weight, id);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeString type = new ParameterTypeString("label_attribute", "The (case sensitive) name of the label attribute");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("id_attribute", "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString("weight_attribute", "The (case sensitive) name of the weight attribute"));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

