/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class NominalExampleSetGenerator
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = NominalExampleSetGenerator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public NominalExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt("number_examples");
        int numberOfAttributes = this.getParameterAsInt("number_of_attributes");
        int numberOfValues = this.getParameterAsInt("number_of_values");
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int m = 0; m < numberOfAttributes; ++m) {
            Attribute current = AttributeFactory.createAttribute("att" + (m + 1), 1);
            for (int v = 0; v < numberOfValues; ++v) {
                current.mapString("value" + v);
            }
            attributes.add(current);
        }
        Attribute label = AttributeFactory.createAttribute("label", 1);
        label.mapString("negative");
        label.mapString("positive");
        attributes.add(label);
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        for (int n = 0; n < numberOfExamples; ++n) {
            double[] features = new double[numberOfAttributes];
            for (int a = 0; a < features.length; ++a) {
                features[a] = RandomGenerator.getGlobalRandomGenerator().nextIntInRange(0, numberOfValues - 1) + 0;
            }
            double[] example = features;
            if (label != null) {
                example = new double[numberOfAttributes + 1];
                System.arraycopy(features, 0, example, 0, features.length);
                example[example.length - 1] = features[0] == 0.0 || features[1] == 0.0 ? (double)label.mapString("positive") : (double)label.mapString("negative");
            }
            table.addDataRow(new DoubleArrayDataRow(example));
        }
        return new IOObject[]{table.createCompleteExampleSet(label, null, null, null)};
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_examples", "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_of_attributes", "The number of attributes.", 0, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_of_values", "The number of nominal values for each attribute.", 0, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

