/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;

public class WeightingCrossover
implements PopulationOperator {
    private int type;
    private double prob;
    private RandomGenerator random;

    public WeightingCrossover(int type, double prob) {
        this.prob = prob;
        this.type = type;
        this.random = RandomGenerator.getGlobalRandomGenerator();
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public void crossover(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2) {
        switch (this.type) {
            case 0: {
                int n = 1 + this.random.nextInt(es1.getNumberOfAttributes() - 1);
                for (int i = n = es1.getExampleTable().getBlockEndIndex(n); i < es1.getNumberOfAttributes(); ++i) {
                    double dummy = es1.getWeight(i);
                    es1.setWeight(i, es2.getWeight(i));
                    es2.setWeight(i, dummy);
                }
                break;
            }
            case 1: {
                boolean[] swap = new boolean[es1.getNumberOfAttributes()];
                for (int i = 0; i < swap.length; ++i) {
                    boolean blockBoolean = this.random.nextBoolean();
                    int endIndex = es1.getExampleTable().getBlockEndIndex(i);
                    for (int j = i; j <= endIndex; ++j) {
                        if (j >= swap.length) continue;
                        swap[j] = blockBoolean;
                    }
                    i = endIndex;
                }
                this.swapWeights(es1, es2, swap);
                break;
            }
            case 2: {
                boolean[] swap = new boolean[es1.getNumberOfAttributes()];
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < swap.length; ++i) {
                    indices.add(new Integer(i));
                    i = es1.getExampleTable().getBlockEndIndex(i);
                }
                if (indices.size() > 0) {
                    int toSwap = RandomGenerator.getGlobalRandomGenerator().nextInt(indices.size() - 1) + 1;
                    for (int i = 0; i < toSwap; ++i) {
                        int index = (Integer)indices.remove(RandomGenerator.getGlobalRandomGenerator().nextInt(indices.size()));
                        int endIndex = es1.getExampleTable().getBlockEndIndex(index);
                        for (int j = i; j <= endIndex; ++j) {
                            if (j >= swap.length) continue;
                            swap[j] = true;
                        }
                    }
                }
                this.swapWeights(es1, es2, swap);
                break;
            }
        }
    }

    private void swapWeights(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2, boolean[] swap) {
        for (int i = 0; i < swap.length; ++i) {
            if (!swap[i]) continue;
            double dummy = es1.getWeight(i);
            es1.setWeight(i, es2.getWeight(i));
            es2.setWeight(i, dummy);
        }
    }

    public void operate(Population population) {
        if (population.getNumberOfIndividuals() < 2) {
            return;
        }
        int n = population.getNumberOfIndividuals();
        LinkedList<Object> matingPool = new LinkedList<Object>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            matingPool.add(population.get(i).clone());
        }
        LinkedList<Object> l = new LinkedList<Object>();
        while (matingPool.size() > 1) {
            AttributeWeightedExampleSet p1 = (AttributeWeightedExampleSet)matingPool.remove(this.random.nextInt(matingPool.size()));
            AttributeWeightedExampleSet p2 = (AttributeWeightedExampleSet)matingPool.remove(this.random.nextInt(matingPool.size()));
            if (this.random.nextDouble() < this.prob) {
                this.crossover(p1, p2);
                if (p1.getNumberOfUsedAttributes() > 0) {
                    l.add(p1);
                }
                if (p2.getNumberOfUsedAttributes() <= 0) continue;
                l.add(p2);
                continue;
            }
            l.add(p1);
            l.add(p2);
        }
        l.addAll(matingPool);
        population.clear();
        ListIterator i = l.listIterator();
        while (i.hasNext()) {
            population.add((AttributeWeightedExampleSet)i.next());
        }
    }
}

