/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.math.optimization.Optimization;
import edu.udo.cs.yale.tools.math.optimization.ec.pso.PSOOptimization;
import java.util.List;

public class PSOWeighting
extends OperatorChain {
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = PSOWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = PSOWeighting.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = PSOWeighting.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = PSOWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private Optimization optimization;
    private ExampleSet exampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public PSOWeighting(OperatorDescription description) {
        super(description);
        this.addValue(new Value("generation", "The number of the current generation."){

            public double getValue() {
                return PSOWeighting.this.optimization.getGeneration();
            }
        });
        this.addValue(new Value("performance", "The performance of the current generation (main criterion)."){

            public double getValue() {
                return PSOWeighting.this.optimization.getBestFitnessInGeneration();
            }
        });
        this.addValue(new Value("best", "The performance of the best individual ever (main criterion)."){

            public double getValue() {
                return PSOWeighting.this.optimization.getBestFitnessEver();
            }
        });
    }

    public IOObject[] apply() throws OperatorException {
        this.exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = PSOWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        this.optimization = new PSOWeightingOptimization(this, this.exampleSet.getNumberOfAttributes());
        this.optimization.optimize();
        double[] globalBestWeights = this.optimization.getBestValuesEver();
        AttributeWeightedExampleSet result = this.createWeightedExampleSet(globalBestWeights);
        AttributeWeights weights = new AttributeWeights();
        for (int i = 0; i < result.getNumberOfAttributes(); ++i) {
            Attribute attribute = result.getAttribute(i);
            weights.setWeight(attribute.getName(), globalBestWeights[i]);
        }
        return new IOObject[]{result, weights, this.optimization.getBestPerformanceEver()};
    }

    private PerformanceVector evaluateIndividual(double[] individual) throws OperatorException {
        boolean onlyZeros = true;
        for (int i = 0; i < individual.length; ++i) {
            if (individual[i] == 0.0) continue;
            onlyZeros = false;
            break;
        }
        if (onlyZeros) {
            return null;
        }
        AttributeWeightedExampleSet evaluationSet = this.createWeightedExampleSet(individual).createCleanExampleSet();
        Operator operatorChain = this.getOperator(0);
        IOObject[] operatorChainInput = new IOObject[]{evaluationSet};
        IOContainer innerResult = operatorChain.apply(this.getInput().append(operatorChainInput));
        return (PerformanceVector)innerResult.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = PSOWeighting.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
    }

    private AttributeWeightedExampleSet createWeightedExampleSet(double[] weights) {
        AttributeWeightedExampleSet result = new AttributeWeightedExampleSet((ExampleSet)this.exampleSet.clone());
        for (int i = 0; i < weights.length; ++i) {
            result.setWeight(i, weights[i]);
        }
        return result;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).checkIO(input);
        }
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = PSOWeighting.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, input)) {
            throw new IllegalInputException((Operator)this, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = PSOWeighting.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
        }
        return this.getDeliveredOutputClasses();
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return 1;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("population_size", "Number of individuals per generation.", 1, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("maximum_number_of_generations", "Number of generations after which to terminate the algorithm.", 1, Integer.MAX_VALUE, 30);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("generations_without_improval", "Stop criterion: Stop after n generations without improval of the performance (-1: perform all generations).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeDouble("inertia_weight", "The (initial) weight for the old weighting.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("local_best_weight", "The weight for the individual's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeDouble("global_best_weight", "The weight for the population's best position during run.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean("dynamic_inertia_weight", "If set to true the inertia weight is improved during run.", true));
        types.add(new ParameterTypeDouble("min_weight", "The lower bound for the weights.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble("max_weight", "The upper bound for the weights.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PSOWeightingOptimization
    extends PSOOptimization {
        private PSOWeighting op;

        public PSOWeightingOptimization(PSOWeighting op, int individualSize) {
            super(op.getParameterAsInt("population_size"), individualSize, op.getParameterAsInt("maximum_number_of_generations"), op.getParameterAsInt("generations_without_improval"), op.getParameterAsDouble("inertia_weight"), op.getParameterAsDouble("local_best_weight"), op.getParameterAsDouble("global_best_weight"), op.getParameterAsDouble("min_weight"), op.getParameterAsDouble("max_weight"), op.getParameterAsBoolean("dynamic_inertia_weight"));
            this.op = op;
        }

        public PerformanceVector evaluateIndividual(double[] individual) throws OperatorException {
            return this.op.evaluateIndividual(individual);
        }
    }
}

