/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaTools;
import java.util.LinkedList;
import java.util.List;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.AttributeEvaluator;
import weka.core.Instances;
import weka.core.OptionHandler;

public class GenericWekaAttributeWeighting
extends Operator {
    public static final String[] WEKA_ATTRIBUTE_EVALUATORS = WekaTools.getWekaClasses(class$weka$attributeSelection$AttributeEvaluator == null ? (class$weka$attributeSelection$AttributeEvaluator = GenericWekaAttributeWeighting.class$("weka.attributeSelection.AttributeEvaluator")) : class$weka$attributeSelection$AttributeEvaluator);
    private List wekaParameters = new LinkedList();
    static /* synthetic */ Class class$weka$attributeSelection$AttributeEvaluator;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;

    public GenericWekaAttributeWeighting(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = GenericWekaAttributeWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        AttributeWeights weights = new AttributeWeights();
        AttributeEvaluator evaluator = this.getWekaAttributeEvaluator(this.getOperatorClassName(), WekaTools.getWekaParametersFromTypes(this, this.wekaParameters));
        LogService.logMessage(this.getName() + ": Converting to Weka instances.", 0);
        Instances instances = WekaTools.toWekaInstances(exampleSet, "TempInstances", exampleSet.getLabel(), true);
        try {
            LogService.logMessage(this.getName() + ": Building Weka attribute evaluator.", 0);
            evaluator.buildEvaluator(instances);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 905, new Object[]{this.getOperatorClassName(), e});
        }
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute attribute = exampleSet.getAttribute(i);
            try {
                double result = evaluator.evaluateAttribute(i);
                weights.setWeight(attribute.getName(), result);
                continue;
            }
            catch (Exception e) {
                LogService.logMessage(this.getName() + ": Cannot evaluate attribute '" + attribute.getName() + "', use unknown weight.", 4);
            }
        }
        return new IOObject[]{exampleSet, weights};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = GenericWekaAttributeWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = GenericWekaAttributeWeighting.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights};
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = GenericWekaAttributeWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    private AttributeEvaluator getWekaAttributeEvaluator(String name, String[] parameters) throws OperatorException {
        String evaluatorName = null;
        for (int i = 0; i < WEKA_ATTRIBUTE_EVALUATORS.length; ++i) {
            if (!WEKA_ATTRIBUTE_EVALUATORS[i].endsWith(name)) continue;
            evaluatorName = WEKA_ATTRIBUTE_EVALUATORS[i];
            break;
        }
        AttributeEvaluator evaluator = null;
        try {
            evaluator = (AttributeEvaluator)ASEvaluation.forName(evaluatorName, (String[])parameters);
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{evaluatorName, e});
        }
        return evaluator;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        AttributeEvaluator evaluator = null;
        try {
            evaluator = this.getWekaAttributeEvaluator(this.getOperatorClassName(), null);
        }
        catch (OperatorException e) {
            throw new RuntimeException("Cannot instantiate Weka attribute evaluator " + this.getOperatorClassName() + ": " + e.getMessage());
        }
        this.wekaParameters = new LinkedList();
        if (evaluator != null && evaluator instanceof OptionHandler) {
            WekaTools.addParameterTypes((OptionHandler)evaluator, types, this.wekaParameters);
        }
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

