/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import java.util.List;

public class CorpusBasedFeatureWeighting
extends Operator {
    private static String TARGET_VALUE_NAME = "class_to_characterize";
    private double epsilon = 0.001;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;

    public CorpusBasedFeatureWeighting(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet es = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = CorpusBasedFeatureWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        String targetValue = this.getParameterAsString(TARGET_VALUE_NAME);
        double[] weights = this.generateWeightsForClass(es, targetValue);
        double maxWeight = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < weights.length; ++i) {
            if (!(weights[i] > maxWeight)) continue;
            maxWeight = weights[i];
        }
        maxWeight += this.epsilon;
        AttributeWeights attWeights = new AttributeWeights();
        for (int i = 0; i < es.getNumberOfAttributes(); ++i) {
            if (weights[i] > 0.0) {
                attWeights.setWeight(es.getAttribute(i).getName(), weights[i] / maxWeight);
                continue;
            }
            attWeights.setWeight(es.getAttribute(i).getName(), -1.0);
        }
        return new IOObject[]{es, attWeights};
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = CorpusBasedFeatureWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = CorpusBasedFeatureWeighting.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = CorpusBasedFeatureWeighting.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights};
    }

    private double[] generateWeightsForClass(ExampleSet es, String value) {
        double[] result = new double[es.getNumberOfAttributes()];
        for (int i = 0; i < es.getNumberOfAttributes(); ++i) {
            result[i] = 0.0;
        }
        ExampleReader er = es.getExampleReader();
        Attribute labelAttribute = es.getLabel();
        while (er.hasNext()) {
            Example e = er.next();
            if (!e.getValueAsString(labelAttribute).equalsIgnoreCase(value)) continue;
            for (int i = 0; i < es.getNumberOfAttributes(); ++i) {
                result[i] = result[i] + e.getValue(i);
            }
        }
        return result;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString(TARGET_VALUE_NAME, "The target class for which to find characteristic feature weights.", false));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

