/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GeneratingMutation
extends IndividualOperator {
    private List generators;
    private List originalAttributes;
    private double prob;
    private RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();
    private int maxDepth = -1;
    private String[] unusedFunctions = new String[0];

    public GeneratingMutation(List originalAttributes, double prob, List generators) {
        this.originalAttributes = originalAttributes;
        this.prob = prob;
        this.generators = generators;
    }

    public void setMaxConstructionDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public void setUnusedFunctions(String[] functions) {
        this.unusedFunctions = this.unusedFunctions;
    }

    public List operate(AttributeWeightedExampleSet exampleSet) throws Exception {
        LinkedList<AttributeWeightedExampleSet> l = new LinkedList<AttributeWeightedExampleSet>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)exampleSet.clone();
        double p = this.prob < 0.0 ? 1.0 / (double)clone.getNumberOfAttributes() : this.prob;
        p /= 4.0;
        try {
            this.addOriginalAttribute(clone, p);
            boolean generationPossible = this.addGeneratedAttribute(clone, p);
            this.deselect(clone, generationPossible ? 2 : 1, p);
        }
        catch (GenerationException e) {
            LogService.logMessage("GeneratingMutation: Exception occured during generation of attributes, using original example set instead.", 4);
            l.add(exampleSet);
        }
        if (clone.getNumberOfUsedAttributes() > 0) {
            Iterator i = exampleSet.getUserDataKeys().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                clone.setUserData(key, exampleSet.getUserData(key));
            }
            l.add(clone);
        } else {
            l.add(exampleSet);
        }
        return l;
    }

    private boolean addGeneratedAttribute(AttributeWeightedExampleSet exampleSet, double p) throws Exception {
        if (this.random.nextDouble() < p) {
            FeatureGenerator generator = FeatureGenerator.selectGenerator(exampleSet, this.generators, this.maxDepth, this.unusedFunctions);
            if (generator != null) {
                generator = generator.newInstance();
                Attribute[] args = Tools.getRandomCompatibleAttributes(exampleSet, generator, this.maxDepth, this.unusedFunctions);
                generator.setArguments(args);
                LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
                generatorList.add(generator);
                exampleSet.addAllAttributes(FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList));
                return true;
            }
            return false;
        }
        return false;
    }

    private void addOriginalAttribute(AttributeWeightedExampleSet exampleSet, double p) {
        int i;
        Attribute originalAttribute;
        if (this.random.nextDouble() < p && exampleSet.getAttribute((originalAttribute = (Attribute)this.originalAttributes.get(i = this.random.nextInt(this.originalAttributes.size()))).getName()) == null) {
            exampleSet.addAttribute(originalAttribute);
        }
    }

    private void deselect(AttributeWeightedExampleSet exampleSet, int m, double p) {
        int n = exampleSet.getNumberOfAttributes();
        for (int i = n - 1; i >= 0; --i) {
            if (!(this.random.nextDouble() < (double)m * p / (double)this.originalAttributes.size())) continue;
            exampleSet.removeAttribute(i);
        }
    }
}

