/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DirectedGeneratingMutation
extends IndividualOperator {
    private List generators;
    private Attribute[] originalAttributes;
    private double p;
    private int maxGeneratedAttributes = 2;
    private int maxAddedOriginalAttributes = 2;
    private int maxDepth = -1;
    private String[] unusableFunctions = new String[0];
    private RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();

    public DirectedGeneratingMutation(Attribute[] originalAttributes, double p, List generators, int maxGeneratedAttributes, int maxAddedOriginalAttributes, int maxDepth, String[] unusableFunctions) {
        this.originalAttributes = originalAttributes;
        this.p = p / (double)(maxGeneratedAttributes + maxAddedOriginalAttributes);
        this.generators = generators;
        this.maxGeneratedAttributes = maxGeneratedAttributes;
        this.maxAddedOriginalAttributes = maxAddedOriginalAttributes;
        this.maxDepth = maxDepth;
        this.unusableFunctions = unusableFunctions;
    }

    public List operate(AttributeWeightedExampleSet exampleSet) throws Exception {
        LinkedList<AttributeWeightedExampleSet> l = new LinkedList<AttributeWeightedExampleSet>();
        AttributeWeightedExampleSet clone = (AttributeWeightedExampleSet)exampleSet.clone();
        try {
            this.addOriginalAttribute(clone);
            this.addGeneratedAttribute(clone);
            this.deselect(clone, this.maxGeneratedAttributes + this.maxAddedOriginalAttributes);
            if (clone.getNumberOfUsedAttributes() > 0) {
                Iterator i = exampleSet.getUserDataKeys().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    clone.setUserData(key, exampleSet.getUserData(key));
                }
                l.add(clone);
            } else {
                l.add(exampleSet);
            }
        }
        catch (GenerationException e) {
            LogService.logMessage("DirectedGGA: Exception occured during generation of attributes, using original example set instead.", 4);
            l.add(exampleSet);
        }
        return l;
    }

    private void addGeneratedAttribute(AttributeWeightedExampleSet exampleSet) throws GenerationException {
        for (int i = 0; i < this.maxGeneratedAttributes; ++i) {
            FeatureGenerator generator;
            if (!(this.random.nextDouble() < this.p) || (generator = FeatureGenerator.selectGenerator(exampleSet, this.generators, this.maxDepth, this.unusableFunctions)) == null) continue;
            generator = generator.newInstance();
            Attribute[] args = Tools.getWeightedCompatibleAttributes(exampleSet, generator, this.maxDepth, this.unusableFunctions);
            generator.setArguments(args);
            LinkedList<FeatureGenerator> generatorList = new LinkedList<FeatureGenerator>();
            generatorList.add(generator);
            List result = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generatorList);
            double weightSum = 0.0;
            for (int j = 0; j < args.length; ++j) {
                weightSum += exampleSet.getWeight(args[j]);
            }
            weightSum /= (double)args.length;
            exampleSet.addAllAttributes(result);
            Iterator a = result.iterator();
            while (a.hasNext()) {
                Attribute att = (Attribute)a.next();
                exampleSet.setWeight(att, weightSum);
            }
        }
    }

    private void addOriginalAttribute(AttributeWeightedExampleSet exampleSet) {
        for (int j = 0; j < this.maxAddedOriginalAttributes; ++j) {
            if (!(this.random.nextDouble() < this.p)) continue;
            Attribute originalAttribute = this.originalAttributes[this.random.nextInt(this.originalAttributes.length)];
            double avgWeight = Tools.getAverageWeight(exampleSet);
            if (exampleSet.contains(originalAttribute)) continue;
            exampleSet.addAttribute(originalAttribute);
            exampleSet.setWeight(originalAttribute, avgWeight);
        }
    }

    private void deselect(AttributeWeightedExampleSet exampleSet, int numberNew) {
        int n = exampleSet.getNumberOfAttributes();
        double[] probs = Tools.getInverseProbabilitiesFromWeights(Tools.createAttributeArray(exampleSet), exampleSet);
        for (int i = n - 1; i >= 0; --i) {
            if (!(this.random.nextDouble() < this.p * probs[i] * (double)numberNew)) continue;
            exampleSet.removeAttribute(i);
        }
    }
}

