/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.ga.DirectedGeneratingMutation;
import edu.udo.cs.yale.operator.features.ga.YAGGA2;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

public class DirectedGGA
extends YAGGA2 {
    public DirectedGGA(OperatorDescription description) {
        super(description);
    }

    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) throws OperatorException {
        List generators = this.getGenerators();
        if (generators.size() == 0) {
            LogService.logMessage("No FeatureGenerators specified for " + this.getName() + ".", 4);
        }
        Attribute[] attributes = new Attribute[eSet.getNumberOfAttributes()];
        for (int i = 0; i < eSet.getNumberOfAttributes(); ++i) {
            attributes[i] = eSet.getAttribute(i);
        }
        return new DirectedGeneratingMutation(attributes, this.getParameterAsDouble("p_mutation"), generators, this.getParameterAsInt("max_generated"), this.getParameterAsInt("max_original"), this.getParameterAsInt("max_construction_depth"), this.getParameterAsString("unused_functions").split(" "));
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeInt("max_generated", "The maximum number of generated attributes per generation.", 1, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt("max_original", "The maximum number of original attributes added per generation.", 1, Integer.MAX_VALUE, 2));
        types.add(new ParameterTypeInt("max_construction_depth", "The maximum depth for the argument attributes used for attribute construction (-a: allow all depths).", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeString("unused_functions", "Space separated list of functions which are not allowed in arguments for attribute construction."));
        return types;
    }
}

