/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class Population {
    public static final Comparator PERFORMANCE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            PerformanceVector p1 = (PerformanceVector)((ExampleSet)o1).getUserData("performance");
            PerformanceVector p2 = (PerformanceVector)((ExampleSet)o2).getUserData("performance");
            return p1.compareTo(p2);
        }
    };
    private ArrayList individuals = new ArrayList();
    private int generation = 0;
    private AttributeWeightedExampleSet bestEver;
    private PerformanceVector bestPerformanceEver;
    private AttributeWeightedExampleSet lastBest;
    private int generationOfLastImproval = 0;

    public void clear() {
        this.individuals.clear();
    }

    public void add(AttributeWeightedExampleSet individual) {
        this.individuals.add(individual);
    }

    public void addAll(Collection newIndividuals) {
        this.individuals.addAll(newIndividuals);
    }

    public void remove(AttributeWeightedExampleSet individual) {
        this.individuals.remove(individual);
    }

    public void remove(int i) {
        this.individuals.remove(i);
    }

    public AttributeWeightedExampleSet get(int i) {
        return (AttributeWeightedExampleSet)this.individuals.get(i);
    }

    public int getNumberOfIndividuals() {
        return this.individuals.size();
    }

    public boolean empty() {
        return this.individuals.size() == 0;
    }

    public void nextGeneration() {
        ++this.generation;
    }

    public int getGeneration() {
        return this.generation;
    }

    public int getGenerationsWithoutImproval() {
        return this.generation - this.generationOfLastImproval;
    }

    public void updateEvaluation() {
        PerformanceVector lastBestPerformance;
        this.lastBest = this.best();
        PerformanceVector performanceVector = lastBestPerformance = this.lastBest == null ? null : (PerformanceVector)this.lastBest.getUserData("performance");
        if (this.bestEver == null || this.lastBest != null && lastBestPerformance.compareTo(this.bestPerformanceEver) > 0) {
            this.bestEver = (AttributeWeightedExampleSet)this.lastBest.clone();
            this.bestPerformanceEver = (PerformanceVector)this.bestEver.getUserData("performance");
            this.generationOfLastImproval = this.generation;
        }
    }

    private AttributeWeightedExampleSet best() {
        try {
            return (AttributeWeightedExampleSet)Collections.max(this.individuals, PERFORMANCE_COMPARATOR);
        }
        catch (NullPointerException e) {
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    public PerformanceVector bestPerformance() {
        return this.bestPerformanceEver;
    }

    public AttributeWeightedExampleSet bestEver() {
        return this.bestEver;
    }

    public AttributeWeightedExampleSet lastBest() {
        return this.lastBest;
    }

    public void sort() {
        Collections.sort(this.individuals, PERFORMANCE_COMPARATOR);
    }

    public String toString() {
        String s = "Generation: " + this.generation + ",size: " + this.getNumberOfIndividuals() + ", individual sizes: [";
        for (int i = 0; i < this.getNumberOfIndividuals(); ++i) {
            if (i > 0) {
                s = s + ",";
            }
            s = s + this.get(i).getNumberOfUsedAttributes();
        }
        return s + "]";
    }
}

