/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.WeightApplier;
import edu.udo.cs.yale.gui.StopDialog;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class FeatureOperator
extends OperatorChain {
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FeatureOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = FeatureOperator.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = FeatureOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FeatureOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private Population population;
    private WeightApplier weightApplier;
    private double maximalFitness = Double.POSITIVE_INFINITY;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public FeatureOperator(OperatorDescription description) {
        super(description);
        this.addValue(new Value("generation", "The number of the current generation."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return 0.0;
                }
                return FeatureOperator.this.population.getGeneration();
            }
        });
        this.addValue(new Value("performance", "The performance of the current generation (main criterion)."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                if (FeatureOperator.this.population.lastBest() == null) {
                    return Double.NaN;
                }
                PerformanceVector pv = (PerformanceVector)FeatureOperator.this.population.lastBest().getUserData("performance");
                if (pv == null) {
                    return Double.NaN;
                }
                return pv.getMainCriterion().getValue();
            }
        });
        this.addValue(new Value("best", "The performance of the best individual ever (main criterion)."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                PerformanceVector pv = FeatureOperator.this.population.bestPerformance();
                if (pv == null) {
                    return Double.NaN;
                }
                return pv.getMainCriterion().getValue();
            }
        });
        this.addValue(new Value("average_length", "The average number of attributes."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                double lengthSum = 0.0;
                for (int i = 0; i < FeatureOperator.this.population.getNumberOfIndividuals(); ++i) {
                    lengthSum += (double)FeatureOperator.this.population.get(i).getNumberOfUsedAttributes();
                }
                return lengthSum / (double)FeatureOperator.this.population.getNumberOfIndividuals();
            }
        });
        this.addValue(new Value("best_length", "The number of attributes of the best example set."){

            public double getValue() {
                if (FeatureOperator.this.population == null) {
                    return Double.NaN;
                }
                AttributeWeightedExampleSet eSet = FeatureOperator.this.population.bestEver();
                if (eSet != null) {
                    return eSet.getNumberOfUsedAttributes();
                }
                return Double.NaN;
            }
        });
    }

    public abstract Population createInitialPopulation(ExampleSet var1);

    public abstract List getPreEvaluationPopulationOperators(ExampleSet var1) throws OperatorException;

    public abstract List getPostEvaluationPopulationOperators(ExampleSet var1) throws OperatorException;

    public abstract boolean solutionGoodEnough(Population var1) throws OperatorException;

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).checkIO(input);
        }
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = FeatureOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, input)) {
            throw new IllegalInputException((Operator)this, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = FeatureOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
        }
        return this.getDeliveredOutputClasses();
    }

    public IOObject[] apply() throws OperatorException {
        this.maximalFitness = this.getParameterAsDouble("maximal_fitness");
        String weightApplierName = this.getParameterAsString("weight_applier");
        try {
            this.weightApplier = (WeightApplier)Class.forName(weightApplierName).newInstance();
        }
        catch (Exception e) {
            throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{this.getName(), e});
        }
        ExampleSet es = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FeatureOperator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        List preOps = this.getPreEvaluationPopulationOperators(es);
        List postOps = this.getPostEvaluationPopulationOperators(es);
        boolean userDialogOk = true;
        StopDialog stopDialog = null;
        if (this.getParameterAsBoolean("show_stop_dialog")) {
            stopDialog = new StopDialog("Stop Dialog", "<html>Press the stop button to abort the search for best feature space.<br>The best individual found so far is returned.</html>");
            stopDialog.setVisible(true);
        }
        this.population = this.createInitialPopulation((ExampleSet)es.clone());
        LogService.logMessage(this.getName() + ": initial population has " + this.population.getNumberOfIndividuals() + " individuals.", 2);
        this.evaluate(this.population);
        this.population.updateEvaluation();
        this.inApplyLoop();
        while (userDialogOk && !this.solutionGoodEnough(this.population) && !this.isMaximumReached()) {
            this.population.nextGeneration();
            this.applyOpList(preOps, this.population);
            LogService.logMessage(Tools.ordinalNumber(this.population.getGeneration()) + " generation has " + this.population.getNumberOfIndividuals() + " individuals.", 2);
            LogService.logMessage(this.getName() + ": evaluating " + Tools.ordinalNumber(this.population.getGeneration()) + " population.", 2);
            this.evaluate(this.population);
            this.population.updateEvaluation();
            this.inApplyLoop();
            this.applyOpList(postOps, this.population);
            userDialogOk = stopDialog == null ? true : stopDialog.isStillRunning();
        }
        if (stopDialog != null) {
            stopDialog.setVisible(false);
            stopDialog.dispose();
        }
        this.applyOpList(postOps, this.population);
        AttributeWeightedExampleSet weightedResultSet = this.population.bestEver();
        ExampleSet result = null;
        if (this.getParameterAsBoolean("apply_best_weights")) {
            weightedResultSet.setWeightApplier(this.weightApplier);
            result = weightedResultSet.createExampleSetFromWeights();
        } else {
            result = (ExampleSet)es.clone();
            for (int i = 0; i < weightedResultSet.getNumberOfAttributes(); ++i) {
                if (result.contains(weightedResultSet.getAttribute(i))) continue;
                result.addAttribute(weightedResultSet.getAttribute(i));
            }
        }
        AttributeWeights weights = new AttributeWeights();
        for (int i = 0; i < result.getNumberOfAttributes(); ++i) {
            Attribute attribute = result.getAttribute(i);
            double weight = 0.0;
            if (weightedResultSet.contains(attribute)) {
                weight = weightedResultSet.getWeight(attribute);
            }
            weights.setWeight(attribute.getName(), weight);
        }
        return new IOObject[]{result, weights, this.population.bestPerformance()};
    }

    void applyOpList(List opList, Population population) throws OperatorException {
        ListIterator i = opList.listIterator();
        while (i.hasNext()) {
            PopulationOperator op = (PopulationOperator)i.next();
            if (!op.performOperation(population.getGeneration())) continue;
            try {
                op.operate(population);
                for (int k = 0; k < population.getNumberOfIndividuals(); ++k) {
                    if (population.get(k).getNumberOfUsedAttributes() > 0) continue;
                    LogService.logMessage("Population operator " + op + " has produced an example set without attributes!", 6);
                }
            }
            catch (Exception e) {
                throw new UserError((Operator)this, (Throwable)e, 108, (Object)e.toString());
            }
        }
    }

    protected void evaluate(Population population) throws OperatorException {
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            AttributeWeightedExampleSet individual = population.get(i);
            this.evaluate(individual);
        }
    }

    protected PerformanceVector evaluate(AttributeWeightedExampleSet individual) throws OperatorException {
        individual.setWeightApplier(this.weightApplier);
        AttributeWeightedExampleSet clone = individual.createCleanExampleSet();
        Operator operatorChain = this.getOperator(0);
        IOObject[] operatorChainInput = new IOObject[]{clone};
        IOContainer innerResult = operatorChain.apply(this.getInput().append(operatorChainInput));
        if (this.getParameterAsBoolean("set_inner_weights")) {
            try {
                AttributeWeights weightVector = (AttributeWeights)innerResult.remove(class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = FeatureOperator.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights);
                LogService.logMessage("Applying weights created by inner operator.", 2);
                Iterator i = weightVector.getAttributeNames().iterator();
                while (i.hasNext()) {
                    String attName = (String)i.next();
                    individual.setWeight(individual.getAttribute(attName), weightVector.getWeight(attName));
                }
            }
            catch (MissingIOObjectException e) {
                LogService.logMessage("No weights created by inner operator. Using weights from example set.", 2);
            }
        }
        PerformanceVector performanceVector = (PerformanceVector)innerResult.remove(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = FeatureOperator.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
        individual.setUserData("performance", performanceVector);
        return performanceVector;
    }

    private boolean isMaximumReached() {
        AttributeWeightedExampleSet eSet = this.population.bestEver();
        if (eSet != null) {
            PerformanceVector pv = (PerformanceVector)eSet.getUserData("performance");
            if (pv == null) {
                return false;
            }
            if (pv.getMainCriterion().getFitness() == Double.POSITIVE_INFINITY) {
                return true;
            }
            if (pv.getMainCriterion().getMaxFitness() == pv.getMainCriterion().getFitness()) {
                return true;
            }
            return pv.getMainCriterion().getFitness() >= this.maximalFitness;
        }
        return false;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getNumberOfSteps() {
        return 1;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeBoolean type = new ParameterTypeBoolean("show_stop_dialog", "Determines if a dialog with a button should be displayed which stops the run: the best individual is returned.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("apply_best_weights", "Determines if the attributes of the result example set should be selected or weighted or if the original example set should be returned.", true));
        types.add(new ParameterTypeBoolean("set_inner_weights", "Determines if weights calculated during evaluation should be applied to the individuals.", true));
        types.add(new ParameterTypeStringCategory("weight_applier", "The fully qualified classname of the weight applier.", new String[]{"edu.udo.cs.yale.example.ScalingWeightApplier", "edu.udo.cs.yale.example.DummyWeightApplier"}, "edu.udo.cs.yale.example.ScalingWeightApplier"));
        types.add(new ParameterTypeDouble("maximal_fitness", "The optimization will stop if the fitness reaches the defined maximum.", 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

