/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeParser;
import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.example.Tools;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.operator.features.IndividualOperator;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class EquivalentAttributeRemoval
extends IndividualOperator {
    private int numberOfSamples = 5;
    private double epsilon = 0.05;
    private boolean recalculateAttributeStatistics = false;

    public EquivalentAttributeRemoval(int numberOfSamples, double epsilon, boolean recalculateAttributeStatistics) {
        this.numberOfSamples = numberOfSamples;
        this.epsilon = epsilon;
        this.recalculateAttributeStatistics = recalculateAttributeStatistics;
    }

    public List operate(AttributeWeightedExampleSet exampleSet) {
        if (this.recalculateAttributeStatistics) {
            exampleSet.recalculateAllAttributeStatistics();
        }
        Attribute[] allAttributes = exampleSet.getExampleTable().getAttributes();
        ArrayList<Attribute> simpleAttributesList = new ArrayList<Attribute>();
        for (int i = 0; i < allAttributes.length; ++i) {
            if (allAttributes[i] == null || allAttributes[i].isGenerated()) continue;
            simpleAttributesList.add(allAttributes[i]);
        }
        HashMap<String, Attribute> removeMap = new HashMap<String, Attribute>();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            for (int j = i + 1; j < exampleSet.getNumberOfAttributes(); ++j) {
                Attribute att2;
                Attribute att1 = exampleSet.getAttribute(i);
                if (att1.equalConstructionDescription(att2 = exampleSet.getAttribute(j))) {
                    removeMap.put(att2.getName(), att2);
                    continue;
                }
                MemoryExampleTable exampleTable = new MemoryExampleTable(simpleAttributesList, this.numberOfSamples);
                try {
                    int depth2;
                    AttributeParser parser = new AttributeParser(exampleTable);
                    parser.parse(att1.getConstructionDescription(false));
                    parser.parse(att2.getConstructionDescription(false));
                    Tools.fillTableWithRandomValues(exampleTable);
                    SimpleExampleSet randomSet = new SimpleExampleSet((ExampleTable)exampleTable, new LinkedList());
                    parser.generateAll(randomSet);
                    if (!this.equivalent(randomSet)) continue;
                    int depth1 = att1.getConstructionDepth();
                    if (depth1 > (depth2 = att2.getConstructionDepth())) {
                        removeMap.put(att1.getName(), att1);
                        continue;
                    }
                    removeMap.put(att2.getName(), att2);
                    continue;
                }
                catch (GenerationException e) {
                    LogService.logMessage("Cannot generate test attribute: " + e.getMessage() + ". We just keep both attributes for sure...", 4);
                }
            }
        }
        Iterator i = removeMap.values().iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            LogService.logMessage("Remove equivalent attribute '" + attribute.getName() + "'.", 2);
            exampleSet.removeAttribute(attribute);
        }
        LinkedList<AttributeWeightedExampleSet> l = new LinkedList<AttributeWeightedExampleSet>();
        l.add(exampleSet);
        return l;
    }

    private boolean equivalent(ExampleSet exampleSet) {
        Attribute a2;
        if (exampleSet.getNumberOfAttributes() < 2) {
            return true;
        }
        ExampleReader reader = exampleSet.getExampleReader();
        Attribute a1 = exampleSet.getAttribute(0);
        if (((Object)a1).equals(a2 = exampleSet.getAttribute(1))) {
            return true;
        }
        while (reader.hasNext()) {
            Example example = reader.next();
            if (!(Math.abs(example.getValue(a1) - example.getValue(a2)) > this.epsilon)) continue;
            return false;
        }
        return true;
    }
}

